/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.bigdata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.bigdata.BigDataAccessParameters;
import oracle.javatools.db.ora.bigdata.BigDataJsonEntry;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.Tuple;

public final class BigDataAccessParameterMetadata {
    public static final String ADDITIONAL = "com.oracle.bigdata.ad";
    public static final String TABLENAME = "com.oracle.bigdata.tablename";
    public static final String FIELDCOUNT = "com.oracle.bigdata.fieldcount";
    public static final String FIELDS = "com.oracle.bigdata.fields";
    public static final String FILEFORMAT = "com.oracle.bigdata.fileformat";
    public static final String ROWFORMAT = "com.oracle.bigdata.rowformat";
    public static final String CLASS = "com.oracle.bigdata.class";
    public static final String COLMAP = "com.oracle.bigdata.colmap";
    public static final String CLUSTER = "com.oracle.bigdata.cluster";
    public static final String DATEMASK = "com.oracle.bigdata.datemask";
    public static final String ERROROPT = "com.oracle.bigdata.erroropt";
    public static final String LOG_EXEC = "com.oracle.bigdata.log.exec";
    public static final String LOG_OPT = "com.oracle.bigdata.log.opt";
    public static final String LOG_QC = "com.oracle.bigdata.log.qc";
    public static final String MAXLEN = "com.oracle.bigdata.maxlen";
    public static final String OVERFLOW = "com.oracle.bigdata.overflow";
    public static final String TBLPROPERTIES = "com.oracle.bigdata.tblproperties";
    public static final String DATAMODE = "com.oracle.bigdata.datamode";
    private static final String NONE = "NONE";
    private static final String NORMAL = "NORMAL";
    private static final String TEXTFILE = "TEXTFILE";
    private static final String SEQUENCEFILE = "SEQUENCEFILE";
    private static final String RCFILE = "RCFILE";
    private static final String INPUTFORMAT = "INPUTFORMAT '<input_class>' OUTPUTFORMAT '<output_class>'";
    private static final String DELIMITED = "DELIMITED";
    private static final String DELIMITED_FIELDS = "DELIMITED FIELDS TERMINATED BY '<char>'";
    private static final String DELIMITED_FIELDS_ESC = "DELIMITED FIELDS TERMINATED BY '<char>' ESCAPED BY '<char>'";
    private static final String DELIMITED_COLLECTION_ITEMS = "DELIMITED COLLECTION ITEMS TERMINATED BY '<char>'";
    private static final String DELIMITED_MAP_KEY = "DELIMITED MAP KEYS TERMINATED BY '<char>'";
    private static final String DELIMITED_LINES = "DELIMITED LINES TERMINATED BY '<char>'";
    private static final String SERDE = "SERDE '<serde_name>'";
    private static final String SERDE_WITH_PROPS = "SERDE '<serde_name>' WITH SERDEPROPERTIES ( \"name\" = \"value\" )";
    private static final String AUTOMATIC = "automatic";
    private static final String JAVA = "java";
    private static final String C = "c";

    public static String stripLineEscapes(String str) {
        StringBuilder buff = new StringBuilder();
        BufferedReader r = new BufferedReader(new StringReader(str));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                if (buff.length() > 0) {
                    buff.append("\n");
                }
                int end = line.length();
                if (line.endsWith("\\")) {
                    --end;
                }
                buff.append(line, 0, end);
            }
            return buff.toString();
        }
        catch (IOException ioe) {
            return str.replaceAll("\\\\\\r?\\n", "\n");
        }
    }

    public static String checkLineBreaks(String str) {
        String retval = null;
        if (str != null) {
            StringBuilder buff = new StringBuilder();
            String nl = "\\";
            BufferedReader r = new BufferedReader(new StringReader(str));
            try {
                String line = r.readLine();
                while (line != null) {
                    String next = r.readLine();
                    buff.append(line);
                    if (next != null) {
                        if (!line.endsWith("\\")) {
                            buff.append("\\");
                        }
                        buff.append("\n");
                    }
                    line = next;
                }
                retval = buff.toString();
            }
            catch (IOException ioe) {
                retval = str;
            }
        }
        return retval;
    }

    public static boolean isBigDataAccessDriver(String driver) {
        return "ORACLE_HIVE".equals(driver) || "ORACLE_HDFS".equals(driver) || "ORACLE_BIGDATA".equals(driver);
    }

    public static boolean isAdditionalAccessParameter(String name) {
        return name.startsWith(ADDITIONAL);
    }

    public static Collection<String> getAllowedParameterNames(String driver) {
        TreeSet<String> retval = null;
        if (BigDataAccessParameterMetadata.isBigDataAccessDriver(driver)) {
            retval = new TreeSet<String>();
            boolean bigData = "ORACLE_BIGDATA".equals(driver);
            if (bigData) {
                retval.add(CLASS);
            }
            if (bigData || "ORACLE_HIVE".equals(driver)) {
                retval.add(TABLENAME);
            }
            if (bigData || "ORACLE_HDFS".equals(driver)) {
                retval.add(FIELDCOUNT);
                retval.add(FIELDS);
                retval.add(FILEFORMAT);
                retval.add(ROWFORMAT);
                retval.add(TBLPROPERTIES);
            }
            retval.add(COLMAP);
            retval.add(CLUSTER);
            retval.add(DATEMASK);
            retval.add(ERROROPT);
            retval.add(LOG_EXEC);
            retval.add(LOG_OPT);
            retval.add(LOG_QC);
            retval.add(MAXLEN);
            retval.add(OVERFLOW);
            retval.add(DATAMODE);
        }
        return retval;
    }

    public static boolean isLocationParameter(String paramName) {
        return LOG_EXEC.equals(paramName) || LOG_QC.equals(paramName);
    }

    public static boolean hasAllowedParameterValues(String paramName, Relation relation, DBObjectProvider pro) {
        return LOG_OPT.equals(paramName) || FILEFORMAT.equals(paramName) || ROWFORMAT.equals(paramName) || DATAMODE.equals(paramName) || CLUSTER.equals(paramName) && pro != null && pro.supportsObjectType("DIRECTORY");
    }

    public static List<String> getAllowedParameterValues(String paramName, Relation relation, DBObjectProvider pro) {
        List<Object> retval = null;
        if (LOG_OPT.equals(paramName)) {
            retval = Arrays.asList(NONE, NORMAL);
        } else if (CLUSTER.equals(paramName)) {
            String PREFIX = "ORA_BIGDATA_CL_";
            retval = new ArrayList();
            DBObjectCriteria<Directory> crit = new DBObjectCriteria<Directory>(Directory.class, new String[0]);
            crit.setSchemaName("SYS");
            crit.setNameLike("ORA_BIGDATA_CL_" + DBObjectCriteria.LIKE_WILDCARD);
            try {
                for (Directory dir : pro.listObjects(crit)) {
                    String name = dir.getName();
                    if (name == null || !name.startsWith("ORA_BIGDATA_CL_")) continue;
                    retval.add(name.substring("ORA_BIGDATA_CL_".length()));
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger(BigDataAccessParameters.class).warning(dbe.getMessage());
            }
        } else if (FILEFORMAT.equals(paramName)) {
            retval = Arrays.asList(INPUTFORMAT, RCFILE, SEQUENCEFILE, TEXTFILE);
        } else if (ROWFORMAT.equals(paramName)) {
            retval = Arrays.asList(DELIMITED, DELIMITED_COLLECTION_ITEMS, DELIMITED_FIELDS, DELIMITED_FIELDS_ESC, DELIMITED_LINES, DELIMITED_MAP_KEY, SERDE, SERDE_WITH_PROPS);
        } else if (DATAMODE.equals(paramName)) {
            retval = Arrays.asList(AUTOMATIC, C, JAVA);
        }
        return retval;
    }

    public static TemplateValue getParameterTemplateValue(String paramName) {
        String before = null;
        String val = null;
        String after = null;
        Tuple<String, String> entries = BigDataJsonEntry.getJsonEntryNames(paramName);
        if (entries != null) {
            val = BigDataJsonEntry.getDefaultValueString((String)entries.object1(), paramName);
            String marker = "DUMMY";
            BigDataJsonEntry dummyEntry = new BigDataJsonEntry((String)entries.object1(), new SimpleSQLFragment("DUMMY"));
            String sql = dummyEntry.getSQLText();
            String[] toks = sql.split("DUMMY");
            if (toks.length == 1 || toks.length == 2) {
                String entry2;
                before = "{" + toks[0];
                StringBuilder buff = new StringBuilder();
                if (toks.length == 2) {
                    buff.append(toks[1]);
                }
                if (!BigDataJsonEntry.isJsonEntryOptional(paramName, entry2 = (String)entries.object2())) {
                    BigDataJsonEntry dummyEntry2 = new BigDataJsonEntry((String)entries.object2(), new SimpleSQLFragment(""));
                    buff.append(", ").append(dummyEntry2.getSQLText());
                }
                buff.append("}");
                after = buff.toString();
            }
        } else if (LOG_OPT.equals(paramName)) {
            val = NONE;
        } else if (FILEFORMAT.equals(paramName)) {
            val = TEXTFILE;
        } else if (ROWFORMAT.equals(paramName)) {
            val = DELIMITED;
        } else if (DATAMODE.equals(paramName)) {
            val = JAVA;
        }
        return before == null && val == null ? null : new TemplateValue(before, val, after);
    }

    public static class TemplateValue {
        private final String m_before;
        private final String m_val;
        private final String m_after;

        private TemplateValue(String before, String val, String after) {
            this.m_before = before;
            this.m_val = val;
            this.m_after = after;
        }

        public String getBefore() {
            return this.m_before;
        }

        public String getValue() {
            return this.m_val;
        }

        public String getAfter() {
            return this.m_after;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            this.appendIfNotNull(buff, this.m_before);
            this.appendIfNotNull(buff, this.m_val);
            this.appendIfNotNull(buff, this.m_after);
            return buff.toString();
        }

        private void appendIfNotNull(StringBuilder buff, String s) {
            if (s != null) {
                buff.append(s);
            }
        }
    }
}

