/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.Nullable;
import oracle.javatools.db.property.TextProperty;
import oracle.javatools.db.property.Transient;

public class DatabaseLink
extends AbstractSchemaObject {
    public static final String TYPE = "DATABASE LINK";
    public static final String PUBLIC_TYPE = "PUBLIC DATABASE LINK";

    public DatabaseLink() {
        this(null, null, null);
    }

    public DatabaseLink(String name, Schema schema, DBObjectID id) {
        super(name, schema, id);
        this.setPublic(false);
        this.setShared(false);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean isPublic() {
        return (Boolean)this.getProperty("public", false);
    }

    public void setPublic(boolean pub) {
        this.setProperty("public", pub);
    }

    public boolean isShared() {
        return (Boolean)this.getProperty("shared", false);
    }

    public void setShared(boolean shared) {
        this.setProperty("shared", shared);
    }

    @Deprecated
    @Transient
    public boolean isCurrentUser() {
        return Boolean.TRUE.equals(this.getConnectToUser());
    }

    @Deprecated
    @Transient
    public void setCurrentUser(boolean currentUser) {
        this.setConnectToUser(currentUser);
    }

    @Nullable(value=Nullable.NullBehaviour.NULLABLE)
    public Boolean getConnectToUser() {
        return (Boolean)this.getProperty("connectToUser");
    }

    public void setConnectToUser(Boolean connectToUser) {
        this.setProperty("connectToUser", connectToUser);
    }

    public String getUsername() {
        return (String)this.getProperty("username");
    }

    public void setUsername(String username) {
        this.setProperty("username", username);
    }

    @Transient
    @TextProperty(password=true)
    public String getPassword() {
        return (String)this.getProperty("password");
    }

    @Transient
    public void setPassword(String password) {
        this.setProperty("password", password);
    }

    @Transient
    @TextProperty(password=true)
    public String getPasswordX() {
        return (String)this.getProperty("passwordX");
    }

    @Transient
    public void setPasswordX(String encryptedPassword) {
        this.setProperty("passwordX", encryptedPassword);
    }

    @TextProperty(multiLine=true)
    public String getHost() {
        return (String)this.getProperty("host");
    }

    public void setHost(String host) {
        this.setProperty("host", host);
    }

    public String getCreated() {
        return (String)this.getProperty("created");
    }

    public void setCreated(String created) {
        this.setProperty("created", created);
    }

    @Deprecated
    public DBObjectProvider getDBLink() {
        return null;
    }

    @Deprecated
    public String getAuthentificationUser() {
        return this.getAuthentificationUsername();
    }

    public String getAuthentificationUsername() {
        return (String)this.getProperty("authentificationUsername");
    }

    public void setAuthentificationUsername(String authentificationUsername) {
        this.setProperty("authentificationUsername", authentificationUsername);
    }

    @Transient
    @TextProperty(password=true)
    public String getAuthentificationPassword() {
        return (String)this.getProperty("authentificationPassword");
    }

    @Transient
    public void setAuthentificationPassword(String authentificationPassword) {
        this.setProperty("authentificationPassword", authentificationPassword);
    }

    @Transient
    @TextProperty(password=true)
    public String getAuthentificationPasswordX() {
        return (String)this.getProperty("authentificationPasswordX");
    }

    @Transient
    public void setAuthentificationPasswordX(String encryptedPassword) {
        this.setProperty("authentificationPasswordX", encryptedPassword);
    }

    @Deprecated
    public static interface DefaultSchemaFinder {
        public Schema findDefaultSchema(DatabaseLink var1);
    }
}

