/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.internal;

import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.util.deferred.Thunk;

public class ClassThunk<T>
extends Thunk<T> {
    private final String m_className;
    private final ClassLoader m_classLoader;
    private final Class<T> m_apiClass;
    private final T m_instance;

    public ClassThunk(String className, ClassLoader classLoader, Class<T> apiClass) {
        this.m_className = className;
        this.m_classLoader = classLoader;
        this.m_apiClass = apiClass;
        this.m_instance = null;
    }

    public ClassThunk(T instance) {
        this.m_apiClass = instance.getClass();
        this.m_className = this.m_apiClass.getName();
        this.m_classLoader = this.m_apiClass.getClassLoader();
        this.m_instance = instance;
    }

    public String getClassName() {
        return this.m_className;
    }

    protected T compute() {
        T retval = this.m_instance;
        if (retval == null) {
            try {
                ClassLoader actualLoader = this.m_classLoader == null ? DBCore.getImplClassLoader() : this.m_classLoader;
                Class<?> clz = actualLoader.loadClass(this.m_className);
                retval = this.m_apiClass.cast(clz.newInstance());
            }
            catch (Exception e) {
                DBLog.getLogger(this.m_apiClass).log(Level.SEVERE, "Cannot create " + this.m_className + " as a " + this.m_apiClass.getSimpleName(), e);
            }
        }
        return retval;
    }
}

