/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.extension;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.extension.DatabaseMatcher;
import oracle.javatools.db.extension.MatcherCache;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.util.deferred.Thunk;

public final class DBObjectRegistry {
    private MatcherCache.ClassCache<DBObjectValidator> m_validators = new MatcherCache.ClassCache();
    private MatcherCache.ClassCache<DBObjectBuilder> m_builders = new MatcherCache.ClassCache();
    private MatcherCache.ClassCache<DBObjectLister> m_lists = new MatcherCache.ClassCache();
    private MatcherCache.ClassCache<DDLGenerator> m_ddlgens = new MatcherCache.ClassCache();

    public Map<String, DBObjectValidator> getValidators(String dbType, int version, DBObjectProvider pro) {
        Map clzMap = this.m_validators.getAllClasses(dbType, version);
        return this.instantiateClasses(clzMap, pro, false);
    }

    public Map<String, DBObjectBuilder> getBuilders(String dbType, int version, DBObjectProvider pro) {
        Map clzMap = this.m_builders.getAllClasses(dbType, version);
        return this.instantiateClasses(clzMap, pro, false);
    }

    public Map<String, DBObjectLister> getListers(String dbType, int version, DBObjectProvider pro) {
        Map clzMap = this.m_lists.getAllClasses(dbType, version);
        return this.instantiateClasses(clzMap, pro, false);
    }

    public Map<String, DDLGenerator> getDDLGenerators(Database db) {
        return this.getDDLGenerators(db.getDatabaseType(), db.getDatabaseVersion(), db.getClass(), db);
    }

    public Map<String, DDLGenerator> getDDLGenerators(String dbType, int version, Class<? extends Database> dbClz, DBObjectProvider pro) {
        Map clzMap = this.m_ddlgens.getAllClasses(dbType, version);
        Map oldGens = this.instantiateClasses(clzMap, pro, true);
        Map newGens = this.instantiateClasses(clzMap, new Class[]{Class.class, DBObjectProvider.class}, new Object[]{dbClz, pro});
        for (Map.Entry entry : oldGens.entrySet()) {
            String key = entry.getKey();
            if (newGens.containsKey(key)) continue;
            newGens.put(key, entry.getValue());
        }
        return newGens;
    }

    private <T> Map<String, T> instantiateClasses(Map<String, Class<? extends T>> clzMap, DBObjectProvider pro, boolean allowFail) {
        TreeMap retval = new TreeMap();
        if (clzMap != null) {
            for (Map.Entry<String, Class<T>> entry : clzMap.entrySet()) {
                Class<T> clz = entry.getValue();
                try {
                    boolean found = false;
                    Throwable constructorException = null;
                    for (Constructor<?> c : clz.getConstructors()) {
                        Class<?>[] params = c.getParameterTypes();
                        if (params == null || params.length != 1 || !DBObjectProvider.class.isAssignableFrom(params[0])) continue;
                        try {
                            found = true;
                            constructorException = null;
                            Object v = c.newInstance(pro);
                            retval.put(entry.getKey(), v);
                            break;
                        }
                        catch (InvocationTargetException ite) {
                            constructorException = ite.getCause();
                        }
                        catch (Exception e) {
                            constructorException = e;
                        }
                    }
                    if (!found) {
                        DBLog.getLogger(this).log(allowFail ? Level.FINE : Level.SEVERE, "Class {0} is missing constructor that takes a DBObjectProvider", new String[]{clz.getName()});
                        continue;
                    }
                    if (constructorException == null) continue;
                    DBLog.getLogger(this).log(Level.SEVERE, "Could not instaniate " + clz.getName(), constructorException);
                }
                catch (Exception e) {
                    DBLog.getLogger(this).log(Level.SEVERE, "Could not process class:" + clz.getName(), e);
                }
            }
        }
        return retval;
    }

    private <T> Map<String, T> instantiateClasses(Map<String, Class<? extends T>> clzMap, Class[] constructorParamTypes, Object[] constructorParams) {
        TreeMap<String, T> retval = new TreeMap<String, T>();
        if (clzMap != null) {
            for (Map.Entry<String, Class<T>> entry : clzMap.entrySet()) {
                Class<T> clz = entry.getValue();
                try {
                    Constructor<T> c = clz.getConstructor(constructorParamTypes);
                    T v = c.newInstance(constructorParams);
                    retval.put(entry.getKey(), v);
                }
                catch (NoSuchMethodException nsme) {
                    DBLog.getLogger(this).log(Level.SEVERE, "Class {0} is missing constructor that takes param types: {1}", new String[]{clz.getName(), Arrays.asList(constructorParamTypes).toString()});
                }
                catch (InvocationTargetException ite) {
                    DBLog.getLogger(this).log(Level.SEVERE, "Error from constructor of class " + clz.getName(), ite.getCause());
                }
                catch (Exception e) {
                    DBLog.getLogger(this).log(Level.SEVERE, "Could not process class:" + clz.getName(), e);
                }
            }
        }
        return retval;
    }

    public void registerObject(String objType, DatabaseMatcher dbMatch, Class<? extends DBObjectValidator> validatorClz, Class<? extends DBObjectBuilder> builderClz, Class<? extends DBObjectLister> listClz, Class<? extends DDLGenerator> ddlGenClz) {
        this.m_validators.putClass(objType, validatorClz, dbMatch);
        this.m_builders.putClass(objType, builderClz, dbMatch);
        this.m_lists.putClass(objType, listClz, dbMatch);
        this.m_ddlgens.putClass(objType, ddlGenClz, dbMatch);
    }

    public void registerObject(String objType, DatabaseMatcher dbMatch, Thunk<Class<? extends DBObjectValidator>> validatorClz, Thunk<Class<? extends DBObjectBuilder>> builderClz, Thunk<Class<? extends DBObjectLister>> listClz, Thunk<Class<? extends DDLGenerator>> ddlGenClz) {
        this.m_validators.put(objType, (DBObjectValidator)validatorClz, dbMatch);
        this.m_builders.put(objType, (DBObjectBuilder)builderClz, dbMatch);
        this.m_lists.put(objType, (DBObjectLister)listClz, dbMatch);
        this.m_ddlgens.put(objType, (DDLGenerator)ddlGenClz, dbMatch);
    }

    public void registerClass(String objType, Class<? extends DBObject> objClz) {
        if (objType == null) {
            throw new IllegalArgumentException("object type must be defined");
        }
        if (!DBObject.class.isAssignableFrom(objClz)) {
            throw new IllegalArgumentException("object class must subclass DBObject");
        }
        Metadata.getInstance().registerObjectClass(objType, objClz);
    }

    public void registerClass(String objType, Thunk<Class<? extends DBObject>> objClz) {
        if (objType == null) {
            throw new IllegalArgumentException("object type must be defined");
        }
        Metadata.getInstance().registerObjectClass(objType, objClz);
    }

    public static synchronized DBObjectRegistry getInstance() {
        DBCore core = DBCore.getInstance();
        DBObjectRegistry reg = core.get(DBObjectRegistry.class);
        if (reg == null) {
            reg = new DBObjectRegistry();
            core.put(reg);
        }
        return reg;
    }

    public static boolean isActive() {
        DBCore core = DBCore.getInstance();
        DBObjectRegistry reg = core.get(DBObjectRegistry.class);
        return reg != null;
    }

    public static boolean isExtensionType(String objType, String dbType, int dbVersion) {
        boolean retval = false;
        if (DBObjectRegistry.isActive()) {
            Map map = DBObjectRegistry.getInstance().m_ddlgens.getAll(dbType, dbVersion);
            retval = map != null && map.containsKey(objType);
        }
        return retval;
    }
}

