/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.event;

import java.beans.PropertyChangeEvent;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectListener;
import oracle.javatools.db.property.Property;

public abstract class DBObjectPropertyListener
extends DBObjectListener {
    private final String[] m_properties;

    public DBObjectPropertyListener(String ... properties) {
        this.m_properties = properties;
        if (this.m_properties == null || this.m_properties.length == 0) {
            throw new IllegalArgumentException("must specify properties to listen for");
        }
    }

    @Override
    public final void objectUpdated(DBObjectChange change) {
        DBObject obj = change.getDBObject();
        for (String prop : this.m_properties) {
            DBObjectChange current = change;
            String[] path = Property.getProperties(prop);
            block1: for (int i = 0; i < path.length - 1; ++i) {
                Map<DBObject, DBObjectChange> childChanges = current.getOwnedObjectsUpdated();
                for (Map.Entry<DBObject, DBObjectChange> entry : childChanges.entrySet()) {
                    String propOnParent = DBUtil.getParentProperty(entry.getKey());
                    if (!path[i].equals(propOnParent)) continue;
                    current = entry.getValue();
                    continue block1;
                }
            }
            PropertyChangeEvent pce = current.getPropertyChange(path[path.length - 1]);
            if (pce == null) continue;
            this.propertyChanged(obj, prop, pce);
        }
    }

    protected abstract void propertyChanged(DBObject var1, String var2, PropertyChangeEvent var3);
}

