/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.event;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.util.DBObjectMap;
import oracle.javatools.util.ModelUtil;

public class DBObjectChange {
    public static final String NAME_PROPERTY = "name";
    private DBObject m_obj;
    private DBObjectProvider m_pro;
    private static final String ADD_KEY = "ADDED";
    private static final String KID_KEY = "CHILDREN";
    private static final String PROP_KEY = "PROPERTIES";
    private static final String DEL_KEY = "REMOVED";
    private static final String ORD_KEY = "ORDERED";

    protected DBObjectChange(DBObject obj, DBObjectProvider pro) {
        this.m_obj = obj;
        this.m_pro = pro;
    }

    public DBObjectProvider getProvider() {
        return this.m_pro;
    }

    public DBObject getDBObject() {
        return this.m_obj;
    }

    public List<DBObject> getOwnedObjectsAdded() {
        return Collections.emptyList();
    }

    public List<DBObject> getOwnedObjectsRemoved() {
        return Collections.emptyList();
    }

    public Map<String, PropertyChangeEvent> getPropertiesChanged() {
        return Collections.emptyMap();
    }

    public PropertyChangeEvent getPropertyChange(String propertyName) {
        return this.getPropertiesChanged().get(propertyName);
    }

    public Map<DBObject, DBObjectChange> getOwnedObjectsUpdated() {
        return Collections.emptyMap();
    }

    public Collection<String> getAllChangedProperties() {
        Collection<String> retval;
        Set<DBObject> ownedObjs = this.getOwnedObjectsUpdated().keySet();
        if (ownedObjs.isEmpty()) {
            retval = this.getPropertiesChanged().keySet();
        } else {
            retval = new ArrayList();
            retval.addAll(this.getPropertiesChanged().keySet());
            for (DBObject obj : ownedObjs) {
                String parentProp = DBUtil.getParentProperty(obj);
                if (parentProp == null) continue;
                retval.add(parentProp);
            }
        }
        return retval;
    }

    public boolean hasNameChanged() {
        PropertyChangeEvent event = this.getPropertyChange(NAME_PROPERTY);
        return event != null;
    }

    public static DBObjectChange merge(DBObjectChange ... changes) {
        DBObjectChange retval;
        if (!ModelUtil.hasNonNullElement((Object[])changes)) {
            throw new IllegalArgumentException("Missing changes to merge");
        }
        if (changes.length == 1) {
            retval = changes[0];
        } else {
            DBObject obj = changes[0].m_obj;
            DBObjectProvider pro = null;
            for (DBObjectChange change : changes) {
                if (change == null || change.m_pro == null) continue;
                pro = change.m_pro;
                break;
            }
            CompoundChange compoundChange = null;
            int start = 0;
            if (changes[0] instanceof CompoundChange) {
                compoundChange = (CompoundChange)changes[0];
                start = 1;
                if (changes[0].m_pro == null && pro != null) {
                    changes[0].m_pro = pro;
                }
            }
            for (int i = start; i < changes.length; ++i) {
                DBObjectChange change;
                change = changes[i];
                if (change == null) continue;
                if (compoundChange == null) {
                    compoundChange = new CompoundChange(obj, pro);
                } else {
                    if (change.m_obj != obj) {
                        throw new IllegalArgumentException("Cannot merge changes for difference objects");
                    }
                    if (change.m_pro != null && change.m_pro != pro) {
                        throw new IllegalArgumentException("Cannot merge changes for objects from different providers");
                    }
                }
                compoundChange.merge(change);
            }
            retval = compoundChange;
        }
        return retval;
    }

    public static void fireObjectUpdated(SystemObject obj) {
        DBObjectChange.fireObjectUpdated(obj, null, null, null);
    }

    public static void fireChildrenAdded(SystemObject obj, List added) {
        DBObjectChange.fireObjectUpdated(obj, added, null, null);
    }

    public static void fireChildrenRemoved(SystemObject obj, List removed) {
        DBObjectChange.fireObjectUpdated(obj, null, removed, null);
    }

    public static void firePropertyChanged(SystemObject obj, PropertyChangeEvent ... pces) {
        if (pces != null) {
            HashMap<String, PropertyChangeEvent> props = new HashMap<String, PropertyChangeEvent>(pces.length);
            for (PropertyChangeEvent pce : pces) {
                props.put(pce.getPropertyName(), pce);
            }
            DBObjectChange.fireObjectUpdated(obj, null, null, props);
        }
    }

    public static void firePropertiesChanged(SystemObject obj, Map<String, PropertyChangeEvent> props) {
        DBObjectChange.fireObjectUpdated(obj, null, null, props);
    }

    public static void fireObjectUpdated(SystemObject obj, List<DBObject> added, List<DBObject> removed, Map<String, PropertyChangeEvent> props) {
        Impl c = new Impl((DBObject)obj);
        c.m_changes.put(ADD_KEY, added);
        c.m_changes.put(DEL_KEY, removed);
        c.m_changes.put(PROP_KEY, props);
        obj.fireObjectUpdated(c);
    }

    private static class CompoundChange
    extends DBObjectChange {
        private Collection<DBObjectChange> m_changes = new ArrayList<DBObjectChange>();

        CompoundChange(DBObject obj, DBObjectProvider pro) {
            super(obj, pro);
        }

        public void merge(DBObjectChange change) {
            if (change instanceof CompoundChange) {
                this.m_changes.addAll(((CompoundChange)change).m_changes);
            } else if (change != null) {
                this.m_changes.add(change);
            }
        }

        @Override
        public List<DBObject> getOwnedObjectsAdded() {
            ArrayList<DBObject> retval = new ArrayList<DBObject>();
            for (DBObjectChange change : this.m_changes) {
                retval.addAll(change.getOwnedObjectsAdded());
            }
            return retval;
        }

        @Override
        public List<DBObject> getOwnedObjectsRemoved() {
            ArrayList<DBObject> retval = new ArrayList<DBObject>();
            for (DBObjectChange change : this.m_changes) {
                retval.addAll(change.getOwnedObjectsRemoved());
            }
            return retval;
        }

        @Override
        public Map<DBObject, DBObjectChange> getOwnedObjectsUpdated() {
            DBObjectMap<DBObject, DBObjectChange> retval = new DBObjectMap<DBObject, DBObjectChange>();
            for (DBObjectChange change : this.m_changes) {
                retval.putAll(change.getOwnedObjectsUpdated());
            }
            return retval;
        }

        @Override
        public Collection<String> getAllChangedProperties() {
            HashSet<String> retval = new HashSet<String>();
            for (DBObjectChange change : this.m_changes) {
                retval.addAll(change.getAllChangedProperties());
            }
            return retval;
        }

        @Override
        public Map<String, PropertyChangeEvent> getPropertiesChanged() {
            HashMap<String, PropertyChangeEvent> retval = new HashMap<String, PropertyChangeEvent>();
            for (DBObjectChange change : this.m_changes) {
                retval.putAll(change.getPropertiesChanged());
            }
            return retval;
        }
    }

    static class Impl
    extends oracle.javatools.db.DBObjectChange {
        private Map<String, Object> m_changes = new HashMap<String, Object>();

        private Impl(DBObject obj) {
            super(obj, null);
        }

        private List getChangeList(String key) {
            if (this.m_changes.containsKey(key)) {
                return (List)this.m_changes.get(key);
            }
            return Collections.emptyList();
        }

        private Map getChangeMap(String key) {
            if (this.m_changes.containsKey(key)) {
                return (Map)this.m_changes.get(key);
            }
            return Collections.emptyMap();
        }

        @Override
        public List<DBObject> getOwnedObjectsAdded() {
            return this.getChangeList(DBObjectChange.ADD_KEY);
        }

        @Override
        public Map<DBObject, DBObjectChange> getOwnedObjectsUpdated() {
            return this.getChangeMap(DBObjectChange.KID_KEY);
        }

        @Override
        public List<DBObject> getOwnedObjectsRemoved() {
            return this.getChangeList(DBObjectChange.DEL_KEY);
        }

        public Map<DBObject, PropertyChangeEvent> getOwnedObjectsReordered() {
            return this.getChangeMap(DBObjectChange.ORD_KEY);
        }

        @Override
        public Map<String, PropertyChangeEvent> getPropertiesChanged() {
            return this.getChangeMap(DBObjectChange.PROP_KEY);
        }
    }
}

