/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Map;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class GenericBeanDiffer
implements Differ {
    @Override
    public boolean diff(Object a, Object b, ResultSet r, DiffContext c) {
        ResultSet parent;
        boolean result = true;
        Object o = a == null ? b : a;
        Class<?> objectClass = o.getClass();
        PropertyIterator pi = new PropertyIterator(objectClass, null);
        Map<String, PropertyInfo> props = pi.getPropertyInfos(false, false, true);
        if (props.size() == 0) {
            return false;
        }
        boolean recurse = c.isTreeRequired();
        if (!recurse && (parent = r.getParent()) != null) {
            recurse = parent.isMap();
        }
        if (!(recurse || a != null && b != null)) {
            result = false;
        } else if (recurse || !ModelUtil.areEqual((Object)a, (Object)b)) {
            if (a != null && b != null && a.getClass() != b.getClass()) {
                result = false;
            } else {
                ResultSet propertyRS;
                ArrayList<PropertyInfo> derived = new ArrayList<PropertyInfo>();
                for (PropertyInfo prop : props.values()) {
                    if (this.ignoreProperty(prop)) continue;
                    if (prop.isDerived()) {
                        derived.add(prop);
                        continue;
                    }
                    propertyRS = this.diffProperty(a, b, r, c, prop, props);
                    if (propertyRS == null) continue;
                    result &= propertyRS.isSame();
                }
                for (PropertyInfo prop : derived) {
                    propertyRS = this.diffProperty(a, b, r, c, prop, props);
                    if (propertyRS == null) continue;
                    result &= propertyRS.isSame();
                }
            }
        }
        r.setSame(result);
        return true;
    }

    protected ResultSet diffProperty(Object a, Object b, ResultSet objectRS, DiffContext c, PropertyInfo prop, Map<String, PropertyInfo> beanProps) {
        String propertyName = prop.getPropertyName();
        Object aValue = a == null ? null : prop.getPropertyValue(a);
        Object bValue = b == null ? null : prop.getPropertyValue(b);
        ResultSet propertyRS = new ResultSet(objectRS, aValue, bValue, propertyName, "MAP");
        if (aValue != null && bValue != null && !this.canDiffClasses(aValue.getClass(), bValue.getClass(), c)) {
            propertyRS.setSame(false);
        } else if (aValue == null && bValue == null) {
            propertyRS.setSame(aValue == bValue);
        } else {
            c.getEngine().diff(aValue, bValue, propertyRS, c);
        }
        return propertyRS;
    }

    private boolean canDiffClasses(Class c1, Class c2, DiffContext c) {
        boolean retval = false;
        if (c1 == c2) {
            retval = true;
        } else if (SQLFragment.class.isAssignableFrom(c1) && SQLFragment.class.isAssignableFrom(c2) && c.getEngine().hasRegisteredDiffer(SQLFragment.class)) {
            retval = true;
        } else if (DBObjectID.class.isAssignableFrom(c1) && DBObjectID.class.isAssignableFrom(c2)) {
            retval = true;
        }
        return retval;
    }

    protected boolean ignoreProperty(PropertyInfo prop) {
        return prop.getPropertyName().equals("ID") || prop.isDeprecated() || prop.isTransient();
    }
}

