/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.GenericBeanDiffer;
import oracle.javatools.db.diff.GenericMapDiffer;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;

class DBObjectDiffer
extends GenericBeanDiffer {
    private final DiffEngine m_internalRefDelegate;

    DBObjectDiffer() {
        this(null);
    }

    DBObjectDiffer(DiffEngine internalRefDelegate) {
        this.m_internalRefDelegate = internalRefDelegate;
    }

    @Override
    protected ResultSet diffProperty(Object a, Object b, ResultSet objectRS, DiffContext c, PropertyInfo prop, Map<String, PropertyInfo> beanProps) {
        ResultSet retval;
        String propName = prop.getPropertyName();
        if ("properties".equals(propName)) {
            retval = this.diffPropertiesMap((DBObject)a, (DBObject)b, objectRS, c, beanProps);
        } else if ("schema".equals(propName) && (a instanceof SchemaObject || b instanceof SchemaObject)) {
            Schema as = DBUtil.getSchema((DBObject)a);
            Schema bs = DBUtil.getSchema((DBObject)b);
            retval = new ResultSet(objectRS, as == null ? null : new Schema(as.getName()), (Object)(bs == null ? null : new Schema(bs.getName())), propName, "LEAF");
            retval.setSame(DBUtil.areNamesAndTypesEqual(as, bs));
        } else if (this.m_internalRefDelegate != null && prop.isInternalReference()) {
            Object aValue = a == null ? null : prop.getPropertyValue(a);
            Object bValue = b == null ? null : prop.getPropertyValue(b);
            boolean idArray = aValue != null && aValue instanceof Object[] || bValue != null && bValue instanceof Object[];
            retval = new ResultSet(objectRS, aValue, bValue, propName, idArray ? "LIST" : "MAP");
            if (aValue == null || bValue == null) {
                retval.setSame(aValue == bValue);
            } else {
                DiffContext delegateC = new DiffContext(this.m_internalRefDelegate, retval);
                this.m_internalRefDelegate.diff(aValue, bValue, retval, delegateC);
            }
        } else {
            retval = super.diffProperty(a, b, objectRS, c, prop, beanProps);
        }
        return retval;
    }

    protected ResultSet diffPropertiesMap(final DBObject a, final DBObject b, ResultSet objectRS, DiffContext c, final Map<String, PropertyInfo> beanProps) {
        Map<String, Object> aProps = a == null ? null : a.getProperties();
        Map<String, Object> bProps = b == null ? null : b.getProperties();
        final ResultSet propsRS = new ResultSet(objectRS, aProps, bProps, "properties", "MAP");
        DBObject o = a == null ? b : a;
        Class<?> objectClass = o.getClass();
        PropertyIterator pi = new PropertyIterator(objectClass, null);
        final Map<String, PropertyInfo> allProps = pi.getPropertyInfos(true, true, false);
        GenericMapDiffer d = new GenericMapDiffer(){

            @Override
            protected boolean ignoreKey(Object key) {
                return "Timestamp".equals(key) || beanProps.containsKey(key);
            }

            @Override
            protected Set getCombinedKeySet(Map aMap, Map bMap) {
                HashSet<Object> retval = new HashSet<Object>();
                retval.addAll(allProps.keySet());
                retval.addAll(this.getCustomProperties(a));
                retval.addAll(this.getCustomProperties(b));
                return retval;
            }

            private Collection<String> getCustomProperties(DBObject obj) {
                ArrayList<String> retval = null;
                if (obj != null) {
                    Map<String, Object> props = DBUtil.getFrozenProperties(obj);
                    for (String prop : props.keySet()) {
                        if (allProps.containsKey(prop)) continue;
                        if (retval == null) {
                            retval = new ArrayList<String>();
                        }
                        retval.add(prop);
                    }
                }
                return retval == null ? Collections.emptyList() : retval;
            }

            @Override
            protected ResultSet diffValue(Map aMap, Map bMap, Object key, ResultSet mapRS, DiffContext c) {
                ResultSet retval;
                PropertyInfo info = (PropertyInfo)allProps.get(key);
                if (info != null) {
                    retval = DBObjectDiffer.this.diffProperty(a, b, propsRS, c, info, beanProps);
                } else {
                    Object aValue = a == null ? null : a.getProperty(key.toString());
                    Object bValue = b == null ? null : b.getProperty(key.toString());
                    retval = this.diffValue(aValue, bValue, key, mapRS, c);
                }
                return retval;
            }
        };
        d.diff(aProps, bProps, propsRS, c);
        return propsRS;
    }
}

