/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.text.MessageFormat;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.resource.APIBundle;

public class UnsupportedDDLException
extends UnsupportedOperationException {
    private DBObject m_obj;

    public UnsupportedDDLException(String string, DBObject object) {
        super(MessageFormat.format(string, object.getType(), object.getName()));
        this.m_obj = object;
    }

    public DBObject getObject() {
        return this.m_obj;
    }

    void throwDBException() throws DBException {
        throw new DBException(this.m_obj, this.getMessage(), this);
    }

    static UnsupportedDDLException updateNotSupported(DBObject obj) {
        return new UnsupportedDDLException(APIBundle.get("DDL_UPDATE_NOT_SUPPORTED"), obj);
    }

    static UnsupportedDDLException createNotSupported(DBObject obj) {
        return new UnsupportedDDLException(APIBundle.get("DDL_CREATE_NOT_SUPPORTED"), obj);
    }

    static UnsupportedDDLException deleteNotSupported(DBObject obj) {
        return new UnsupportedDDLException(APIBundle.get("DDL_DELETE_NOT_SUPPORTED"), obj);
    }

    static UnsupportedDDLException undeleteNotSupported(DBObject obj) {
        return new UnsupportedDDLException(APIBundle.get("DDL_UNDELETE_NOT_SUPPORTED"), obj);
    }
}

