/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.ddl.AlterDDLGenerator;
import oracle.javatools.db.ddl.CreateDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLGeneratorImpl;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.DropDDLGenerator;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.ddl.TokenProcessor;
import oracle.javatools.db.ddl.UndeleteDDLGenerator;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.extension.DelegateDDLGenerator;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.util.ModelUtil;

public class TokenDDLGenerator<T extends DDLType>
extends DDLGeneratorImpl<T> {
    private final TokenProcessor m_processor = new TokenProcessor(this.getPropertyHelper());

    @Deprecated
    public TokenDDLGenerator(DBObjectProvider pro) {
        this(pro.getClass(), pro);
    }

    public TokenDDLGenerator(Class<? extends Database> databaseClass, DBObjectProvider pro) {
        super(databaseClass, pro);
    }

    public void registerTokenGenerator(String tokenName, TokenGenerator gen) {
        this.m_processor.registerGenerator(tokenName, gen);
    }

    public final void registerCreateDDL(final String type, final String code, final DDLType ddlType) {
        this.registerCreateGenerator(type, new CreateDDLGenerator(){
            private Collection<String> m_allProps;

            @Override
            public DDL getCreateDDL(DDLOptions options, DBObject obj) {
                return TokenDDLGenerator.this.createDDL(options, code, obj, ddlType);
            }

            @Override
            public boolean canCreate(String propPath) {
                if (this.m_allProps == null) {
                    this.m_allProps = TokenDDLGenerator.this.m_processor.getCreatePropertyPaths(code, type, TokenDDLGenerator.this.getProvider());
                }
                return this.m_allProps.contains(propPath);
            }

            @Override
            public boolean canReplace() {
                boolean retval = code.contains("{replace}");
                return retval;
            }
        });
    }

    public final void registerDropDDL(String type, final String code, final DDLType ddlType) {
        this.registerDropGenerator(type, new DropDDLGenerator(){

            @Override
            public DDL getDropDDL(DDLOptions options, DBObject obj) {
                return TokenDDLGenerator.this.createDDL(options, code, obj, ddlType);
            }
        });
    }

    public final void registerUndeleteDDL(String type, final String code, final DDLType ddlType) {
        this.registerUndeleteGenerator(type, new UndeleteDDLGenerator(){

            @Override
            public DDL getUndeleteDDL(DDLOptions options, DBObject obj) {
                return TokenDDLGenerator.this.createDDL(options, code, obj, ddlType);
            }
        });
    }

    public final void registerAlterDDL(final String type, final String code, final DDLType ddlType) {
        this.registerAlterGenerator(type, new AlterDDLGenerator(){
            private Map<PropertyAction.ChildAction, Collection<String>> m_allProps;

            @Override
            public DDL getAlterDDL(DDLOptions options, Difference rs) {
                return TokenDDLGenerator.this.createUpdateDDL(options, code, rs, ddlType);
            }

            @Override
            public Collection<PropertyAction.ChildAction> canAlter(String prop) {
                if (this.m_allProps == null) {
                    this.m_allProps = TokenDDLGenerator.this.m_processor.getAlterPropertyPaths(code, type, TokenDDLGenerator.this.getProvider());
                }
                EnumSet<PropertyAction.ChildAction> retval = EnumSet.noneOf(PropertyAction.ChildAction.class);
                for (PropertyAction.ChildAction action : PropertyAction.ChildAction.values()) {
                    Collection<String> props = this.m_allProps.get((Object)action);
                    if (props == null || !props.contains(prop)) continue;
                    retval.add(action);
                }
                return retval;
            }
        });
    }

    protected DDL createDDL(DDLOptions options, String code, DBObject obj, DDLType ddlType) {
        TokenContext context = new TokenContext(this.getProvider(), options, obj);
        return this.constructDDL(options, code, context, ddlType);
    }

    protected DDL createUpdateDDL(DDLOptions options, String code, Difference rs, DDLType ddlType) {
        TokenContext context = new TokenContext(this.getProvider(), options, rs);
        return this.constructDDL(options, code, context, ddlType);
    }

    private DDL constructDDL(DDLOptions options, String code, TokenContext context, DDLType ddlType) {
        this.m_processor.process(code, context);
        DDL<DDLType> ddl = null;
        for (String ddlString : context.getStatements()) {
            if (!ModelUtil.hasLength((String)ddlString)) continue;
            if (ddl == null) {
                ddl = new DDL<DDLType>((DBObject)context.getObject());
            }
            ddl.append(ddlType, ddlString);
        }
        return ddl;
    }

    public String getDDLFragment(DBObject obj) {
        String retval = null;
        if (this.m_processor.canProcess(obj)) {
            TokenContext context = new TokenContext(this.getProvider(), new DDLOptions(), obj);
            context.setProcessor(this.m_processor);
            context.append(obj);
            retval = context.toString();
        }
        return retval;
    }

    public void includeSyntax(DatabaseDescriptor otherDatabase, String type, boolean includeAlter) {
        DBObjectProvider pro = this.getProvider();
        DDLGenerator copyFrom = otherDatabase.getDDLGenerator(pro);
        if (copyFrom instanceof DelegateDDLGenerator) {
            copyFrom = ((DelegateDDLGenerator)copyFrom).getBaseGenerator();
        }
        if (copyFrom instanceof DDLGeneratorImpl) {
            ((DDLGeneratorImpl)copyFrom).copyGenerators(this, type, includeAlter);
        }
    }

    @Override
    public Collection getAllowedPropertyValues(DBObject originalObject, DBObject updatedObject, String property) {
        Collection<String> retval;
        if (Property.getLastProperty(property).equals("constraintType")) {
            retval = new ArrayList();
            for (String ctype : Constraint.getConstraintTypes()) {
                if (!this.m_processor.hasRegisteredToken("CONSTRAINT." + ctype)) continue;
                retval.add(ctype);
            }
        } else {
            retval = super.getAllowedPropertyValues(originalObject, updatedObject, property);
        }
        return retval;
    }
}

