/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.TokenProcessor;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

public class TokenContext {
    private static final char NEWLINE = '\n';
    private StringBuilder m_buff = new StringBuilder();
    private List<String> m_stmts = new ArrayList<String>();
    private DBObjectProvider m_provider;
    private DDLOptions m_options;
    private TokenProcessor m_processor;
    private Object m_obj;
    private String m_block;
    private Difference m_difference;
    private Object m_loop;
    private boolean m_statementLoop;
    private int m_increment;

    TokenContext(DBObjectProvider pro, DDLOptions options, Object obj) {
        this.m_provider = pro;
        DDLOptions dDLOptions = this.m_options = options == null ? new DDLOptions() : options;
        if (obj instanceof Difference) {
            this.m_difference = (Difference)obj;
            this.m_obj = this.m_difference.getUpdatedObject();
        } else {
            this.m_obj = obj;
        }
    }

    private Logger getLogger() {
        return DBLog.getLogger(this);
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public Schema getDefaultSchema() {
        Schema retval = null;
        if (this.m_provider != null) {
            try {
                retval = this.m_provider.getDefaultSchema();
            }
            catch (DBException e) {
                this.getLogger().warning(e.getMessage());
            }
        }
        return retval;
    }

    public Object getObject() {
        return this.m_obj;
    }

    public Difference getDifference() {
        return this.m_difference;
    }

    public boolean isUpdate() {
        return this.m_difference != null;
    }

    public Difference findUpdateDifference(DBObject obj) {
        Difference retval = null;
        Difference rootDiff = this.m_options.getContextDifference();
        if (rootDiff != null) {
            retval = this.findDifference(obj, rootDiff);
        }
        return retval;
    }

    private Difference findDifference(DBObject obj, Difference diff) {
        Difference retval;
        block3: {
            retval = null;
            if ((diff.isSame() || !DBObject.class.isAssignableFrom(DBUtil.decodeArrayClass(diff.getDifferenceClass()))) && !"properties".equals(diff.getPropertyName())) break block3;
            if (obj == diff.getUpdatedObject() || obj == diff.getOriginalObject()) {
                retval = diff;
            } else {
                Difference child;
                Iterator<? extends Difference> iterator = diff.getChildren().iterator();
                while (iterator.hasNext() && (retval = this.findDifference(obj, child = iterator.next())) == null) {
                }
            }
        }
        return retval;
    }

    public DDLOptions getOptions() {
        return this.m_options;
    }

    TokenProcessor getProcessor() {
        return this.m_processor;
    }

    void setProcessor(TokenProcessor processor) {
        this.m_processor = processor;
    }

    void setBlock(String block) {
        this.m_block = block;
    }

    String getBlock() {
        return this.m_block;
    }

    void setLoopObject(Object loop) {
        this.m_loop = loop;
        if (this.m_buff.length() == 0) {
            this.m_statementLoop = true;
        } else if (this.m_statementLoop) {
            this.endCurrentStatement();
        }
    }

    public Object getLoopObject() {
        return this.m_loop;
    }

    public void endCurrentStatement() {
        if (this.m_buff.length() > 0) {
            String stmt = this.m_buff.toString().trim();
            if (stmt.length() > 0) {
                this.m_stmts.add(stmt);
            }
            this.m_buff.delete(0, this.m_buff.length());
        }
    }

    public void incrementIndent() {
        ++this.m_increment;
    }

    public void decrementIndent() {
        if (this.m_increment > 0) {
            --this.m_increment;
        }
    }

    private void appendIncrement() {
        boolean append = false;
        if (this.m_increment > 0 && !(append = this.endsWith('\n')) && this.endsWithWhitespace()) {
            int length = this.m_buff.length();
            char[] lastChar = new char[1];
            for (int i = length; i > 0; --i) {
                this.m_buff.getChars(i - 1, i, lastChar, 0);
                if (!Character.isWhitespace(lastChar[0])) break;
                if (lastChar[0] != '\n') continue;
                this.m_buff.delete(i, length);
                append = true;
                break;
            }
        }
        if (append) {
            for (int i = 1; i <= this.m_increment; ++i) {
                this.m_buff.append("  ");
            }
        }
    }

    public String toString() {
        return this.m_buff.toString().trim();
    }

    public List<String> getStatements() {
        this.endCurrentStatement();
        return this.m_stmts;
    }

    public int length() {
        return this.m_buff.length();
    }

    public void removeIfEndsWith(String str) {
        int newEnd = this.m_buff.length() - str.length();
        if (newEnd >= 0 && this.m_buff.lastIndexOf(str) == newEnd) {
            this.m_buff.delete(newEnd, this.m_buff.length());
        }
    }

    boolean endsWithWhitespace() {
        char[] lastChar = new char[1];
        int length = this.m_buff.length();
        if (length > 0) {
            this.m_buff.getChars(length - 1, length, lastChar, 0);
            return Character.isWhitespace(lastChar[0]);
        }
        return false;
    }

    boolean endsWith(char c) {
        char[] lastChar = new char[1];
        int length = this.m_buff.length();
        if (length > 0) {
            this.m_buff.getChars(length - 1, length, lastChar, 0);
            return c == lastChar[0];
        }
        return false;
    }

    void appendName(String name) {
        this.appendString(this.getExternalName(name), false);
    }

    public String getExternalName(String name) {
        String retval = name;
        if (this.m_provider != null) {
            retval = this.m_provider.getExternalName(name);
        }
        return retval;
    }

    public void appendString(String string, boolean incrementNewlines) {
        if (ModelUtil.hasLength((String)string)) {
            if (incrementNewlines) {
                int newline = string.indexOf(10);
                if (this.m_increment > 0) {
                    while (newline >= 0) {
                        this.appendIncrement();
                        this.m_buff.append(string.substring(0, newline));
                        this.m_buff.append('\n');
                        string = string.substring(newline + 1);
                        newline = string.indexOf(10);
                    }
                }
            }
            this.appendIncrement();
            this.m_buff.append(string);
        } else if (string == null) {
            this.m_buff.append(string);
        }
    }

    void appendSchemaName(String sname) {
        if (ModelUtil.hasLength((String)sname)) {
            Object obj = this.getObject();
            Schema contextSchema = null;
            boolean prefixSchemaName = this.m_options.isPrefixSchemaName();
            if (!prefixSchemaName && this.m_provider != null) {
                contextSchema = this.getDefaultSchema();
                boolean bl = prefixSchemaName = contextSchema == null || !sname.equals(contextSchema.getName());
            }
            if (!prefixSchemaName) {
                Schema schema = contextSchema = obj instanceof DBObject ? DBUtil.getSchema((DBObject)obj) : null;
                if (contextSchema != null) {
                    boolean bl = prefixSchemaName = !sname.equals(contextSchema.getName());
                }
            }
            if (prefixSchemaName) {
                this.appendName(sname);
                this.appendString(".", false);
            }
        }
    }

    public void append(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Difference) {
            this.append(((Difference)value).getUpdatedObject());
        } else if (value instanceof DBObject) {
            if (this.m_processor.canProcess(value)) {
                TokenContext tc = this.newChildContext((DBObject)value);
                this.m_processor.process(value, tc);
            } else if (value instanceof SQLFragment) {
                this.appendString(((SQLFragment)value).getSQLText(), true);
            } else if (value instanceof DataTypeUsage) {
                String dtuDDL = DataTypeHelper.getDDL((DataTypeUsage)value, this.getProvider());
                if (dtuDDL != null) {
                    this.appendString(dtuDDL, true);
                }
            } else if (value instanceof PredefinedDataType) {
                this.appendString(((PredefinedDataType)value).getName(), true);
            } else {
                Schema valueSchema;
                if (value instanceof SchemaObject && (valueSchema = ((SchemaObject)value).getSchema()) != null) {
                    this.appendSchemaName(valueSchema.getName());
                }
                this.appendName(((DBObject)value).getName());
            }
        } else if (value instanceof DBObjectID) {
            boolean resolved = false;
            try {
                DBObject obj = ((DBObjectID)value).resolveID();
                if (obj != null) {
                    resolved = true;
                    this.append(obj);
                }
            }
            catch (DBException dbe) {
                this.getLogger().warning(dbe.getMessage());
            }
            if (!resolved) {
                if (DataTypeHelper.canGetTypeStringFromID((DBObjectID)value)) {
                    Schema schema = null;
                    try {
                        schema = this.m_provider == null ? null : this.m_provider.getDefaultSchema();
                    }
                    catch (DBException dBException) {
                        // empty catch block
                    }
                    this.appendString(DataTypeHelper.getTypeStringFromID((BaseObjectID)value, schema, this.m_provider), true);
                } else if (value instanceof BaseObjectID) {
                    this.appendSchemaName(((BaseObjectID)value).getSchemaName());
                    this.appendName(((BaseObjectID)value).getName());
                }
            }
        } else if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    this.appendString(", ", false);
                }
                this.append(arr[i]);
            }
        } else {
            this.appendString(value.toString(), true);
        }
    }

    public TokenContext newChildContext(Object newObj) {
        Object obj = newObj != null ? newObj : (this.m_difference != null ? this.m_difference : this.m_obj);
        TokenContext child = new TokenContext(this.m_provider, this.m_options, obj);
        child.m_buff = this.m_buff;
        child.m_processor = this.m_processor;
        child.m_loop = this.m_loop;
        child.m_increment = this.m_increment;
        child.m_stmts = this.m_stmts;
        return child;
    }

    public Object getPropertyValue(String propName) {
        PropertyHelper helper = this.m_processor.getPropertyHelper();
        Difference diff = this.getDifference();
        if (diff != null) {
            try {
                Difference propDiff = helper.getChildDifference(diff, propName);
                if (propDiff != null) {
                    if (propDiff.isSame()) {
                        return propDiff.getOriginalObject();
                    }
                    return propDiff.getUpdatedObject();
                }
            }
            catch (MissingPropertyException propDiff) {
                // empty catch block
            }
        }
        try {
            return helper.getPropertyValueOrFail(this.getObject(), propName);
        }
        catch (MissingPropertyException mpe) {
            this.getLogger().fine(mpe.getMessage());
            return null;
        }
    }
}

