/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.db.diff.Difference;

public class DDLOptions
extends HashStructureAdapter {
    private static final String REPLACE = "replace";
    private static final String CASCADE = "cascadeDelete";
    private static final String PROMPTS = "sqlPlus";
    private static final String PREFIX = "schemaNames";
    private static final String SPOOL = "spoolCommands";
    private static final String SQLBLANKLINES = "SQLBLANKLINES";
    private Difference m_contextDiff;

    protected DDLOptions(HashStructure hash) {
        super(hash);
    }

    public DDLOptions() {
        super(HashStructure.newInstance());
    }

    public DDLOptions(boolean replace, boolean cascade) {
        this();
        this.setReplace(replace);
        this.setCascade(cascade);
    }

    public void setReplace(boolean replace) {
        this._hash.putBoolean(REPLACE, replace);
    }

    public final boolean isReplace() {
        return this._hash.getBoolean(REPLACE, false);
    }

    public void setCascade(boolean cascade) {
        this._hash.putBoolean(CASCADE, cascade);
    }

    public final boolean isCascade() {
        return this._hash.getBoolean(CASCADE, false);
    }

    public void setPrefixSchemaName(boolean prefix) {
        this._hash.putBoolean(PREFIX, prefix);
    }

    public boolean isPrefixSchemaName() {
        return this._hash.getBoolean(PREFIX, false);
    }

    public void setIncludePrompts(boolean prompts) {
        this._hash.putBoolean(PROMPTS, prompts);
    }

    public boolean isIncludePrompts() {
        return this._hash.getBoolean(PROMPTS, false);
    }

    public String getSpoolFile() {
        return this._hash.getString(SPOOL);
    }

    public void setSpoolFile(String filename) {
        this._hash.putString(SPOOL, filename);
    }

    public boolean isSqlBlankLines() {
        return this._hash.getBoolean(SQLBLANKLINES, false);
    }

    public void setSqlBlankLines(boolean onOrOff) {
        this._hash.putBoolean(SQLBLANKLINES, onOrOff);
    }

    Difference getContextDifference() {
        return this.m_contextDiff;
    }

    static DDLOptions copyForUpdate(DDLOptions options, Difference contextDiff) {
        DDLOptions retval = (DDLOptions)((Object)options.copyTo(null));
        boolean keep = false;
        if (options.m_contextDiff != null) {
            for (Difference test = contextDiff; test != null; test = test.getParent()) {
                if (test != options.m_contextDiff) continue;
                keep = true;
                break;
            }
        }
        retval.m_contextDiff = keep ? options.m_contextDiff : contextDiff;
        return retval;
    }
}

