/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.AbstractDDLGenerator;
import oracle.javatools.db.ddl.AlterDDLGenerator;
import oracle.javatools.db.ddl.CreateDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.DropDDLGenerator;
import oracle.javatools.db.ddl.GeneratorCache;
import oracle.javatools.db.ddl.UndeleteDDLGenerator;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.resource.APIBundle;

class DDLGeneratorImpl<T extends DDLType>
extends AbstractDDLGenerator<T> {
    private final GeneratorCache m_cache = new GeneratorCache();

    public DDLGeneratorImpl(Class<? extends Database> databaseClass, DBObjectProvider pro) {
        super(databaseClass, pro);
    }

    private List<CreateDDLGenerator> getCreateGenerators(String type) {
        return this.m_cache.getGenerators(CreateDDLGenerator.class, type);
    }

    protected final void registerCreateGenerator(String type, CreateDDLGenerator creator) {
        this.m_cache.registerGenerator(CreateDDLGenerator.class, type, creator);
    }

    private List<DropDDLGenerator> getDropGenerators(String type) {
        return this.m_cache.getGenerators(DropDDLGenerator.class, type);
    }

    protected final void registerDropGenerator(String type, DropDDLGenerator dropper) {
        this.m_cache.registerGenerator(DropDDLGenerator.class, type, dropper);
    }

    private List<AlterDDLGenerator> getAlterGenerators(String type) {
        return this.m_cache.getGenerators(AlterDDLGenerator.class, type);
    }

    protected final void registerAlterGenerator(String type, AlterDDLGenerator deletor) {
        this.m_cache.registerGenerator(AlterDDLGenerator.class, type, deletor);
    }

    private List<UndeleteDDLGenerator> getUndeleteGenerators(String type) {
        return this.m_cache.getGenerators(UndeleteDDLGenerator.class, type);
    }

    protected final void registerUndeleteGenerator(String type, UndeleteDDLGenerator undeletor) {
        this.m_cache.registerGenerator(UndeleteDDLGenerator.class, type, undeletor);
    }

    protected final void copyGenerators(DDLGeneratorImpl other, String type, boolean incAlter) {
        for (CreateDDLGenerator createDDLGenerator : this.getCreateGenerators(type)) {
            other.registerCreateGenerator(type, createDDLGenerator);
        }
        for (DropDDLGenerator dropDDLGenerator : this.getDropGenerators(type)) {
            other.registerDropGenerator(type, dropDDLGenerator);
        }
        if (incAlter) {
            for (AlterDDLGenerator alterDDLGenerator : this.getAlterGenerators(type)) {
                other.registerAlterGenerator(type, alterDDLGenerator);
            }
        }
    }

    private DBObject[] getChildList(DBObject obj, String propPath) {
        DBObject[] val = this.getPropertyHelper().getPropertyValue(obj, propPath);
        if (val != null && val instanceof DBObject) {
            val = new DBObject[]{(DBObject)val};
        }
        return val instanceof DBObject[] ? (DBObject[])val : null;
    }

    protected final void registerTopLevelChild(String type, final String propPath, final String childType) {
        if (type == null || propPath == null || childType == null) {
            throw new NullPointerException();
        }
        this.registerCreateGenerator(type, new CreateDDLGenerator(){

            @Override
            public DDL getCreateDDL(DDLOptions options, DBObject obj) {
                if (options.isReplace()) {
                    options = (DDLOptions)((Object)options.copyTo((Object)new DDLOptions()));
                    options.setReplace(false);
                }
                DDL retval = null;
                DBObject[] children = DDLGeneratorImpl.this.getChildList(obj, propPath);
                if (children != null) {
                    retval = DDLGeneratorImpl.this.getCreateDDL(options, children);
                }
                return retval;
            }

            @Override
            public boolean canReplace() {
                for (CreateDDLGenerator gen : DDLGeneratorImpl.this.getCreateGenerators(childType)) {
                    if (!gen.canReplace()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean canCreate(String property) {
                if (propPath.equals(property)) {
                    return true;
                }
                if (property.startsWith(propPath + "/")) {
                    String childProp = property.substring(propPath.length() + 1);
                    for (CreateDDLGenerator gen : DDLGeneratorImpl.this.getCreateGenerators(childType)) {
                        if (!gen.canCreate(childProp)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        this.registerAlterGenerator(type, new AlterDDLGenerator(){

            @Override
            public DDL getAlterDDL(DDLOptions options, Difference parDiff) {
                DDL retval = null;
                try {
                    Difference diff = DDLGeneratorImpl.this.getPropertyHelper().getChildDifference(parDiff, propPath, true);
                    if (diff != null && DBObject[].class.isAssignableFrom(diff.getDifferenceClass())) {
                        for (Difference difference : diff.getChildren()) {
                            if (difference.isSame()) continue;
                            if (difference.isModified()) {
                                if (!options.isReplace()) {
                                    options = DDLOptions.copyForUpdate(options, parDiff);
                                    options.setReplace(true);
                                }
                                retval = DDLGeneratorImpl.this.append(retval, DDLGeneratorImpl.this.getUpdateDDLImpl(options, difference));
                                continue;
                            }
                            DBObject orig = (DBObject)difference.getOriginalObject();
                            if (orig == null) {
                                options = (DDLOptions)((Object)options.copyTo((Object)new DDLOptions()));
                                options.setReplace(false);
                                retval = DDLGeneratorImpl.this.append(retval, DDLGeneratorImpl.this.getCreateDDLImpl(options, (DBObject)difference.getUpdatedObject()));
                                continue;
                            }
                            retval = DDLGeneratorImpl.this.append(retval, DDLGeneratorImpl.this.getDeleteDDLImpl(options, orig));
                        }
                    }
                }
                catch (MissingPropertyException mpe) {
                    DDLGeneratorImpl.this.getLogger().log(Level.FINE, mpe.getMessage());
                }
                return retval;
            }

            @Override
            public Collection<PropertyAction.ChildAction> canAlter(String property) {
                Collection<PropertyAction.ChildAction> retval = null;
                if (propPath.equals(property)) {
                    retval = Arrays.asList(PropertyAction.ChildAction.values());
                } else if (property.startsWith(propPath + "/")) {
                    retval = EnumSet.noneOf(PropertyAction.ChildAction.class);
                    String childProp = property.substring(propPath.length() + 1);
                    for (AlterDDLGenerator gen : DDLGeneratorImpl.this.getAlterGenerators(childType)) {
                        Collection<PropertyAction.ChildAction> genActions = gen.canAlter(childProp);
                        if (genActions == null) continue;
                        retval.addAll(genActions);
                    }
                }
                return retval;
            }
        });
    }

    @Override
    protected DDL<T> getCreateDDLImpl(DDLOptions options, DBObject ... objects) {
        DDL ddl = null;
        for (DBObject obj : objects) {
            List<CreateDDLGenerator> gens = this.getCreateGenerators(obj.getType());
            if (gens == null || gens.size() == 0) {
                throw UnsupportedDDLException.createNotSupported(obj);
            }
            boolean deleteRequired = true;
            for (CreateDDLGenerator gen : gens) {
                if (gen.canReplace()) {
                    deleteRequired = false;
                }
                ddl = this.append(ddl, gen.getCreateDDL(options, obj));
            }
            if (!options.isReplace() || !deleteRequired) continue;
            DBObject existing = null;
            if (this.getProvider() != null) {
                try {
                    existing = DBUtil.getProviderDefinition(obj, this.getProvider());
                }
                catch (DBException dbe) {
                    this.getLogger().log(Level.WARNING, "Couldn't get existing object for DROP", dbe);
                }
            }
            ddl = this.append(ddl, this.getDeleteDDL(options, existing == null ? obj : existing));
        }
        return ddl;
    }

    @Override
    protected DDL<T> getDeleteDDLImpl(DDLOptions options, DBObject ... objects) {
        DDL ddl = null;
        for (DBObject obj : objects) {
            List<DropDDLGenerator> gens = this.getDropGenerators(obj.getType());
            if (gens == null || gens.size() == 0) {
                throw UnsupportedDDLException.deleteNotSupported(obj);
            }
            for (DropDDLGenerator gen : gens) {
                ddl = this.append(ddl, gen.getDropDDL(options, obj));
            }
        }
        return ddl;
    }

    @Override
    public DDL<T> getUndeleteDDL(DDLOptions options, DBObject ... objects) {
        DDL ddl = null;
        for (DBObject obj : objects) {
            List<UndeleteDDLGenerator> gens = this.getUndeleteGenerators(obj.getType());
            if (gens == null || gens.size() == 0) {
                throw UnsupportedDDLException.undeleteNotSupported(obj);
            }
            for (UndeleteDDLGenerator gen : gens) {
                ddl = this.append(ddl, gen.getUndeleteDDL(options, obj));
            }
        }
        return this.finish(options, ddl);
    }

    @Override
    protected DDL<T> getUpdateDDLImpl(DDLOptions options, Difference rs) {
        DDL ddl = null;
        if (options.getContextDifference() == null) {
            throw new IllegalStateException("No context Difference set.");
        }
        PropertyAction action = this.canUpdateObject(rs);
        if (action != null && action.getType() == PropertyAction.Type.ALTER) {
            DBObject orig = (DBObject)rs.getOriginalObject();
            String type = orig.getType();
            List<AlterDDLGenerator> gens = this.getAlterGenerators(type);
            if (gens == null || gens.size() == 0) {
                throw UnsupportedDDLException.updateNotSupported(orig);
            }
            for (AlterDDLGenerator ddlgen : gens) {
                DDL next = ddlgen.getAlterDDL(options, rs);
                if (next == null || next.size() <= 0) continue;
                ddl = this.append(ddl, next);
            }
        } else {
            DBObject old = (DBObject)rs.getOriginalObject();
            DBObject updated = (DBObject)rs.getUpdatedObject();
            if (options.isReplace()) {
                if (this.canReplace(old.getType()) && !this.hasIdentityChanged(rs)) {
                    ddl = this.getCreateDDLImpl(options, updated);
                } else {
                    ddl = this.getDeleteDDL(options, old);
                    DDLOptions options2 = DDLOptions.copyForUpdate(options, rs);
                    options2.setReplace(false);
                    ddl = this.append(ddl, this.getCreateDDL(options2, updated));
                }
            } else {
                rs.print();
                throw new UnsupportedDDLException(APIBundle.get("DDL_UPDATE_NEED_REPLACE"), old);
            }
        }
        return ddl;
    }

    private boolean hasIdentityChanged(Difference d) {
        return this.hasObjectPropertyChanged(d, "name") || this.hasObjectPropertyChanged(d, "schema");
    }

    private boolean hasObjectPropertyChanged(Difference d, String prop) {
        boolean retval = false;
        if (DBObject.class.isAssignableFrom(d.getDifferenceClass())) {
            try {
                Difference propDiff = this.getPropertyHelper().getChildDifference(d, prop, true);
                retval = propDiff != null;
            }
            catch (MissingPropertyException mpe) {
                DBLog.getLogger(this).log(Level.WARNING, "Expected " + prop + " property to exist.");
            }
        }
        return retval;
    }

    @Override
    protected boolean canCreate(Class<? extends SystemObject> objClass, String prop) {
        String type = Metadata.getType(objClass);
        boolean ret = this.canCreateImpl(type, prop);
        if (!ret) {
            ret = this.isProcessorProperty(objClass, prop);
        }
        return ret;
    }

    private boolean canCreateImpl(String type, String prop) {
        List<CreateDDLGenerator> gens = this.getCreateGenerators(type);
        for (CreateDDLGenerator ddlgen : gens) {
            if (!ddlgen.canCreate(prop)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsProperty(Class<? extends DBObject> objClz, String prop) {
        String[] fullPropParts = Property.getProperties(prop);
        for (int i = 0; i < fullPropParts.length; ++i) {
            String lastProp;
            String[] headerPropParts = new String[i + 1];
            for (int j = 0; j < i + 1; ++j) {
                headerPropParts[j] = fullPropParts[j];
            }
            String headerProp = Property.createPath(headerPropParts);
            PropertyInfo info = this.findPropertyInfo(objClz, headerProp);
            if (info == null) {
                prop = null;
                break;
            }
            if (!info.isDerived()) continue;
            headerPropParts[headerPropParts.length - 1] = lastProp = info.getDerivedSourceProperty();
            prop = Property.createPath(headerPropParts);
            break;
        }
        if (prop != null) {
            if (SystemObject.class.isAssignableFrom(objClz)) {
                String type = Metadata.getType(objClz);
                if ("properties".equals(prop)) {
                    return true;
                }
                if (this.canCreateImpl(type, prop)) {
                    return true;
                }
                if (this.isProcessorProperty(objClz, prop)) {
                    return true;
                }
                List<AlterDDLGenerator> gens = this.getAlterGenerators(type);
                for (AlterDDLGenerator ddlgen : gens) {
                    Collection<PropertyAction.ChildAction> genActions = ddlgen.canAlter(prop);
                    if (genActions == null || genActions.isEmpty()) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsAction(String type, PropertyAction.Type actionType) {
        boolean supported = false;
        switch (actionType) {
            case CREATE: 
            case REPLACE: {
                supported = this.m_cache.containsType(CreateDDLGenerator.class, type);
                break;
            }
            case ALTER: {
                supported = this.m_cache.containsType(AlterDDLGenerator.class, type);
                break;
            }
            case DELETE: {
                supported = this.m_cache.containsType(DropDDLGenerator.class, type);
                break;
            }
            case UNDELETE: {
                supported = this.m_cache.containsType(UndeleteDDLGenerator.class, type);
            }
        }
        if (!supported) {
            supported = super.supportsAction(type, actionType);
        }
        return supported;
    }

    @Override
    public PropertyAction supportsPropertyChange(Class<? extends SystemObject> objClass, String prop) {
        PropertyAction retval = null;
        String type = Metadata.getType(objClass);
        EnumSet<PropertyAction.ChildAction> actions = EnumSet.noneOf(PropertyAction.ChildAction.class);
        List<AlterDDLGenerator> gens = this.getAlterGenerators(type);
        for (AlterDDLGenerator ddlgen : gens) {
            Collection<PropertyAction.ChildAction> genActions = ddlgen.canAlter(prop);
            if (genActions == null) continue;
            actions.addAll(genActions);
        }
        if (!actions.isEmpty()) {
            retval = new PropertyAction(PropertyAction.Type.ALTER, actions);
        } else if (this.supportsAction(type, PropertyAction.Type.REPLACE) && this.canCreate(objClass, prop)) {
            retval = new PropertyAction(PropertyAction.Type.REPLACE);
        }
        return retval;
    }

    private boolean canReplace(String type) {
        boolean canReplace = false;
        List<CreateDDLGenerator> gens = this.getCreateGenerators(type);
        for (CreateDDLGenerator gen : gens) {
            if (!gen.canReplace()) continue;
            canReplace = true;
            break;
        }
        return canReplace;
    }
}

