/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.validators.DBObjectValidator;
import oracle.javatools.util.ModelUtil;

final class ObjectCache {
    private Map<String, ObjectTypeEntry> m_typeMap = new TreeMap<String, ObjectTypeEntry>();
    private boolean m_weak;
    private AbstractDBObjectProvider m_pro;
    private String[] m_objTypes;

    ObjectCache(AbstractDBObjectProvider pro, boolean weak) {
        this.m_pro = pro;
        this.m_weak = weak;
    }

    public void registerBuilder(String type, DBObjectBuilder builder) {
        this.registerType(type, builder, null);
    }

    public synchronized DBObjectBuilder getBuilderForType(String type) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        return entry != null ? entry.getBuilder() : null;
    }

    public void registerValidator(String type, DBObjectValidator validator) {
        this.registerType(type, null, validator);
    }

    protected final DBObjectValidator getValidatorForType(String type) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        return entry != null ? entry.getValidator() : null;
    }

    public synchronized void registerType(String type, DBObjectBuilder builder, DBObjectValidator validator) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        if (entry == null) {
            entry = new ObjectTypeEntry();
            this.m_typeMap.put(type, entry);
            this.m_objTypes = null;
        }
        if (builder != null) {
            entry.setBuilder(builder);
        }
        if (validator != null) {
            entry.setValidator(validator);
        }
    }

    public synchronized boolean hasTypeEntry(String type) {
        return type != null && this.m_typeMap.containsKey(type);
    }

    public synchronized String[] listObjectTypes() {
        if (this.m_objTypes == null) {
            Set<Map.Entry<String, ObjectTypeEntry>> entries = this.m_typeMap.entrySet();
            ArrayList<String> l = new ArrayList<String>();
            for (Map.Entry<String, ObjectTypeEntry> entry : entries) {
                ObjectTypeEntry typeEntry = entry.getValue();
                if (typeEntry == null || typeEntry.getBuilder() == null) continue;
                l.add(entry.getKey());
            }
            this.m_objTypes = l.toArray(new String[l.size()]);
            Arrays.sort(this.m_objTypes);
        }
        return Arrays.copyOf(this.m_objTypes, this.m_objTypes.length);
    }

    public synchronized void destroyCache() {
        this.m_typeMap.clear();
    }

    public synchronized void clearAllCaches() {
        for (ObjectTypeEntry e : this.m_typeMap.values()) {
            e.clearCache();
        }
    }

    public synchronized void cacheObject(SystemObject object) {
        ObjectTypeEntry entry;
        if (object != null && (entry = this.m_typeMap.get(object.getType())) != null) {
            entry.addObjectToCache(object);
        }
    }

    public synchronized void uncacheObject(SystemObject object) {
        ObjectTypeEntry entry;
        if (object != null && (entry = this.m_typeMap.get(object.getType())) != null) {
            entry.removeObjectFromCache(object);
        }
    }

    public synchronized SystemObject findObject(String type, String dbName, Schema schema, String name) {
        SystemObject retval = null;
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        if (entry != null) {
            retval = entry.findObject(dbName, schema, name);
        }
        return retval;
    }

    public synchronized SystemObject findObject(DBObjectID id) {
        ObjectTypeEntry entry;
        SystemObject object = null;
        if (id instanceof BaseObjectID && (entry = this.m_typeMap.get(id.getType())) != null) {
            object = entry.findObject((BaseObjectID)id);
        }
        return object;
    }

    public synchronized <T extends SystemObject> Collection<T> listObjectsFromCache(DBObjectCriteria<T> criteria) {
        ArrayList<SystemObject> retval = new ArrayList<SystemObject>();
        for (String objectType : criteria.getTypes()) {
            ObjectTypeEntry entry = this.m_typeMap.get(objectType);
            if (entry == null) continue;
            for (ObjectValue value : entry.m_objectMap.values()) {
                SystemObject obj = this.getListedObject(value, criteria);
                if (obj == null) continue;
                retval.add(obj);
            }
        }
        return retval;
    }

    private SystemObject getListedObject(ObjectValue value, DBObjectCriteria criteria) {
        String schemaName = criteria.getSchemaName();
        String nameLike = criteria.getNameLike();
        SystemObject object = value.getObject();
        if (object != null && !criteria.accept(object)) {
            object = null;
        }
        return object;
    }

    private static String getIDKeyString(BaseObjectID id) {
        Object ident;
        String retval = null;
        if (id instanceof IdentifierBasedID && (ident = ((IdentifierBasedID)id).getIdentifier()) != null) {
            retval = ObjectCache.appendDatabaseName(String.valueOf(ident), id.getDatabaseName());
        }
        return retval;
    }

    private static String appendDatabaseName(String key, String dbName) {
        String retval = ModelUtil.hasLength((String)dbName) ? key + "@" + dbName : key;
        return retval;
    }

    private static String getKeyString(SystemObject obj) {
        String dbName = obj.getID() instanceof BaseObjectID ? ((BaseObjectID)obj.getID()).getDatabaseName() : null;
        Schema s = null;
        if (obj instanceof SchemaObject) {
            s = ((SchemaObject)obj).getSchema();
        }
        return ObjectCache.getKeyString(dbName, s, obj.getName());
    }

    private static String getKeyString(String dbName, Schema s, String name) {
        return ObjectCache.getKeyString(dbName, s == null ? null : s.getName(), name);
    }

    private static String getKeyString(String dbName, String schemaName, String name) {
        return ObjectCache.appendDatabaseName((schemaName == null ? "" : schemaName + ".") + name, dbName);
    }

    private class WeakObjectValue
    extends ObjectValue {
        private Reference<SystemObject> m_ref;

        public WeakObjectValue(SystemObject obj) {
            this.m_ref = new WeakReference<SystemObject>(obj);
        }

        @Override
        public SystemObject getObject() {
            return this.m_ref.get();
        }
    }

    private class StrongObjectValue
    extends ObjectValue {
        private SystemObject m_obj;

        public StrongObjectValue(SystemObject obj) {
            this.m_obj = obj;
        }

        @Override
        public SystemObject getObject() {
            return this.m_obj;
        }
    }

    private abstract class ObjectValue {
        private ObjectValue() {
        }

        public abstract SystemObject getObject();
    }

    private class ObjectTypeEntry {
        private final Map<String, ObjectValue> m_objectMap = new HashMap<String, ObjectValue>();
        private final Map<String, String> m_identifierMap = new HashMap<String, String>();
        private DBObjectBuilder m_builder;
        private DBObjectValidator m_validator;

        private ObjectTypeEntry() {
        }

        private DBObjectBuilder getBuilder() {
            return this.m_builder;
        }

        private void setBuilder(DBObjectBuilder builder) {
            this.m_builder = builder;
        }

        private DBObjectValidator getValidator() {
            return this.m_validator;
        }

        private void setValidator(DBObjectValidator validator) {
            this.m_validator = validator;
        }

        private SystemObject findObject(String dbName, Schema schema, String name) {
            return this.get(ObjectCache.getKeyString(dbName, schema, name));
        }

        private SystemObject findObject(SystemObject obj) {
            SystemObject retval = null;
            if (obj != null) {
                String dbName = obj.getID() instanceof BaseObjectID ? ((BaseObjectID)obj.getID()).getDatabaseName() : null;
                Schema s = obj instanceof SchemaObject ? ((SchemaObject)obj).getSchema() : null;
                retval = this.findObject(dbName, s, obj.getName());
            }
            return retval;
        }

        private SystemObject findObject(BaseObjectID id) {
            String idKey = ObjectCache.getIDKeyString(id);
            String key = idKey == null ? ObjectCache.getKeyString(id.getDatabaseName(), id.getSchemaName(), id.getName()) : this.m_identifierMap.get(idKey);
            return this.get(key);
        }

        private SystemObject get(String key) {
            ObjectValue value = key == null ? null : this.m_objectMap.get(key);
            SystemObject retval = null;
            if (value != null && (retval = value.getObject()) == null) {
                this.m_objectMap.remove(key);
            }
            return retval;
        }

        private void cacheObject(SystemObject object) {
            SystemObject oldObj;
            DBObjectID id = object.getID();
            if (!(id instanceof BaseObjectID)) {
                throw new IllegalStateException("All objects must have a BaseObjectID");
            }
            String idKey = ObjectCache.getIDKeyString((BaseObjectID)id);
            String key = ObjectCache.getKeyString(object);
            ObjectValue value = this.createValue(object);
            ObjectValue old = this.m_objectMap.put(key, value);
            if (old != null && (oldObj = old.getObject()) != null && oldObj != object) {
                DBLog.getLogger(this).log(Level.FINE, "Caching " + object.getType() + " " + object.getName() + " but we already have one!");
            }
            if (idKey != null) {
                this.m_identifierMap.put(idKey, key);
            }
        }

        private void clearCache() {
            this.m_objectMap.clear();
            this.m_identifierMap.clear();
        }

        private void addObjectToCache(SystemObject object) {
            SystemObject old = this.findObject(object);
            if (old != object) {
                if (old != null) {
                    this.removeObjectFromCache(object);
                }
                if (object != null) {
                    this.cacheObject(object);
                }
            }
        }

        private void removeObjectFromCache(SystemObject obj) {
            if (obj != null) {
                String idKey;
                DBObjectID id = obj.getID();
                if (id instanceof BaseObjectID && (idKey = ObjectCache.getIDKeyString((BaseObjectID)id)) != null) {
                    this.m_identifierMap.remove(idKey);
                }
                this.m_objectMap.remove(ObjectCache.getKeyString(obj));
            }
        }

        private ObjectValue createValue(SystemObject object) {
            return ObjectCache.this.m_weak ? new WeakObjectValue(object) : new StrongObjectValue(object);
        }
    }
}

