/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.marshal.AbstractResourceCache;
import oracle.javatools.db.marshal.DBObjectHandler;
import oracle.javatools.db.plsql.Type;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.sql.BuiltInFunction;
import oracle.javatools.db.sql.BuiltInFunctionArgument;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

public class BuiltInObjectCache
extends AbstractResourceCache {
    private Map<String, MultiMap<String, ObjectEntry>> m_objCache = new HashMap<String, MultiMap<String, ObjectEntry>>();
    private List<BuiltInFunction> m_builtInFunctions;
    private final Object m_bifLock = new Object();

    public BuiltInObjectCache(DatabaseDescriptor desc, String resourceDir) {
        super(desc, resourceDir);
    }

    public boolean isEmpty() {
        boolean retval = this.m_objCache.isEmpty();
        if (retval) {
            URL bifFile = this.getResourceClassLoader().getResource(this.getBIFResource());
            retval = bifFile == null;
        }
        return retval;
    }

    private String getBIFResource() {
        return this.getResourcePath("bif.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<BuiltInFunction> listBuiltInFunctions() {
        Object object = this.m_bifLock;
        synchronized (object) {
            if (this.m_builtInFunctions == null) {
                this.m_builtInFunctions = new ArrayList<BuiltInFunction>();
                InputStream stream = null;
                try {
                    stream = this.getResourceClassLoader().getResourceAsStream(this.getBIFResource());
                    if (stream != null) {
                        DBObjectHandler handler = this.getHandler(null);
                        for (DBObject obj : handler.read(stream, null, null)) {
                            if (!(obj instanceof BuiltInFunction)) continue;
                            BuiltInFunction bif = (BuiltInFunction)obj;
                            bif.setDescription(this.getDatabaseDescriptor().getBuiltInFunctionDescription(bif));
                            bif.setReturnTypeID(this.getPreferredTypeID(bif.getReturnTypeID()));
                            for (BuiltInFunctionArgument arg : bif.getArguments()) {
                                arg.setDataTypeID(this.getPreferredTypeID(arg.getDataTypeID()));
                            }
                            this.m_builtInFunctions.add(bif);
                        }
                    }
                }
                catch (Exception e) {
                    this.getLogger().warning(e.getMessage());
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return this.m_builtInFunctions;
    }

    private DBObjectID getPreferredTypeID(DBObjectID id) {
        DBObjectID ret = id;
        if (id instanceof DataTypeID) {
            DatabaseDescriptor desc = this.getDatabaseDescriptor();
            DataType dataType = desc.getDataType(((DataTypeID)id).getTypeName());
            if ((dataType = DataTypeHelper.unwrapDataType(dataType, PredefinedDataType.class)) instanceof PredefinedDataType) {
                PredefinedDataType pdt = (PredefinedDataType)dataType;
                PredefinedDataType.ValueType valueType = pdt.getValueType();
                for (DataType typ : desc.listPreferredDataTypes()) {
                    if (!(typ instanceof PredefinedDataType)) continue;
                    PredefinedDataType pdt2 = (PredefinedDataType)typ;
                    PredefinedDataType.ValueType valueType2 = pdt2.getValueType();
                    if (valueType == valueType2) {
                        ret = typ.getID();
                        break;
                    }
                    if (!PredefinedDataType.ValueType.isNumericType(valueType) || !PredefinedDataType.ValueType.isNumericType(valueType2)) continue;
                    ret = typ.getID();
                    break;
                }
            }
        }
        return ret;
    }

    public final <T extends SystemObject> Collection<T> listBuiltInObjects(DBObjectCriteria<T> criteria) {
        String[] types;
        ArrayList retval = new ArrayList();
        for (String type : types = criteria.getTypeArray()) {
            Class<? extends DBObject> clz = Metadata.getInstance().getObjectClass(type);
            if (SchemaObject.class.isAssignableFrom(clz)) {
                String schemaName = criteria.getSchemaName();
                if (!ModelUtil.hasLength((String)schemaName)) continue;
                this.addObjects(schemaName, type, criteria, retval);
                continue;
            }
            if (!SystemObject.class.isAssignableFrom(clz)) continue;
            this.addObjects(null, type, criteria, retval);
        }
        return retval;
    }

    private <T extends SystemObject> void addObjects(String schema, String type, DBObjectCriteria criteria, Collection<T> objs) {
        Collection entries;
        MultiMap<String, ObjectEntry> schemaCache = this.getSchemaCache(schema, false);
        if (schemaCache != null && (entries = schemaCache.get((Object)type)) != null) {
            criteria.setDatabaseDescriptor(this.getDatabaseDescriptor());
            for (ObjectEntry entry : entries) {
                SystemObject obj;
                if (!criteria.isAllowedName(entry.m_name) || (obj = entry.getObject()) == null) continue;
                if (obj instanceof SchemaObject && ((SchemaObject)obj).getSchema() == null) {
                    ((SchemaObject)obj).setSchema((Schema)this.findBuiltInObject("SCHEMA", null, schema));
                }
                objs.add(obj);
                if (criteria.isNameWild()) continue;
                break;
            }
        }
    }

    private SystemObject findBuiltInObject(String type, String schema, String name) {
        SystemObject retval = null;
        DBObjectCriteria<SystemObject> criteria = DBObjectCriteria.createSingleObjectCriteria(type, schema, name);
        Collection<SystemObject> objs = this.listBuiltInObjects(criteria);
        if (objs != null && objs.size() == 1) {
            retval = objs.iterator().next();
        }
        return retval;
    }

    private MultiMap<String, ObjectEntry> getSchemaCache(String schema, boolean create) {
        MultiMap retval = this.m_objCache.get(schema);
        if (retval == null && create) {
            retval = new MultiMap();
            this.m_objCache.put(schema, (MultiMap<String, ObjectEntry>)retval);
            if (schema != null) {
                ObjectEntry e = new ObjectEntry("SCHEMA", null, schema, null);
                this.getSchemaCache(null, true).add((Object)"SCHEMA", (Object)e);
            }
        }
        return retval;
    }

    public void registerBuiltInObject(String type, String schema, String name) {
        if (type == null || name == null) {
            throw new IllegalArgumentException("type and name must be specified.");
        }
        if (!Metadata.getInstance().isTypeOf(SystemObject.class, type)) {
            throw new IllegalArgumentException(type + "is not a SystemObject type.");
        }
        if (Metadata.getInstance().isSchemaObject(type) && !ModelUtil.hasLength((String)schema)) {
            throw new IllegalArgumentException("Schema is mandatory for " + type);
        }
        String path = this.getResourcePath(schema, name + "." + type.toLowerCase());
        this.registerBuiltInObject(schema, new ObjectEntry(type, schema, name, path));
    }

    public void registerBuiltInObject(SystemObject obj) {
        ObjectEntry entry = new ObjectEntry(obj);
        Schema schema = DBUtil.getSchema(obj);
        this.registerBuiltInObject(schema == null ? null : schema.getName(), entry);
    }

    private void registerBuiltInObject(String schema, ObjectEntry entry) {
        MultiMap<String, ObjectEntry> schemaCache = this.getSchemaCache(schema, true);
        schemaCache.add((Object)entry.m_type, (Object)entry);
    }

    private class ObjectEntry {
        private final String m_schemaName;
        private final String m_type;
        private final String m_name;
        private final String m_resourcePath;
        private SystemObject m_obj;

        ObjectEntry(SystemObject obj) {
            this(obj.getType(), DBUtil.getSchemaName(obj), obj.getName(), null);
            this.m_obj = obj;
        }

        ObjectEntry(String type, String schemaName, String name, String resourcePath) {
            this.m_schemaName = schemaName;
            this.m_type = type;
            this.m_name = name;
            this.m_resourcePath = resourcePath;
        }

        public SystemObject getObject() {
            if (this.m_obj == null) {
                Class<? extends DBObject> objClz = Metadata.getInstance().getObjectClass(this.m_type);
                try {
                    this.m_obj = (SystemObject)objClz.newInstance();
                    this.m_obj.setName(this.m_name);
                }
                catch (Exception e) {
                    String msg = this.m_type + " is not a valid SystemObject type";
                    BuiltInObjectCache.this.getLogger().log(Level.FINE, msg, e);
                    BuiltInObjectCache.this.getLogger().warning(msg);
                }
            }
            if (this.m_resourcePath != null) {
                BuiltInObjectCache.this.markForLazyInit((AbstractBuildableObject)((Object)this.m_obj), this.m_resourcePath);
            }
            if (this.m_obj.getID() == null) {
                DBObjectID id = this.m_obj instanceof Type ? new DataTypeID(this.m_name, this.m_schemaName, BuiltInObjectCache.this.getDatabaseDescriptor()) : new ReferenceID(this.m_type, this.m_schemaName, this.m_name);
                this.m_obj.setID(id);
            }
            return this.m_obj;
        }

        public int hashCode() {
            return this.m_name.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ObjectEntry && this.m_type.equals(((ObjectEntry)obj).m_type) && this.m_name.equals(((ObjectEntry)obj).m_name);
        }
    }
}

