/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import oracle.bali.ewt.wizard.Background;
import oracle.bali.ewt.wizard.BackgroundGradient;
import oracle.bali.ewt.wizard.BackgroundImage;

public class WizardBackgroundHandler {
    private PropertyChangeSupport _propertySupport;
    private Background[] _panels = new Background[7];

    public static final Panel findPanel(String panelName) {
        Panel panel = null;
        try {
            panel = Panel.valueOf(panelName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (panel != null) {
            return panel;
        }
        return Panel.CONTENT;
    }

    public static final Panel findPanel(int i) {
        Panel panel = null;
        switch (i) {
            case 0: {
                panel = Panel.HEADER;
                break;
            }
            case 1: {
                panel = Panel.LOGO;
                break;
            }
            case 2: {
                panel = Panel.ROADMAP;
                break;
            }
            case 3: {
                panel = Panel.CONTENT;
                break;
            }
            case 4: {
                panel = Panel.AUXILIARY;
                break;
            }
            case 5: {
                panel = Panel.MESSAGE;
                break;
            }
            case 6: {
                panel = Panel.BUTTON;
                break;
            }
            default: {
                panel = Panel.CONTENT;
            }
        }
        return panel;
    }

    public static final Position findPosition(int i) {
        Position position = null;
        switch (i) {
            case 0: {
                position = Position.TOP_LEFT_CORNER;
                break;
            }
            case 1: {
                position = Position.TOP_CENTER_EDGE;
                break;
            }
            case 2: {
                position = Position.TOP_RIGHT_CORNER;
                break;
            }
            case 3: {
                position = Position.CENTER_LEFT_EDGE;
                break;
            }
            case 4: {
                position = Position.CENTER;
                break;
            }
            case 5: {
                position = Position.CENTER_RIGHT_EDGE;
                break;
            }
            case 6: {
                position = Position.BOTTOM_LEFT_CORNER;
                break;
            }
            case 7: {
                position = Position.BOTTOM_CENTER_EDGE;
                break;
            }
            case 8: {
                position = Position.BOTTOM_RIGHT_CORNER;
                break;
            }
            default: {
                position = Position.CENTER;
            }
        }
        return position;
    }

    public static final Position findPosition(String placement) {
        Position pl = null;
        try {
            pl = Position.valueOf(placement);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (pl != null) {
            return pl;
        }
        return Position.CENTER;
    }

    public static final Stretch findStretch(String stretch) {
        Stretch stretchable = null;
        try {
            stretchable = Stretch.valueOf(stretch);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (stretchable != null) {
            return stretchable;
        }
        return Stretch.BOTH;
    }

    public static final GradientType findGradientType(String grad) {
        GradientType gradient = null;
        try {
            gradient = GradientType.valueOf(grad);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (gradient != null) {
            return gradient;
        }
        return GradientType.VERTICAL;
    }

    public static final ImageBoundary findBoundary(String boundary) {
        ImageBoundary iBoundary = null;
        try {
            iBoundary = ImageBoundary.valueOf(boundary);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (iBoundary != null) {
            return iBoundary;
        }
        return ImageBoundary.PANE;
    }

    public void setBackgroundGradient(Panel panel, Color ... colors) {
        this.setBackgroundGradient(panel, GradientType.VERTICAL, colors);
    }

    public void setBackgroundGradient(Panel panel, GradientType type, Color ... colors) {
        if (panel == null || colors == null || colors.length != 1 && colors.length != 2) {
            return;
        }
        int panelIindex = panel.ordinal();
        Background bg = this._panels[panelIindex];
        BackgroundGradient bgGrad = null;
        bgGrad = colors.length == 1 ? new BackgroundGradient(type, colors[0], colors[0]) : new BackgroundGradient(type, colors[0], colors[1]);
        if (bg == null) {
            bg = new Background();
            bg.setGradient(bgGrad);
            this._panels[panelIindex] = bg;
        } else {
            bg.setGradient(bgGrad);
        }
        this.firePropertyChange(panel.toString(), null, bg);
    }

    public GradientType getGradientType(Panel panel) {
        Background bg;
        Background background = bg = panel == null ? null : this._panels[panel.ordinal()];
        if (bg == null) {
            return null;
        }
        BackgroundGradient grad = bg.getGradient();
        return grad == null ? null : grad.getType();
    }

    public Color[] getGradientColors(Panel panel) {
        Color[] colorArray;
        Background bg;
        Background background = bg = panel == null ? null : this._panels[panel.ordinal()];
        if (bg == null) {
            return null;
        }
        BackgroundGradient grad = bg.getGradient();
        if (grad == null) {
            colorArray = null;
        } else {
            Color[] colorArray2 = new Color[2];
            colorArray2[0] = grad.getFirst();
            colorArray = colorArray2;
            colorArray2[1] = grad.getSecond();
        }
        return colorArray;
    }

    public void setBackgroundImage(Panel panel, String url) {
        this.setBackgroundImage(panel, Position.CENTER, url, Stretch.BOTH, ImageBoundary.PANE);
    }

    public void setBackgroundImage(Panel panel, Position position, String url) {
        this.setBackgroundImage(panel, position, url, Stretch.BOTH, ImageBoundary.PANE);
    }

    public void setBackgroundImage(Panel panel, Position position, String url, Stretch stretch) {
        this.setBackgroundImage(panel, position, url, stretch, ImageBoundary.PANE);
    }

    public void setBackgroundImage(Panel panel, Position position, String url, Stretch stretch, ImageBoundary bound) {
        URL imageUrl = null;
        BufferedImage image = null;
        try {
            imageUrl = new URL(url);
            image = ImageIO.read(imageUrl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setBackgroundImage(panel, position, image, stretch, bound);
    }

    public void setBackgroundImage(Panel panel, Position position, Image image, Stretch stretch, ImageBoundary bound) {
        int panelIindex = panel.ordinal();
        int plIndex = position.ordinal();
        Background bg = this._panels[panelIindex];
        if (bg == null) {
            bg = new Background();
            bg.setBackgroundImage(new BackgroundImage(image, stretch, bound), plIndex);
            this._panels[panelIindex] = bg;
        } else {
            bg.setBackgroundImage(new BackgroundImage(image, stretch, bound), plIndex);
        }
        this.firePropertyChange(panel.toString(), null, bg);
    }

    public Image getBackgroundImage(Panel panel, Position position) {
        if (panel == null || position == null) {
            return null;
        }
        int panelIindex = panel.ordinal();
        int plIndex = position.ordinal();
        Background bg = this._panels[panelIindex];
        BackgroundImage bgImage = bg == null ? null : bg.getImage(plIndex);
        return bgImage == null ? null : bgImage.getIcon();
    }

    public Stretch getBackgroundImageStretch(Panel panel, Position position) {
        if (panel == null || position == null) {
            return null;
        }
        int panelIindex = panel.ordinal();
        int plIndex = position.ordinal();
        Background bg = this._panels[panelIindex];
        BackgroundImage bgImage = bg == null ? null : bg.getImage(plIndex);
        return bgImage == null ? null : bgImage.getStretch();
    }

    public ImageBoundary getBackgroundImageBoundary(Panel panel, Position position) {
        if (panel == null || position == null) {
            return null;
        }
        int panelIindex = panel.ordinal();
        int plIndex = position.ordinal();
        Background bg = this._panels[panelIindex];
        BackgroundImage bgImage = bg == null ? null : bg.getImage(plIndex);
        return bgImage == null ? null : bgImage.getImageBoundary();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    Background[] __getBackgrounds() {
        return this._panels;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageBoundary {
        PANE,
        IMAGE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Stretch {
        NONE,
        HORIZONTAL,
        VERTICAL,
        BOTH;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GradientType {
        VERTICAL,
        HORIZONTAL,
        BACKSLASH,
        SLASH,
        RADIAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Position {
        TOP_LEFT_CORNER,
        TOP_CENTER_EDGE,
        TOP_RIGHT_CORNER,
        CENTER_LEFT_EDGE,
        CENTER,
        CENTER_RIGHT_EDGE,
        BOTTOM_LEFT_CORNER,
        BOTTOM_CENTER_EDGE,
        BOTTOM_RIGHT_CORNER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Panel {
        HEADER,
        LOGO,
        ROADMAP,
        CONTENT,
        AUXILIARY,
        MESSAGE,
        BUTTON;

    }
}

