/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.UIManager;
import oracle.bali.ewt.elaf.EWTWizardUI;
import oracle.bali.ewt.layout.NamelessCardLayout;
import oracle.bali.ewt.wizard.AccessibleLWComponent;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardPage;

public class Wizard
extends BaseWizard {
    private AccessibleLWComponent _pageContainer;
    private boolean _mustFinish;
    private WizardPage _pageAdding;

    public Wizard() {
        this._mustFinish = true;
    }

    Wizard(boolean sequential) {
        super(sequential);
    }

    public void setMustFinish(boolean mustFinish) {
        boolean oldValue = this._mustFinish;
        this._mustFinish = mustFinish;
        this.firePropertyChange("mustFinish", oldValue, this._mustFinish);
        this.enableButtons();
    }

    public boolean getMustFinish() {
        return this._mustFinish;
    }

    public synchronized WizardPage addPage(WizardPage page, WizardPage beforeWhichPage) {
        Component content = page.getContent();
        content.setVisible(false);
        this._pageContainer.add(content);
        this._pageAdding = page;
        page = super.addPage(page, beforeWhichPage);
        this._pageAdding = null;
        return page;
    }

    public synchronized void removePage(WizardPage page) {
        if (page != this._pageAdding) {
            this._pageContainer.remove(page.getContent());
        }
        super.removePage(page);
    }

    public synchronized void removeAllPages() {
        this._pageContainer.removeAll();
        super.removeAllPages();
    }

    public void dispose() {
        super.dispose();
        this._pageContainer = null;
    }

    protected void setSelectedPage(WizardPage page) {
        super.setSelectedPage(page);
        if (page != null) {
            NamelessCardLayout.flipToComponent(page.getContent());
        }
    }

    protected void pagePropertyChange(WizardPage page, PropertyChangeEvent event) {
        super.pagePropertyChange(page, event);
        String property = event.getPropertyName();
        if (property.equals("content")) {
            this._pageContainer.remove((Component)event.getOldValue());
            this._pageContainer.add((Component)event.getNewValue());
            this.revalidate();
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this._pageContainer == null) {
            this._pageContainer = new AccessibleLWComponent();
            this._pageContainer.setLayout(NamelessCardLayout.getLayoutManager());
            this._pageContainer.setOpaque(Boolean.TRUE.equals(UIManager.get("EWTWizardPanels.opaque")));
            this.add((Component)this._pageContainer, PAGE_CONTAINER);
        }
        ((EWTWizardUI)this.ui).updateContentUI(this._pageContainer);
    }
}

