/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.peer.ComponentPeer;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.swing.DefaultFocusManager;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;

public final class FocusUtils {
    private static boolean _sJDK14orHigher = false;
    private static Method _sSetFocusTraversalKeysEnabled;
    private static Method _sIsFocusable;
    private static Method _sSetFocusable;
    private static Method _sRequestFocusInWindow;
    private static Method _sFocusEventOppComp;
    private static Method _sPeerIsFocusable;
    private static Method _sGetFocusableWindowState;
    private static Method _sSetFocusableWindowState;

    public static final boolean areNewFocusAPIsAvailable() {
        return _sJDK14orHigher;
    }

    public static final Component getMostRecentFocusOwner(Window window) {
        Component focusOwner = null;
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method m = Window.class.getMethod("getMostRecentFocusOwner", null);
                focusOwner = (Component)m.invoke((Object)window, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return focusOwner;
    }

    public static final void transferFocus(Component component, boolean forward) {
        boolean callTransferFocus = forward;
        if (!forward) {
            if (FocusUtils.areNewFocusAPIsAvailable()) {
                try {
                    Class<?> c = component.getClass();
                    Method transferFocusBackwardMethod = c.getMethod("transferFocusBackward", null);
                    transferFocusBackwardMethod.invoke((Object)component, (Object[])null);
                }
                catch (Exception e) {
                    callTransferFocus = true;
                }
            } else {
                callTransferFocus = true;
            }
        }
        if (callTransferFocus) {
            component.transferFocus();
        }
    }

    public static final boolean isFocusable(Component component) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method isFocusableMethod = FocusUtils._getIsFocusableMethod();
                Object o = isFocusableMethod.invoke((Object)component, (Object[])null);
                return Boolean.TRUE.equals(o);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return component.isFocusTraversable();
    }

    public static final void setFocusable(Component component, boolean focusable) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method setFocusableMethod = FocusUtils._getSetFocusableMethod();
                Object[] args = new Object[]{new Boolean(focusable)};
                Object object = setFocusableMethod.invoke((Object)component, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void setFocusTraversalKeysEnabled(Component component, boolean enabled) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method setFocusMethod = FocusUtils._getFocusTraversalMethod();
                Object[] args = new Object[]{new Boolean(enabled)};
                setFocusMethod.invoke((Object)component, args);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setFocusTraversalKeysEnabled(Component component, boolean enabled, boolean recursive) {
        FocusUtils.setFocusTraversalKeysEnabled(component, enabled);
        if (recursive && FocusUtils.areNewFocusAPIsAvailable() && component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                FocusUtils.setFocusTraversalKeysEnabled(container.getComponent(i), enabled, recursive);
            }
        }
    }

    public static void requestFocus(Component component) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method requestFocusInWindowMethod = FocusUtils._getRequestFocusInWindowMethod();
                requestFocusInWindowMethod.invoke((Object)component, (Object[])null);
            }
            catch (Exception e) {
                component.requestFocus();
            }
        } else {
            component.requestFocus();
        }
    }

    public static final Component getFirstFocusableComponent(Container content) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method m2;
                Object o2;
                Method getFocusTraversalPolicyMethod = Container.class.getMethod("getFocusTraversalPolicy", null);
                Object ftp = getFocusTraversalPolicyMethod.invoke((Object)content, (Object[])null);
                if (ftp == null && (o2 = (m2 = Component.class.getMethod("getFocusCycleRootAncestor", null)).invoke((Object)content, (Object[])null)) != null) {
                    ftp = getFocusTraversalPolicyMethod.invoke(o2, (Object[])null);
                }
                if (ftp != null) {
                    Class<?> focusTraversalPolicyClass = Class.forName("java.awt.FocusTraversalPolicy");
                    Class[] params = new Class[]{Container.class};
                    Method getFirstComponentMethod = focusTraversalPolicyClass.getMethod("getFirstComponent", params);
                    Object[] args = new Object[]{content};
                    Object toRet = getFirstComponentMethod.invoke(ftp, args);
                    return (Component)toRet;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return FocusUtils._getFirstFocusableComponentOLD(content);
    }

    public static Component getOppositeComponent(FocusEvent e) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                Method focusEventOppCompMethod = FocusUtils._getFocusEventOppCompMethod();
                if (focusEventOppCompMethod != null) {
                    return (Component)focusEventOppCompMethod.invoke((Object)e, (Object[])null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean getAcceptsFocus(Component comp) {
        boolean acceptsFocus;
        boolean bl = acceptsFocus = comp.isVisible() && comp.isEnabled() && FocusUtils.isFocusable(comp) && comp.isDisplayable();
        if (!acceptsFocus || !FocusUtils.areNewFocusAPIsAvailable()) {
            return acceptsFocus;
        }
        if (!(comp instanceof Window)) {
            for (Container enableTest = comp.getParent(); enableTest != null; enableTest = enableTest.getParent()) {
                if (!enableTest.isEnabled() && !enableTest.isLightweight()) {
                    return false;
                }
                if (enableTest instanceof Window) break;
            }
        }
        if (comp instanceof JTable) {
            return true;
        }
        if (comp instanceof JComboBox) {
            JComboBox box = (JComboBox)comp;
            return box.getUI().isFocusTraversable(box);
        }
        if (comp instanceof JComponent) {
            InputMap inputMap;
            JComponent jComponent = (JComponent)comp;
            for (inputMap = jComponent.getInputMap(0); inputMap != null && inputMap.size() == 0; inputMap = inputMap.getParent()) {
            }
            if (inputMap != null) {
                return true;
            }
        }
        ComponentPeer peer = comp.getPeer();
        Method peerIsFocusableMethod = FocusUtils._getPeerIsFocusableMethod();
        if (peer != null && peerIsFocusableMethod != null) {
            try {
                Boolean peerFocusable = (Boolean)peerIsFocusableMethod.invoke((Object)peer, (Object[])null);
                return acceptsFocus && Boolean.TRUE.equals(peerFocusable);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean getFocusableWindowState(Window window) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                if (_sGetFocusableWindowState == null) {
                    _sGetFocusableWindowState = Window.class.getMethod("getFocusableWindowState", null);
                }
                Object result = _sGetFocusableWindowState.invoke((Object)window, (Object[])null);
                return Boolean.TRUE.equals(result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static void setFocusableWindowState(Window window, boolean state) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            try {
                if (_sSetFocusableWindowState == null) {
                    Class[] args = new Class[]{Boolean.TYPE};
                    _sSetFocusableWindowState = Window.class.getMethod("setFocusableWindowState", args);
                }
                Object[] params = new Object[]{new Boolean(state)};
                _sSetFocusableWindowState.invoke((Object)window, params);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static Method _getFocusTraversalMethod() {
        if (_sSetFocusTraversalKeysEnabled == null) {
            try {
                Class<Component> c = Component.class;
                Class[] params = new Class[]{Boolean.TYPE};
                _sSetFocusTraversalKeysEnabled = c.getMethod("setFocusTraversalKeysEnabled", params);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sSetFocusTraversalKeysEnabled;
    }

    private static Method _getSetFocusableMethod() {
        if (_sSetFocusable == null) {
            try {
                Class<Component> c = Component.class;
                Class[] params = new Class[]{Boolean.TYPE};
                _sSetFocusable = c.getMethod("setFocusable", params);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sSetFocusable;
    }

    private static Method _getIsFocusableMethod() {
        if (_sIsFocusable == null) {
            try {
                Class<Component> c = Component.class;
                _sIsFocusable = c.getMethod("isFocusable", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sIsFocusable;
    }

    private static Method _getRequestFocusInWindowMethod() {
        if (_sRequestFocusInWindow == null) {
            try {
                Class<Component> c = Component.class;
                _sRequestFocusInWindow = c.getMethod("requestFocusInWindow", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sRequestFocusInWindow;
    }

    private static final Component _getFirstFocusableComponentOLD(Container content) {
        Component nextComponent;
        Container container = null;
        if (content != null && content.isEnabled() && content.isVisible() && FocusUtils.isFocusable(content)) {
            return content;
        }
        container = content;
        Component component = nextComponent = container.getComponentCount() == 0 ? null : container.getComponent(0);
        if (nextComponent == null) {
            return null;
        }
        DefaultFocusManager dfm = new DefaultFocusManager();
        HashSet<Component> visitedComps = new HashSet<Component>();
        while ((nextComponent = FocusUtils.getNextComponent(nextComponent, container, true, dfm)) != null) {
            if (!visitedComps.add(nextComponent)) {
                nextComponent = null;
                break;
            }
            if (!nextComponent.isVisible() || !FocusUtils.isFocusable(nextComponent) || !nextComponent.isEnabled()) continue;
        }
        return nextComponent;
    }

    private static Component getNextComponent(Component component, Container root, boolean canGoDown, DefaultFocusManager dfm) {
        Component nsv = null;
        if (canGoDown && component.isVisible() && (!(component instanceof JComponent) || !((JComponent)component).isManagingFocus()) && component instanceof Container && ((Container)component).getComponentCount() > 0) {
            return dfm.getFirstComponent((Container)component);
        }
        Container parent = component.getParent();
        nsv = dfm.getComponentAfter(parent, component);
        if (nsv != null) {
            return nsv;
        }
        if (parent == root) {
            return root;
        }
        return FocusUtils.getNextComponent(parent, root, false, dfm);
    }

    private static Method _getFocusEventOppCompMethod() {
        if (_sFocusEventOppComp == null) {
            try {
                _sFocusEventOppComp = FocusEvent.class.getMethod("getOppositeComponent", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sFocusEventOppComp;
    }

    private static Method _getPeerIsFocusableMethod() {
        if (_sPeerIsFocusable == null) {
            try {
                _sPeerIsFocusable = ComponentPeer.class.getMethod("isFocusable", null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return _sPeerIsFocusable;
    }

    private FocusUtils() {
    }

    static {
        try {
            Class<?> c = Class.forName("java.awt.KeyboardFocusManager");
            _sJDK14orHigher = true;
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _sSetFocusTraversalKeysEnabled = null;
        _sIsFocusable = null;
        _sSetFocusable = null;
        _sRequestFocusInWindow = null;
        _sFocusEventOppComp = null;
        _sPeerIsFocusable = null;
        _sGetFocusableWindowState = null;
        _sSetFocusableWindowState = null;
    }
}

