/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;

final class TableLayoutManager
implements LayoutManager {
    private Grid _grid;
    private Header _rowHeader;
    private Header _columnHeader;

    TableLayoutManager() {
    }

    public void addLayoutComponent(String name, Component comp) {
        if (name.equals("grid")) {
            this._grid = (Grid)comp;
        } else if (name.equals("rowHeader")) {
            this._rowHeader = (Header)comp;
        } else if (name.equals("columnHeader")) {
            this._columnHeader = (Header)comp;
        } else {
            comp.setVisible(false);
        }
    }

    public void removeLayoutComponent(Component comp) {
        if (comp == this._grid) {
            this._grid = null;
        } else if (comp == this._rowHeader) {
            this._rowHeader = null;
        } else if (comp == this._columnHeader) {
            this._columnHeader = null;
        }
    }

    public Dimension preferredLayoutSize(Container parent) {
        SpreadTable table = (SpreadTable)parent;
        Dimension size = new Dimension(this._grid.getPreferredSize());
        if (table.isRowHeaderVisible() && this._rowHeader != null) {
            size.width += table.getRowHeaderWidth();
        }
        if (table.isColumnHeaderVisible() && this._columnHeader != null) {
            size.height += table.getColumnHeaderHeight();
        }
        return size;
    }

    public Dimension minimumLayoutSize(Container parent) {
        SpreadTable table = (SpreadTable)parent;
        Dimension size = new Dimension(this._grid.getMinimumSize());
        if (table.isRowHeaderVisible() && this._rowHeader != null) {
            size.width += this._rowHeader.getMinimumSize().width;
        }
        if (table.isColumnHeaderVisible() && this._columnHeader != null) {
            size.height += this._columnHeader.getMinimumSize().height;
        }
        return size;
    }

    public void layoutContainer(Container parent) {
        SpreadTable table = (SpreadTable)parent;
        boolean l2r = table.getActualReadingDirection() == 1;
        Dimension d = table.getSize();
        ImmInsets insets = table.getBorderInsets();
        if (insets != null) {
            d.width -= insets.left + insets.right;
            d.height -= insets.top + insets.bottom;
        }
        if (d.width <= 0 || d.height <= 0) {
            return;
        }
        boolean rowHeaderVisible = table.isRowHeaderVisible() && this._rowHeader != null;
        boolean columnHeaderVisible = table.isColumnHeaderVisible() && this._columnHeader != null;
        int rowWidth = rowHeaderVisible ? table.getRowHeaderWidth() : 0;
        int columnHeight = columnHeaderVisible ? table.getColumnHeaderHeight() : 0;
        Point origin = insets == null ? new Point() : new Point(insets.left, insets.top);
        int gridX = origin.x;
        int gridY = origin.y;
        if (rowHeaderVisible) {
            int rowX;
            this._rowHeader.setVisible(true);
            int n = rowX = l2r ? origin.x : d.width - rowWidth + origin.x;
            if (columnHeaderVisible) {
                this._rowHeader.setBounds(rowX, columnHeight + origin.y, rowWidth, d.height - columnHeight);
            } else {
                this._rowHeader.setBounds(rowX, origin.y, rowWidth, d.height);
            }
            if (l2r) {
                gridX += rowWidth;
            }
        } else if (this._rowHeader != null) {
            this._rowHeader.setVisible(false);
        }
        if (columnHeaderVisible) {
            this._columnHeader.setVisible(true);
            if (rowHeaderVisible) {
                int columnX = l2r ? rowWidth + origin.x : origin.x;
                this._columnHeader.setBounds(columnX, origin.y, d.width - rowWidth, columnHeight);
            } else {
                this._columnHeader.setBounds(origin.x, origin.y, d.width, columnHeight);
            }
            gridY += columnHeight;
        } else if (this._columnHeader != null) {
            this._columnHeader.setVisible(false);
        }
        this._grid.setVisible(true);
        this._grid.setBounds(gridX, gridY, d.width - rowWidth, d.height - columnHeight);
        if (columnHeaderVisible && rowHeaderVisible) {
            Component corner;
            if (l2r) {
                corner = table.getCornerComponent("UPPER_LEFT_CORNER");
                if (corner != null) {
                    corner.setBounds(origin.x, origin.y, rowWidth, columnHeight);
                }
            } else {
                corner = table.getCornerComponent("UPPER_RIGHT_CORNER");
                if (corner != null) {
                    corner.setBounds(gridX + (d.width - rowWidth), origin.y, rowWidth, columnHeight);
                }
            }
            if (corner != null) {
                corner.setVisible(true);
            }
        }
    }
}

