/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIDefaults;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

class ThreeDSeparatorPainter
extends AbstractPainter {
    private boolean _isInset;
    private boolean _isHorizontal;
    private boolean _lightColors;

    public ThreeDSeparatorPainter(boolean isInset, boolean isHorizontal, boolean alwaysUseLightColors) {
        this._isInset = isInset;
        this._isHorizontal = isHorizontal;
        this._lightColors = alwaysUseLightColors;
    }

    public final Dimension getMinimumSize(PaintContext context) {
        return new Dimension(2, 2);
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color secondColor;
        Color firstColor;
        Color lightColor;
        Color darkColor;
        Color savedColor = g.getColor();
        UIDefaults defaults = context.getPaintUIDefaults();
        if ((context.getPaintState() & 4) != 0) {
            darkColor = this._lightColors ? defaults.getColor(LookAndFeel.NORMAL_INTENSITY) : defaults.getColor("controlShadowDark");
            lightColor = darkColor;
        } else if (this._lightColors) {
            darkColor = defaults.getColor(LookAndFeel.DARK_INTENSITY);
            lightColor = Color.white;
        } else {
            darkColor = defaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
            lightColor = defaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
        }
        if (this._isInset) {
            firstColor = darkColor;
            secondColor = lightColor;
        } else {
            firstColor = lightColor;
            secondColor = darkColor;
        }
        if (this._isHorizontal) {
            int right = x + width - 1;
            g.setColor(firstColor);
            g.drawLine(x, y += (height - 2) / 2, right - 1, y);
            g.drawLine(x, ++y, x, y);
            g.setColor(secondColor);
            g.drawLine(x + 1, y, right, y);
            g.drawLine(right, --y, right, y);
        } else {
            int bottom = y + height - 1;
            g.setColor(firstColor);
            g.drawLine(x += (width - 2) / 2, y, x, bottom - 1);
            g.drawLine(++x, y, x, y);
            g.setColor(secondColor);
            g.drawLine(x, y + 1, x, bottom);
            g.drawLine(--x, bottom, x, bottom);
        }
        g.setColor(savedColor);
    }

    public int getRepaintFlags(PaintContext context) {
        return 4;
    }
}

