/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.IndexColorModel;
import javax.swing.UIDefaults;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.graphics.SpacingIcon;
import oracle.bali.ewt.olaf.ClassInstantiator;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.GrayFilter;
import oracle.bali.ewt.olaf.MultiUIDefaults;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.plaf.StringInstantiator;
import oracle.bali.share.util.IntegerUtils;

public class OracleLookAndFeel
extends BasicLookAndFeel {
    private static final String _DARK_DEFAULTS = "UIDefaults.dark";
    private static final String _LIGHT_DEFAULTS = "UIDefaults.light";
    private static final String _PACKAGE_NAME = "oracle.bali.ewt.olaf.";
    private static final String _UIUTILS_NAME = "oracle.bali.ewt.olaf.OracleUIUtils";
    private static final String _DEF_IMAGE_INSTANT = "oracle.bali.ewt.olaf.OracleUIUtils#imageInst|";
    private static final String _DEF_CIMAGE_INSTANT = "oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|";
    private static final String _DEF_CICON_INSTANT = "oracle.bali.ewt.olaf.OracleUIUtils#cIconInst|";
    private static final int _DEFAULT_SCHEME_INDEX = 6;
    private static final boolean _USE_HIGH_COLOR;
    private static final ColorScheme _sDefaultScheme;
    private static ColorScheme[] _sAvailableSchemes;
    private static ColorScheme _sCurrentScheme;

    public String getName() {
        return "Oracle Look and Feel";
    }

    public String getID() {
        return "Oracle";
    }

    public String getDescription() {
        return "The Oracle Look and Feel";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public static ColorScheme getColorScheme() {
        return _sCurrentScheme;
    }

    public static void setColorScheme(Color matchColor) {
        _sCurrentScheme = OracleLookAndFeel.__getColorScheme(OracleLookAndFeel._getAvailableSchemes(), matchColor);
    }

    public static void setColorScheme(String schemeName) {
        ColorScheme scheme = OracleLookAndFeel.__getColorScheme(OracleLookAndFeel._getAvailableSchemes(), schemeName);
        _sCurrentScheme = scheme == null ? _sDefaultScheme : scheme;
    }

    public static ColorScheme[] getAvailableColorSchemes() {
        return (ColorScheme[])OracleLookAndFeel._getAvailableSchemes().clone();
    }

    public static void setAppletsAlwaysActive(boolean active) {
        JPaintContext.setAppletsAlwaysActive(active);
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if (key.equals(_DARK_DEFAULTS)) {
            MultiUIDefaults multi = new MultiUIDefaults(new UIDefaults[]{defaults});
            OracleLookAndFeel.getColorScheme()._installDarkColors(multi);
            OracleLookAndFeel._initDarkComponentDefaults(multi);
            return multi;
        }
        if (_LIGHT_DEFAULTS.equals(key)) {
            MultiUIDefaults multi = new MultiUIDefaults(new UIDefaults[]{defaults});
            OracleLookAndFeel._initLightComponentDefaults(multi);
            return multi;
        }
        return null;
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        Object[] uiDefaults = new String[]{"ButtonUI", "oracle.bali.ewt.olaf.OracleButtonUI", "CheckBoxUI", "oracle.bali.ewt.olaf.OracleCheckBoxUI", "CheckBoxMenuItemUI", "oracle.bali.ewt.olaf.OracleCheckBoxMenuItemUI", "ComboBoxUI", "oracle.bali.ewt.olaf.OracleComboBoxUI", "FileChooserUI", "oracle.bali.ewt.olaf.OracleFileChooserUI", "LabelUI", "oracle.bali.ewt.olaf.OracleLabelUI", "ListUI", "oracle.bali.ewt.olaf.OracleListUI", "MenuUI", "oracle.bali.ewt.olaf.OracleMenuUI", "MenuItemUI", "oracle.bali.ewt.olaf.OracleMenuItemUI", "OptionPaneUI", "oracle.bali.ewt.olaf.OracleOptionPaneUI", "PopupMenuUI", "oracle.bali.ewt.olaf.OraclePopupMenuUI", "PasswordFieldUI", "oracle.bali.ewt.olaf.OraclePasswordFieldUI", "PopupMenuSeparatorUI", "oracle.bali.ewt.olaf.OraclePopupMenuSeparatorUI", "ProgressBarUI", "oracle.bali.ewt.olaf.OracleProgressBarUI", "RadioButtonUI", "oracle.bali.ewt.olaf.OracleRadioButtonUI", "RadioButtonMenuItemUI", "oracle.bali.ewt.olaf.OracleRadioButtonMenuItemUI", "ScrollBarUI", "oracle.bali.ewt.olaf.OracleScrollBarUI", "ScrollPaneUI", "oracle.bali.ewt.olaf.OracleScrollPaneUI", "SeparatorUI", "oracle.bali.ewt.olaf.OracleSeparatorUI", "SliderUI", "oracle.bali.ewt.olaf.OracleSliderUI", "SplitPaneUI", "oracle.bali.ewt.olaf.OracleSplitPaneUI", "TabbedPaneUI", "oracle.bali.ewt.olaf.OracleTabbedPaneUI", "TextAreaUI", "oracle.bali.ewt.olaf.OracleTextAreaUI", "TextFieldUI", "oracle.bali.ewt.olaf.OracleTextFieldUI", "ToggleButtonUI", "oracle.bali.ewt.olaf.OracleButtonUI", "ToolBarUI", "oracle.bali.ewt.olaf.OracleToolBarUI", "ToolBarSeparatorUI", "oracle.bali.ewt.olaf.OracleToolBarSeparatorUI", "ToolTipUI", "oracle.bali.ewt.olaf.OracleToolTipUI", "TreeUI", "oracle.bali.ewt.olaf.OracleTreeUI", "InternalFrameUI", "oracle.bali.ewt.olaf.OracleInternalFrameUI", "DesktopIconUI", "oracle.bali.ewt.olaf.OracleDesktopIconUI", "PanelUI", "oracle.bali.ewt.olaf.OraclePanelUI", "EditorPaneUI", "oracle.bali.ewt.olaf.OracleEditorPaneUI", "TableUI", "oracle.bali.ewt.olaf.OracleTableUI"};
        table.putDefaults(uiDefaults);
        ClassInstantiator.putInstantiators(table, (String[])uiDefaults);
        table.put("UIBorderFactory", new StringInstantiator("oracle.bali.ewt.olaf.OracleBorderFactory"));
        table.put(_DARK_DEFAULTS, new StringInstantiator("oracle.bali.ewt.olaf.OracleLookAndFeel", _DARK_DEFAULTS));
        table.put(_LIGHT_DEFAULTS, new StringInstantiator("oracle.bali.ewt.olaf.OracleLookAndFeel", _LIGHT_DEFAULTS));
        table.put("LookAndFeel.requiresActiveChangeRepaint", Boolean.TRUE);
        UIDefaults.ActiveValue disablingFilter = new UIDefaults.ActiveValue(){

            public Object createValue(UIDefaults table) {
                return new GrayFilter(true);
            }
        };
        table.put("disablingFilter", disablingFilter);
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        this.loadSystemColors(table, this.getSystemColors(), false);
        this.installColors(table);
    }

    protected void installColors(UIDefaults table) {
        OracleLookAndFeel.getColorScheme()._installCommonColors(table);
        OracleLookAndFeel.getColorScheme()._installLightColors(table);
    }

    protected String[] getSystemColors() {
        String[] fixedSystemColors = new String[]{"textHighlight", "#0000FF", "selectedFocus", "#FFFFFF", "windowBorder", "#000000", "info", "#FFFFCC", "desktop", "#666666"};
        return fixedSystemColors;
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        FontUIResource dialogPlain12 = new FontUIResource("Dialog", 0, 12);
        FontUIResource sansSerifPlain12 = new FontUIResource("SansSerif", 0, 12);
        FontUIResource monospacedPlain12 = new FontUIResource("Monospaced", 0, 12);
        FontUIResource smallFont = new FontUIResource("SansSerif", 0, 9);
        Integer caretBlinkRate = new Integer(500);
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        Border wideInset = OracleUIUtils.getWideInsetBorder();
        Border narrowInset = OracleUIUtils.getNarrowInsetBorder();
        BorderUIResource.CompoundBorderUIResource wideMarginInset = new BorderUIResource.CompoundBorderUIResource(wideInset, marginBorder);
        BorderUIResource.CompoundBorderUIResource narrowMarginInset = new BorderUIResource.CompoundBorderUIResource(narrowInset, marginBorder);
        InsetsUIResource pixelInsets = new InsetsUIResource(1, 1, 1, 1);
        InsetsUIResource zeroInsets = new InsetsUIResource(0, 0, 0, 0);
        Object[] fieldArray = new Object[]{"ctrl C", "copy-to-clipboard", "ctrl INSERT", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "shift INSERT", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "shift DELETE", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"};
        UIDefaults.LazyInputMap fieldBindings = new UIDefaults.LazyInputMap(fieldArray);
        Object[] multiArray = new Object[]{"ctrl C", "copy-to-clipboard", "ctrl INSERT", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "shift INSERT", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "shift DELETE", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"};
        UIDefaults.LazyInputMap multilineBindings = new UIDefaults.LazyInputMap(multiArray);
        IconUIResource menuItemIcon = new IconUIResource(new SpacingIcon(14, 14));
        Object[] colorDefaults = this.getColorComponentDefaults(table);
        table.putDefaults(colorDefaults);
        Object[] defaults = new Object[]{"Panel.font", null, "Button.border", new StringInstantiator("oracle.bali.ewt.olaf.OracleButtonUI", "Button.border"), "Button.margin", new InsetsUIResource(0, 2, 0, 2), "Button.font", dialogPlain12, "ToggleButton.border", new StringInstantiator("oracle.bali.ewt.olaf.OracleButtonUI", "ToggleButton.border"), "ToggleButton.font", dialogPlain12, "RadioButton.icon", new StringInstantiator("oracle.bali.ewt.olaf.OracleRadioButtonUI", "RadioButton.icon"), "RadioButton.margin", zeroInsets, "CheckBox.icon", new StringInstantiator("oracle.bali.ewt.olaf.OracleCheckBoxUI", "CheckBox.icon"), "CheckBox.margin", zeroInsets, "MenuBar.border", null, "Menu.selectedWindowInputMapBindings", new Object[]{"ESCAPE", "cancel", "alt pressed ALT", "oracle.bali.ewt.olaf.MenuClearAction", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"}, "MenuItem.checkIcon", menuItemIcon, "Menu.checkIcon", menuItemIcon, "PopupMenu.border", null, "PopupMenu.selectedWindowInputMapBindings", new Object[]{"ESCAPE", "cancel", "alt pressed ALT", "oracle.bali.ewt.olaf.MenuClearAction", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"}, "Label.font", dialogPlain12, "List.focusCellHighlightBorder", new StringInstantiator("oracle.bali.ewt.plaf.GridFocusPainter"), "List.font", dialogPlain12, "List.border", null, "ComboBox.font", dialogPlain12, "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "ENTER", "enterPressed", "SPACE", "spacePopup"}), "InternalFrame.border", null, "DesktopIcon.border", null, "InternalFrame.maximizeIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleInternalFrameUI", "InternalFrame.maximizeIcon"), "InternalFrame.minimizeIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleInternalFrameUI", "InternalFrame.minimizeIcon"), "InternalFrame.iconifyIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleInternalFrameUI", "InternalFrame.iconifyIcon"), "InternalFrame.closeIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleInternalFrameUI", "InternalFrame.closeIcon"), "Window.closeStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#imageInst|closeStrip.gif"), "Window.maximizeStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#imageInst|maximizeStrip.gif"), "Window.iconifyStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#imageInst|minimizeStrip.gif"), "Window.minimizeStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#imageInst|restoreStrip.gif"), "TextField.caretBlinkRate", caretBlinkRate, "TextField.margin", pixelInsets, "TextField.font", sansSerifPlain12, "TextField.border", narrowMarginInset, "PasswordField.caretBlinkRate", caretBlinkRate, "PasswordField.margin", pixelInsets, "PasswordField.font", monospacedPlain12, "PasswordField.border", narrowMarginInset, "TextArea.caretBlinkRate", caretBlinkRate, "TextArea.margin", pixelInsets, "TextArea.font", sansSerifPlain12, "TextArea.border", wideMarginInset, "TextPane.font", sansSerifPlain12, "TextPane.border", wideMarginInset, "TextPane.margin", pixelInsets, "EditorPane.font", sansSerifPlain12, "EditorPane.border", wideMarginInset, "EditorPane.margin", pixelInsets, "TextField.focusInputMap", fieldBindings, "PasswordField.focusInputMap", fieldBindings, "TextArea.focusInputMap", multilineBindings, "TextPane.focusInputMap", multilineBindings, "EditorPane.focusInputMap", multilineBindings, "TextField.keyBindings", fieldBindings, "PasswordField.keyBindings", fieldBindings, "TextArea.keyBindings", multilineBindings, "TextPane.keyBindings", multilineBindings, "EditorPane.keyBindings", multilineBindings, "ScrollBar.border", null, "TitledBorder.font", dialogPlain12, "TitledBorder.border", new StringInstantiator("oracle.bali.ewt.olaf.OracleGroupBoxPainter", "TitledBorder.border"), "ToolBar.border", new StringInstantiator("oracle.bali.ewt.olaf.OracleToolBarUI", "ToolBar.border"), "ToolBar.separatorSize", new DimensionUIResource(12, 12), "ToolTip.font", sansSerifPlain12, "ToolTip.border", new StringInstantiator("oracle.bali.ewt.olaf.OracleToolTipUI", "ToolTip.border"), "ScrollPane.border", wideInset, "ScrollPane.viewportBorder", null, "SplitPane.dividerSize", IntegerUtils.getInteger((int)12), "InternalFrame.icon", null, "Tree.rowHeight", IntegerUtils.getInteger((int)0), "Tree.openIcon", null, "Tree.closedIcon", null, "Tree.leafIcon", null, "Tree.font", dialogPlain12, "ProgressBar.font", dialogPlain12, "ProgressBar.border", narrowInset, "ProgressBar.cellLength", IntegerUtils.getInteger((int)1), "ProgressBar.cellSpacing", IntegerUtils.getInteger((int)0), "OptionPane.questionIcon", javax.swing.LookAndFeel.makeIcon(this.getClass(), "icons/Question.gif"), "OptionPane.errorIcon", javax.swing.LookAndFeel.makeIcon(this.getClass(), "icons/Error.gif"), "OptionPane.informationIcon", javax.swing.LookAndFeel.makeIcon(this.getClass(), "icons/Inform.gif"), "OptionPane.warningIcon", javax.swing.LookAndFeel.makeIcon(this.getClass(), "icons/Warn.gif"), "Table.focusCellHighlightBorder", new StringInstantiator("oracle.bali.ewt.plaf.GridFocusPainter"), "Table.scrollPaneBorder", wideInset, "TableHeader.cellBorder", new StringInstantiator("oracle.bali.ewt.olaf.OracleHeaderItemPainter"), "EWTGrayPane.border", new StringInstantiator("oracle.bali.ewt.olaf.OracleGrayPaneBorder"), "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "FileView.directoryIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "5"), "FileView.fileIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "9"), "FileView.computerIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "7"), "FileView.hardDriveIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "10"), "FileView.floppyDriveIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "13"), "FileChooser.newFolderIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "2"), "FileChooser.upFolderIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "0"), "FileChooser.homeFolderIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "1"), "FileChooser.detailsViewIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "4"), "FileChooser.listViewIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleFileChooserUI", "3")};
        table.putDefaults(defaults);
        OracleLookAndFeel._initColorizedComponentDefaults(table);
    }

    protected Object[] getColorComponentDefaults(UIDefaults table) {
        Object normal = table.get(ColorScheme.NORMAL_INTENSITY);
        ColorUIResource white = new ColorUIResource(Color.white);
        Object darkLook = table.get(ColorScheme.DARK_LOOK);
        Object[] defaults = new Object[]{"Panel.background", table.get("lightLook"), "Button.background", table.get("control"), "Button.foreground", table.get("controlText"), "Button.lightBorder", white, "Button.darkBorder", table.get(LookAndFeel.CONTROL_DK_SHADOW), "ToggleButton.background", table.get("control"), "ToggleButton.foreground", table.get("controlText"), "ToggleButton.lightBorder", white, "ToggleButton.darkBorder", table.get(LookAndFeel.CONTROL_DK_SHADOW), "RadioButton.background", null, "CheckBox.background", null, "MenuBar.background", null, "Menu.foreground", table.get("controlText"), "Menu.background", null, "MenuItem.background", null, "Label.background", null, "Label.foreground", table.get("controlText"), "List.selectionBackground", table.get("textHighlight"), "List.selectionForeground", table.get("textHighlightText"), "List.background", table.get("text"), "List.foreground", table.get("textText"), "ComboBox.background", table.get("control"), "ComboBox.foreground", table.get("controlText"), "ComboBox.selectedBackground", table.get("textHighlight"), "ComboBox.selectedForeground", table.get("textHighlightText"), "ComboBox.disabledBackground", table.get("control"), "ComboBox.disabledForeground", table.get("textInactiveText"), "InternalFrame.background", table.get("control"), "DesktopIcon.background", table.get("control"), "InternalFrame.activeTitleBackground", table.get("activeCaption"), "InternalFrame.activeTitleForeground", table.get("activeCaptionText"), "InternalFrame.inactiveTitleBackground", table.get("inactiveCaption"), "InternalFrame.inactiveTitleForeground", table.get("inactiveCaptionText"), "FileChooser.background", darkLook, "TextField.caretForeground", table.get("textText"), "TextField.inactiveForeground", table.get("textInactiveText"), "TextField.selectionBackground", table.get("textHighlight"), "TextField.selectionForeground", table.get("textHighlightText"), "TextField.background", table.get("text"), "TextField.foreground", table.get("textText"), "PasswordField.caretForeground", table.get("textText"), "PasswordField.inactiveForeground", table.get("textInactiveText"), "PasswordField.selectionBackground", table.get("textHighlight"), "PasswordField.selectionForeground", table.get("textHighlightText"), "PasswordField.background", table.get("text"), "PasswordField.foreground", table.get("textText"), "TextArea.caretForeground", table.get("textText"), "TextArea.inactiveForeground", table.get("textInactiveText"), "TextArea.selectionBackground", table.get("textHighlight"), "TextArea.selectionForeground", table.get("textHighlightText"), "TextArea.background", table.get("text"), "TextArea.foreground", table.get("textText"), "TextPane.caretForeground", table.get("textText"), "TextPane.inactiveForeground", table.get("textInactiveText"), "TextPane.selectionBackground", table.get("textHighlight"), "TextPane.selectionForeground", table.get("textHighlightText"), "TextPane.background", table.get("text"), "TextPane.foreground", table.get("textText"), "EditorPane.caretForeground", table.get("textText"), "EditorPane.inactiveForeground", table.get("textInactiveText"), "EditorPane.selectionBackground", table.get("textHighlight"), "EditorPane.selectionForeground", table.get("textHighlightText"), "EditorPane.background", table.get("text"), "EditorPane.foreground", table.get("textText"), "ScrollBar.background", table.get("scrollbar"), "ScrollBar.foreground", table.get("controlDkShadow"), "ScrollBar.track", table.get("scrollbar"), "ScrollBar.trackHighlight", table.get("controlDkShadow"), "ScrollBar.thumb", table.get("control"), "ScrollBar.thumbHighlight", table.get("controlHighlight"), "ScrollBar.thumbDarkShadow", table.get("controlDkShadow"), "ScrollBar.thumbLightShadow", table.get("controlShadow"), "TitledBorder.titleColor", table.get("controlText"), "TitledBorder.lineColor", table.get("controlShadowDark"), "ToolBar.background", table.get("control"), "ToolBar.foreground", table.get("controlText"), "ToolBar.dockingColor", table.get("control"), "ToolBar.floatingColor", table.get("control"), "ToolBar.lightBorder", white, "ToolTip.background", table.get("info"), "ToolTip.foreground", table.get("infoText"), "ScrollPane.background", null, "SplitPane.background", null, "Slider.foreground", table.get("controlText"), "Slider.sliderColor", table.get(ColorScheme.LIGHT_INTENSITY), "Tree.background", table.get("text"), "Tree.hash", table.get("controlShadow"), "Tree.textSelectionColor", table.get("textHighlightText"), "Tree.textNonSelectionColor", table.get("textText"), "Tree.borderSelectionColor", table.get("textText"), "Tree.backgroundSelectionColor", table.get("textHighlight"), "Tree.backgroundNonSelectionColor", null, "ProgressBar.foreground", table.get("textHighlight"), "ProgressBar.background", table.get("text"), "ProgressBar.textSelectionColor", table.get("textHighlightText"), "ProgressBar.textNonSelectionColor", table.get("textText"), "TabbedPane.lightHighlight", white, "TabbedPane.shadow", normal, "TabbedPane.darkShadow", table.get("controlDkShadow"), "TabbedPane.notSelectedColor", normal, "TabbedPane.inactiveSelectedColor", table.get("control"), "TabbedPane.selectedColor", table.get("control"), "TabbedPane.lightBorder", white, "TabbedPane.normalColor", table.getColor("normalIntensity"), "TabbedPane.selectedTextColor", table.get("textText"), "TabbedPane.changeCornerColor", Boolean.TRUE, "TabbedPane.cornerPixel", white, "OptionPane.background", table.get("darkIntensity"), "Table.background", table.get("text"), "Table.gridColor", table.get("controlShadow"), "Table.focusCellBackground", table.get("text"), "Table.focusCellForeground", table.get("controlText"), "Table.selectionBackground", table.get("textHighlight"), "Table.inactiveSelectionBackground", table.get(ColorScheme.DARK_INTENSITY), "Table.focusCellHighlightBorder", new StringInstantiator("oracle.bali.ewt.plaf.GridFocusPainter"), "Separator.background", null, "Separator.foreground", table.get("controlShadowDark"), "PopupMenuSeparator.background", white, "PopupMenuSeparator.foreground", normal, "Window.lightBorder", white, "EWTGrayPane.background", table.get("lightLook"), "EWTGrayPane.foreground", null, "EWTGrayPane.lightBorder", white, "EWTDialog.background", table.get("darkLook")};
        return defaults;
    }

    private static void _initDarkComponentDefaults(UIDefaults table) {
        Object[] defaults = new Object[]{"Label.foreground", table.get("controlText"), "checkboxStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|dkCheckboxStrip.gif"), "checkboxSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleCheckBoxUI", "checkboxSet"), "radioButtonStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|dkRadioButtonStrip.gif"), "radioButtonSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleRadioButtonUI", "radioButtonSet")};
        table.putDefaults(defaults);
    }

    private static void _initLightComponentDefaults(UIDefaults table) {
        Object[] defaults = new Object[]{"checkboxStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|ltCheckboxStrip.gif"), "checkboxSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleCheckBoxUI", "checkboxSet"), "radioButtonStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|ltRadioButtonStrip.gif"), "radioButtonSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleRadioButtonUI", "radioButtonSet")};
        table.putDefaults(defaults);
    }

    private static void _initColorizedComponentDefaults(UIDefaults table) {
        Object[] defaults = new Object[]{"checkboxStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|checkboxStrip.gif"), "checkboxSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleCheckBoxUI", "checkboxSet"), "radioButtonStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|radioButtonStrip.gif"), "radioButtonSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleRadioButtonUI", "radioButtonSet"), "UpScrollPainter", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "UpScrollPainter"), "DownScrollPainter", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "DownScrollPainter"), "LeftScrollPainter", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "LeftScrollPainter"), "RightScrollPainter", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "RightScrollPainter"), "UpScrollSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "UpScrollSet"), "DownScrollSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "DownScrollSet"), "LeftScrollSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "LeftScrollSet"), "RightScrollSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleScrollBarUI", "RightScrollSet"), "UpScrollStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|upScrollStrip.gif"), "DownScrollStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|downScrollStrip.gif"), "LeftScrollStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|leftScrollStrip.gif"), "RightScrollStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|rightScrollStrip.gif"), "TabbedPane.scrollLeft", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cIconInst|tableft.gif"), "TabbedPane.scrollRight", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cIconInst|tabright.gif"), "TabbedPane.scrollBoth", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cIconInst|tabboth.gif"), "CheckBoxMenuItem.checkIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleCheckBoxMenuItemUI", "CheckBoxMenuItem.checkIcon"), "RadioButtonMenuItem.checkIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleRadioButtonMenuItemUI", "RadioButtonMenuItem.checkIcon"), "ComboBox.arrowSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleComboBoxUI", "ComboBox.arrowSet"), "Slider.horzThumbStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|sliderHorzThumbStrip.gif"), "Slider.horzThumbSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleSliderUI", "Slider.horzThumbSet"), "Slider.horzThumbPainter", new StringInstantiator("oracle.bali.ewt.olaf.OracleSliderUI", "Slider.horzThumbPainter"), "Slider.vertThumbStrip", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cImageInst|sliderVertThumbStrip.gif"), "Slider.vertThumbSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleSliderUI", "Slider.vertThumbSet"), "Slider.vertThumbPainter", new StringInstantiator("oracle.bali.ewt.olaf.OracleSliderUI", "Slider.vertThumbPainter"), "TabbedPane.visibleSet", new StringInstantiator("oracle.bali.ewt.olaf.OracleTabbedPaneUI", "TabbedPane.visibleSet"), "Tree.expandedImage", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cIconInst|TreeOpen.gif"), "Tree.collapsedImage", new StringInstantiator("oracle.bali.ewt.olaf.OracleUIUtils#cIconInst|TreeClosed.gif"), "Tree.expandedIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleTreeUI", "Tree.expandedIcon"), "Tree.collapsedIcon", new StringInstantiator("oracle.bali.ewt.olaf.OracleTreeUI", "Tree.collapsedIcon")};
        table.putDefaults(defaults);
    }

    static ColorScheme __getColorScheme(ColorScheme[] schemes, String schemeName) {
        for (int i = 0; i < schemes.length; ++i) {
            ColorScheme currScheme = schemes[i];
            if (!currScheme.getName().equals(schemeName)) continue;
            return currScheme;
        }
        return null;
    }

    static ColorScheme __getColorScheme(ColorScheme[] schemes, Color matchColor) {
        int matchRed = matchColor.getRed();
        int matchGreen = matchColor.getGreen();
        int matchBlue = matchColor.getBlue();
        ColorScheme minScheme = null;
        int currMin = Integer.MAX_VALUE;
        for (int i = 0; i < schemes.length; ++i) {
            int blueDiff;
            int greenDiff;
            ColorScheme currScheme = schemes[i];
            if (currScheme._isDerived()) continue;
            Color currColor = currScheme.getDefiningColor();
            int redDiff = matchRed - currColor.getRed();
            int currDiff = redDiff * redDiff + (greenDiff = matchGreen - currColor.getGreen()) * greenDiff + (blueDiff = matchBlue - currColor.getBlue()) * blueDiff;
            if (currDiff == 0) {
                return currScheme;
            }
            if (currDiff >= currMin) continue;
            currMin = currDiff;
            minScheme = currScheme;
        }
        return minScheme;
    }

    private static ColorScheme[] _getAvailableSchemes() {
        if (_sAvailableSchemes == null) {
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            int[] nArray4;
            int[] nArray5;
            int[] nArray6;
            ColorScheme[] colorSchemeArray = new ColorScheme[8];
            if (_USE_HIGH_COLOR) {
                int[] nArray7 = new int[9];
                nArray7[0] = -1;
                nArray7[1] = -858993460;
                nArray7[2] = -1718246217;
                nArray7[3] = 1717532051;
                nArray7[4] = 858339404;
                nArray7[5] = 0;
                nArray7[6] = 255;
                nArray7[7] = 14674679;
                nArray6 = nArray7;
                nArray7[8] = 11849708;
            } else {
                int[] nArray8 = new int[9];
                nArray8[0] = -1;
                nArray8[1] = -858993460;
                nArray8[2] = -1721329204;
                nArray8[3] = 0x66336699;
                nArray8[4] = 0x33000033;
                nArray8[5] = 0;
                nArray8[6] = 255;
                nArray8[7] = 0x99CCFF;
                nArray6 = nArray8;
                nArray8[8] = 0x6699FF;
            }
            colorSchemeArray[0] = new ColorScheme("Blue", "Oracle Blue Color Scheme", nArray6, 0);
            if (_USE_HIGH_COLOR) {
                int[] nArray9 = new int[9];
                nArray9[0] = -1;
                nArray9[1] = -858993460;
                nArray9[2] = -1716210791;
                nArray9[3] = 1720552570;
                nArray9[4] = 860634894;
                nArray9[5] = 0;
                nArray9[6] = 255;
                nArray9[7] = 16316383;
                nArray5 = nArray9;
                nArray9[8] = 0xEEEBB2;
            } else {
                int[] nArray10 = new int[9];
                nArray10[0] = -1;
                nArray10[1] = -858993460;
                nArray10[2] = -1714631527;
                nArray10[3] = 0x66999966;
                nArray10[4] = 0x33666600;
                nArray10[5] = 0;
                nArray10[6] = 255;
                nArray10[7] = 0xCCCC99;
                nArray5 = nArray10;
                nArray10[8] = 0xCCCC00;
            }
            colorSchemeArray[1] = new ColorScheme("Khaki", "Oracle Khaki Color Scheme", nArray5, 1);
            if (_USE_HIGH_COLOR) {
                int[] nArray11 = new int[9];
                nArray11[0] = -1;
                nArray11[1] = -858993460;
                nArray11[2] = -1717130082;
                nArray11[3] = 1718317666;
                nArray11[4] = 859981372;
                nArray11[5] = 0;
                nArray11[6] = 255;
                nArray11[7] = 15661279;
                nArray4 = nArray11;
                nArray11[8] = 14020274;
            } else {
                int[] nArray12 = new int[9];
                nArray12[0] = -1;
                nArray12[1] = -858993460;
                nArray12[2] = -1717986970;
                nArray12[3] = 0x66666633;
                nArray12[4] = 0x33003300;
                nArray12[5] = 0;
                nArray12[6] = 255;
                nArray12[7] = 0xCCCC99;
                nArray4 = nArray12;
                nArray12[8] = 0x999900;
            }
            colorSchemeArray[2] = new ColorScheme("Olive", "Oracle Green Color Scheme", nArray4, 2);
            if (_USE_HIGH_COLOR) {
                int[] nArray13 = new int[9];
                nArray13[0] = -1;
                nArray13[1] = -858993460;
                nArray13[2] = -1716145981;
                nArray13[3] = 1719169422;
                nArray13[4] = 859057482;
                nArray13[5] = 0;
                nArray13[6] = 255;
                nArray13[7] = 15065080;
                nArray3 = nArray13;
                nArray13[8] = 12628718;
            } else {
                int[] nArray14 = new int[9];
                nArray14[0] = -1;
                nArray14[1] = -858993460;
                nArray14[2] = -1717986868;
                nArray14[3] = 0x66666699;
                nArray14[4] = 0x33330033;
                nArray14[5] = 0;
                nArray14[6] = 255;
                nArray14[7] = 0xCCCCFF;
                nArray3 = nArray14;
                nArray14[8] = 0x9999FF;
            }
            colorSchemeArray[3] = new ColorScheme("Purple", "Oracle Purple Color Scheme", nArray3, 3);
            if (_USE_HIGH_COLOR) {
                int[] nArray15 = new int[9];
                nArray15[0] = -1;
                nArray15[1] = -858993460;
                nArray15[2] = -1714770265;
                nArray15[3] = 1721598072;
                nArray15[4] = 860629799;
                nArray15[5] = 0;
                nArray15[6] = 255;
                nArray15[7] = 16311775;
                nArray2 = nArray15;
                nArray15[8] = 15646898;
            } else {
                int[] nArray16 = new int[9];
                nArray16[0] = -1;
                nArray16[1] = -858993460;
                nArray16[2] = -1714644583;
                nArray16[3] = 0x66996666;
                nArray16[4] = 0x33660000;
                nArray16[5] = 0;
                nArray16[6] = 255;
                nArray16[7] = 0xFFCCCC;
                nArray2 = nArray16;
                nArray16[8] = 0xFF9999;
            }
            colorSchemeArray[4] = new ColorScheme("Red", "Oracle Red Color Scheme", nArray2, 4);
            if (_USE_HIGH_COLOR) {
                int[] nArray17 = new int[9];
                nArray17[0] = -1;
                nArray17[1] = -858993460;
                nArray17[2] = -1720141126;
                nArray17[3] = 1718783887;
                nArray17[4] = 859196492;
                nArray17[5] = 0;
                nArray17[6] = 255;
                nArray17[7] = 14678255;
                nArray = nArray17;
                nArray17[8] = 11726551;
            } else {
                int[] nArray18 = new int[9];
                nArray18[0] = -1;
                nArray18[1] = -858993460;
                nArray18[2] = -1721329255;
                nArray18[3] = 0x66336666;
                nArray18[4] = 0x33003333;
                nArray18[5] = 0;
                nArray18[6] = 255;
                nArray18[7] = 0x99FFFF;
                nArray = nArray18;
                nArray18[8] = 52428;
            }
            colorSchemeArray[5] = new ColorScheme("Teal", "Oracle Teal Color Scheme", nArray, 5);
            colorSchemeArray[6] = _sDefaultScheme;
            colorSchemeArray[7] = new ColorScheme("System", "System Hue and Saturation", SystemColor.control, SystemColor.textHighlight, false, 7);
            _sAvailableSchemes = colorSchemeArray;
        }
        return _sAvailableSchemes;
    }

    static {
        int[] nArray;
        boolean bl = _USE_HIGH_COLOR = !(Toolkit.getDefaultToolkit().getColorModel() instanceof IndexColorModel);
        if (_USE_HIGH_COLOR) {
            int[] nArray2 = new int[9];
            nArray2[0] = -1;
            nArray2[1] = -858993460;
            nArray2[2] = -1717986919;
            nArray2[3] = 0x66666666;
            nArray2[4] = 0x33333333;
            nArray2[5] = 0;
            nArray2[6] = 255;
            nArray2[7] = 14678255;
            nArray = nArray2;
            nArray2[8] = 11726551;
        } else {
            int[] nArray3 = new int[9];
            nArray3[0] = -1;
            nArray3[1] = -858993460;
            nArray3[2] = -1717986919;
            nArray3[3] = 0x66666666;
            nArray3[4] = 0x33333333;
            nArray3[5] = 0;
            nArray3[6] = 255;
            nArray3[7] = 0x99FFFF;
            nArray = nArray3;
            nArray3[8] = 52428;
        }
        _sCurrentScheme = _sDefaultScheme = new ColorScheme("Titanium", "Oracle Titanium Color Scheme", nArray, 6);
    }
}

