/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import oracle.bali.ewt.olaf.AlignedPainterJoiner;
import oracle.bali.ewt.olaf.IconTextGapPainter;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.PainterUI;
import oracle.bali.ewt.olaf.ViewPainter;
import oracle.bali.ewt.painter.AlignmentPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.share.util.IntegerUtils;

public class OracleLabelUI
extends BasicLabelUI
implements PainterUI {
    private static Painter _sPainter;
    private static final OracleLabelUI _sInstance;

    public static ComponentUI createUI(JComponent component) {
        return _sInstance;
    }

    public PaintContext getPaintContext(JComponent component) {
        return new PaintCtxt((JLabel)component);
    }

    public Painter getPainter(JComponent component) {
        if (((JLabel)component).getIcon() == null) {
            return OracleUIUtils.getLabelTextPainter();
        }
        if (_sPainter == null) {
            _sPainter = new AlignmentPainter(new AlignedPainterJoiner(OracleUIUtils.getIconPainter(), new IconTextGapPainter(OracleUIUtils.getLabelTextPainter())), true);
        }
        return _sPainter;
    }

    public void installUI(JComponent component) {
        super.installUI(component);
        OracleUIUtils.putPaintContext(component, this.getPaintContext(component));
    }

    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        OracleUIUtils.removePaintContext(component);
    }

    public Dimension getPreferredSize(JComponent component) {
        FontMetrics metrics;
        Font font;
        Dimension d = OracleUIUtils.getPreferredSize(this, component);
        PaintContext context = OracleUIUtils.getPaintContext(component);
        if (context.getPaintData(PaintContext.ICON_KEY) == null && (font = component.getFont()) != null && (metrics = component.getFontMetrics(font)) != null) {
            d.height = Math.max(d.height, metrics.getAscent() + metrics.getDescent());
        }
        return d;
    }

    public Dimension getMinimumSize(JComponent component) {
        return OracleUIUtils.getMinimumSize(this, component);
    }

    public Dimension getMaximumSize(JComponent component) {
        return OracleUIUtils.getMaximumSize(this, component);
    }

    public void paint(Graphics g, JComponent component) {
        OracleUIUtils.paint(this, g, component);
    }

    public boolean contains(JComponent component, int x, int y) {
        return OracleUIUtils.contains(this, component, x, y);
    }

    static {
        _sInstance = new OracleLabelUI();
    }

    static class PaintCtxt
    extends JPaintContext
    implements SwingConstants {
        private JLabel _label;
        private boolean _hasFocus;

        public PaintCtxt(JLabel label) {
            super(label);
            this._label = label;
        }

        public void setHasFocus(boolean hasFocus) {
            this._hasFocus = hasFocus;
        }

        public int getPaintState() {
            int state = super.getPaintState();
            state = this._hasFocus ? (state |= 0x40) : (state &= 0xFFFFFFBF);
            return state;
        }

        public Object getPaintData(Object key) {
            JLabel label = this._label;
            if (LABEL_KEY.equals(key)) {
                return label.getText();
            }
            if (ICON_KEY.equals(key)) {
                Icon icon = null;
                if (!label.isEnabled()) {
                    icon = label.getDisabledIcon();
                }
                if (icon == null) {
                    icon = label.getIcon();
                }
                return icon;
            }
            if (ViewPainter.VIEW_KEY.equals(key)) {
                return ViewPainter.getHTMLView(label);
            }
            if (AlignedPainterJoiner.HORIZONTAL_TEXT_POSITION.equals(key)) {
                return IntegerUtils.getInteger((int)label.getHorizontalTextPosition());
            }
            if (AlignedPainterJoiner.VERTICAL_TEXT_POSITION.equals(key)) {
                return IntegerUtils.getInteger((int)label.getVerticalTextPosition());
            }
            if (MNEMONIC_INDEX_KEY.equals(key)) {
                return JPaintContext.getMnemonicIndex(label.getText(), label.getDisplayedMnemonic());
            }
            return null;
        }

        public float getInteriorAlignmentX() {
            int hAlign = OracleUIUtils.getActualHorizontalAlignment(this, this._label.getHorizontalAlignment());
            return (float)(hAlign == 2 ? 0.0 : (hAlign == 4 ? 1.0 : 0.5));
        }

        public float getInteriorAlignmentY() {
            int vAlign = this._label.getVerticalAlignment();
            return (float)(vAlign == 1 ? 0.0 : (vAlign == 3 ? 1.0 : 0.5));
        }
    }
}

