/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.plaf.basic.BasicButtonUI;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.FocusUtils;
import oracle.bali.ewt.util.ImmInsets;

class IconTextGapPainter
extends AbstractBorderPainter {
    private static Method _sIconGapMethod;

    public IconTextGapPainter(Painter wrappedPainter) {
        super(wrappedPainter, false);
    }

    protected ImmInsets getOwnFillInsets(PaintContext context) {
        return ImmInsets.getEmptyInsets();
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;
        int gap = 0;
        int horTextPosition = 0;
        int verTextPosition = 0;
        JComponent component = context.getComponent();
        if (component instanceof JLabel) {
            JLabel label = (JLabel)component;
            gap = label.getIconTextGap();
            horTextPosition = label.getHorizontalTextPosition();
            verTextPosition = label.getVerticalTextPosition();
        } else if (component instanceof JButton || component instanceof JToggleButton) {
            AbstractButton button = (AbstractButton)component;
            gap = IconTextGapPainter._getIconTextGap(button);
            horTextPosition = button.getHorizontalTextPosition();
            verTextPosition = button.getVerticalTextPosition();
        }
        if (gap == 0) {
            return ImmInsets.getEmptyInsets();
        }
        switch (verTextPosition) {
            case 1: {
                bottom = gap;
                break;
            }
            case 3: {
                top = gap;
            }
        }
        switch (OracleUIUtils.getActualHorizontalAlignment(context, horTextPosition)) {
            case 2: {
                right = gap;
                break;
            }
            case 4: {
                left = gap;
            }
        }
        return new ImmInsets(top, left, bottom, right);
    }

    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    private static final int _getIconTextGap(AbstractButton b) {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            if (_sIconGapMethod == null) {
                try {
                    _sIconGapMethod = AbstractButton.class.getMethod("getIconTextGap", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (_sIconGapMethod != null) {
                try {
                    Integer i = (Integer)_sIconGapMethod.invoke((Object)b, (Object[])null);
                    return i;
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
        }
        BasicButtonUI ui = (BasicButtonUI)b.getUI();
        return ui.getDefaultTextIconGap(b);
    }
}

