/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.model;

import java.util.Enumeration;
import java.util.EventListener;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.bali.ewt.model.EmptyOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelEvent;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.share.event.ListenerManager;

public class OneDListModel
implements ListModel {
    private OneDModel _toAdapt;
    private ListenerManager _listeners;

    public OneDListModel(OneDModel model) {
        if (model == null) {
            model = EmptyOneDModel.getOneDModel();
        }
        this._toAdapt = model;
        this._toAdapt.addModelListener(new ModelListener());
    }

    public OneDModel getModel() {
        return this._toAdapt;
    }

    public int getSize() {
        return this.getModel().getItemCount();
    }

    public Object getElementAt(int index) {
        return this.getModel().getData(index);
    }

    public void addListDataListener(ListDataListener l) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)l);
    }

    public void removeListDataListener(ListDataListener l) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)l);
        }
    }

    private void _fireEvent(ListDataEvent e) {
        if (this._listeners == null) {
            return;
        }
        Enumeration enumer = this._listeners.getListeners();
        if (enumer == null) {
            return;
        }
        switch (e.getType()) {
            case 1: {
                while (enumer.hasMoreElements()) {
                    ((ListDataListener)enumer.nextElement()).intervalAdded(e);
                }
                break;
            }
            case 2: {
                while (enumer.hasMoreElements()) {
                    ((ListDataListener)enumer.nextElement()).intervalRemoved(e);
                }
                break;
            }
            case 0: {
                while (enumer.hasMoreElements()) {
                    ((ListDataListener)enumer.nextElement()).contentsChanged(e);
                }
                break;
            }
        }
    }

    private class ModelListener
    implements OneDModelListener {
        private ModelListener() {
        }

        public void itemsAdded(OneDModelEvent e) {
            ListDataEvent lde = new ListDataEvent(this, 1, e.getStartIndex(), e.getStartIndex() + e.getItemCount() - 1);
            OneDListModel.this._fireEvent(lde);
        }

        public void itemsRemoved(OneDModelEvent e) {
            ListDataEvent lde = new ListDataEvent(this, 2, e.getStartIndex(), e.getStartIndex() + e.getItemCount() - 1);
            OneDListModel.this._fireEvent(lde);
        }

        public void invalidateItems(OneDModelEvent e) {
            ListDataEvent lde = new ListDataEvent(this, 0, e.getStartIndex(), e.getStartIndex() + e.getItemCount() - 1);
            OneDListModel.this._fireEvent(lde);
        }
    }
}

