/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.header;

import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.selection.OneDSelection;

public class StandardHeaderKeyHandler
implements HeaderKeyHandler {
    private static HeaderKeyHandler _sManager;

    public static HeaderKeyHandler getHeaderKeyHandler() {
        if (_sManager == null) {
            _sManager = new StandardHeaderKeyHandler();
        }
        return _sManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleKeyEvent(Header header, KeyEvent keyEvent) {
        if (keyEvent.isConsumed() || keyEvent.isAltDown()) {
            return;
        }
        OneDSelection selection = header.getSelection();
        int focusItem = header.getFocusItem();
        int newFocusItem = -1;
        int anchorItem = header.getAnchorItem();
        boolean toggleCell = false;
        boolean space = false;
        boolean control = keyEvent.isControlDown();
        boolean shift = keyEvent.isShiftDown();
        int id = keyEvent.getID();
        if (keyEvent.getKeyCode() == 32) {
            if (id == 401) {
                header.setArmedItem(focusItem);
                newFocusItem = focusItem;
                space = true;
                if (keyEvent.isControlDown()) {
                    toggleCell = true;
                }
            } else if (id == 402) {
                header.setArmedItem(-1);
            }
        } else if (id == 401) {
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    newFocusItem = this.down(header, focusItem, keyEvent);
                    break;
                }
                case 38: {
                    newFocusItem = this.up(header, focusItem, keyEvent);
                    break;
                }
                case 37: {
                    newFocusItem = this.left(header, focusItem, keyEvent);
                    break;
                }
                case 39: {
                    newFocusItem = this.right(header, focusItem, keyEvent);
                    break;
                }
                case 35: {
                    newFocusItem = this.end(header, focusItem, keyEvent);
                    break;
                }
                case 36: {
                    newFocusItem = this.home(header, focusItem, keyEvent);
                }
            }
        }
        if (newFocusItem == -1 || newFocusItem == focusItem && !space) {
            return;
        }
        keyEvent.consume();
        header.freezeRepaints();
        try {
            if (space) {
                if (selection.contains(newFocusItem)) {
                    if (toggleCell) {
                        selection = selection.subtract(newFocusItem);
                    }
                } else {
                    selection = selection.add(newFocusItem);
                }
                header.setAnchorItem(newFocusItem);
            } else if (shift && anchorItem != -1) {
                selection = control ? selection.add(newFocusItem) : new OneDSelection(anchorItem, newFocusItem);
            } else if (!control) {
                selection = new OneDSelection(newFocusItem, newFocusItem);
                header.setAnchorItem(newFocusItem);
            }
            try {
                header.setSelection(selection);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            header.setFocusItem(newFocusItem);
        }
        finally {
            header.unfreezeRepaints();
        }
        header.scrollItemIntoView(newFocusItem);
    }

    protected int left(Header header, int focusItem, KeyEvent e) {
        if (header.getOrientation() == 1) {
            return focusItem;
        }
        e.consume();
        int newFocusItem = focusItem == -1 ? header.getNextVisibleItem(-1) : header.getPreviousVisibleItem(focusItem);
        if (newFocusItem == -1) {
            return focusItem;
        }
        return newFocusItem;
    }

    protected int right(Header header, int focusItem, KeyEvent e) {
        if (header.getOrientation() == 1) {
            return focusItem;
        }
        e.consume();
        int newFocusItem = focusItem == -1 ? header.getNextVisibleItem(-1) : header.getNextVisibleItem(focusItem);
        if (newFocusItem == -1) {
            return focusItem;
        }
        return newFocusItem;
    }

    protected int up(Header header, int focusItem, KeyEvent e) {
        if (header.getOrientation() == 0) {
            return focusItem;
        }
        e.consume();
        int newFocusItem = focusItem == -1 ? header.getNextVisibleItem(-1) : header.getPreviousVisibleItem(focusItem);
        if (newFocusItem == -1) {
            return focusItem;
        }
        return newFocusItem;
    }

    protected int down(Header header, int focusItem, KeyEvent e) {
        if (header.getOrientation() == 0) {
            return focusItem;
        }
        e.consume();
        int newFocusItem = focusItem == -1 ? header.getNextVisibleItem(-1) : header.getNextVisibleItem(focusItem);
        if (newFocusItem == -1) {
            return focusItem;
        }
        return newFocusItem;
    }

    protected int home(Header header, int focusItem, KeyEvent e) {
        e.consume();
        return header.getNextVisibleItem(-1);
    }

    protected int end(Header header, int focusItem, KeyEvent e) {
        e.consume();
        int count = header.getItemCount();
        return header.getPreviousVisibleItem(count);
    }

    protected StandardHeaderKeyHandler() {
    }
}

