/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.spinBox.ArraySpinBoxModel;
import oracle.bali.ewt.spinBox.NumericSpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBox;
import oracle.bali.ewt.spinBox.SpinBoxModel;
import oracle.bali.ewt.spinBox.SpinBuddy;

public class SpinBoxInputHandler
extends CellInputHandler {
    private boolean _ignoreStateChange = false;
    private static final String _ASSERT_STRING = "SpinBoxInputHandler.setModelValue() does not recognize the SpinBoxModel.  Clients must override this method to initialize their SpinBoxModel class.";
    private KeyListener _keyListener;
    private SpinBox _spinBox;
    boolean _dirty;

    public SpinBoxInputHandler() {
        this(null);
    }

    public SpinBoxInputHandler(SpinBox spinBox) {
        if (spinBox != null) {
            this._spinBox = spinBox;
            this._initSpinBox(spinBox);
        }
    }

    public void updateUI() {
        if (this._spinBox != null) {
            SwingUtilities.updateComponentTreeUI(this._spinBox);
        }
    }

    public void setModel(SpinBoxModel model) {
        SpinBox box = this.getSpinBox(null, -1, -1);
        box.setModel(model);
    }

    public SpinBoxModel getModel() {
        SpinBox box = this.getSpinBox(null, -1, -1);
        return box.getModel();
    }

    public void setSpinBuddy(SpinBuddy buddy) {
        SpinBox box = this.getSpinBox(null, -1, -1);
        box.setSpinBuddy(buddy);
    }

    public SpinBuddy getSpinBuddy() {
        SpinBox box = this.getSpinBox(null, -1, -1);
        return box.getSpinBuddy();
    }

    public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
        super.mousePressed(e, grid, column, row);
        Cell focusCell = grid.getFocusCell();
        if (focusCell != null && focusCell.column == column && focusCell.row == row && SwingUtilities.isLeftMouseButton(e)) {
            grid.startCellEdit(column, row);
        }
    }

    public void focusGained(AWTEvent why, Grid grid, int column, int row) {
        if (why instanceof MouseEvent) {
            grid.startCellEdit(column, row);
        }
    }

    public boolean isDirty(Grid grid, int column, int row) {
        return this._dirty;
    }

    public SpinBox getSpinBox(Grid grid, int column, int row) {
        return (SpinBox)this.getEditControl(grid, column, row);
    }

    public synchronized Component getEditControl(Grid grid, int column, int row) {
        if (this._spinBox == null) {
            this._spinBox = this.createSpinBox();
            this._initSpinBox(this._spinBox);
        }
        return this._spinBox;
    }

    public void startEdit(Grid grid, int column, int row, Object data) {
        SpinBox box = this.getSpinBox(grid, column, row);
        this._ignoreStateChange = true;
        SpinBoxModel i = box.getModel();
        this.setModelValue(i, data);
        box.setModel(i);
        this._ignoreStateChange = false;
    }

    public synchronized Object commitEdit(Grid grid, int column, int row) {
        SpinBox box = this.getSpinBox(grid, column, row);
        return box.getValue();
    }

    public Component[] getFocusableComponents(Grid grid, int focusColumn, int focusRow) {
        Component[] supe = super.getFocusableComponents(grid, focusColumn, focusRow);
        Component[] result = new Component[supe.length + 1];
        SpinBox box = this.getSpinBox(grid, focusColumn, focusRow);
        for (int i = 0; i < supe.length; ++i) {
            result[i] = supe[i];
        }
        result[supe.length] = (Component)((Object)box.getSpinBuddy());
        return result;
    }

    protected SpinBox createSpinBox() {
        return new SpinBox();
    }

    protected void setModelValue(SpinBoxModel model, Object value) {
        if (model instanceof ArraySpinBoxModel) {
            ArraySpinBoxModel a = (ArraySpinBoxModel)model;
            Object[] array = a.getArray();
            boolean found = false;
            for (int i = 0; i < array.length; ++i) {
                if (value != array[i] && (value == null || array[i] == null || !value.equals(array[i]))) continue;
                a.setIndex(i);
                found = true;
                break;
            }
            if (!found) {
                a.setIndex(0);
                this._dirty = true;
            }
        } else if (model instanceof NumericSpinBoxModel) {
            NumericSpinBoxModel nsbm = (NumericSpinBoxModel)model;
            if (value != null && value instanceof Number) {
                int n = ((Number)value).intValue();
                nsbm.setValue(n);
            } else {
                nsbm.setValue(0);
                this._dirty = true;
            }
        }
    }

    private void _initSpinBox(SpinBox spinBox) {
        if (spinBox.getBorder() instanceof UIResource) {
            spinBox.setBorder(new EmptyBorder(0, 2, 0, 0));
        }
        spinBox.addChangeListener(new Dirty());
    }

    private class Dirty
    implements ChangeListener {
        private Dirty() {
        }

        public void stateChanged(ChangeEvent e) {
            if (!SpinBoxInputHandler.this._ignoreStateChange) {
                SpinBoxInputHandler.this._dirty = true;
            }
        }
    }
}

