/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.oracle;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.dateEditor.DateEditor;
import oracle.bali.ewt.elaf.EWTDateEditorUI;
import oracle.bali.ewt.elaf.basic.DateEditorPainter;
import oracle.bali.ewt.elaf.basic.DateEditorUtils;
import oracle.bali.ewt.elaf.oracle.OracleEWTSpinnerUI;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.plaf.DisablingPainter;
import oracle.bali.ewt.util.ImmInsets;

public class OracleEWTDateEditorUI
extends OracleEWTSpinnerUI
implements EWTDateEditorUI {
    private static final int _GAP = 1;
    private static Painter _sTextPainter;
    private static Painter _sSelectionPainter;
    private static OracleEWTDateEditorUI _sInstance;
    private static Painter _sBasicTextPainter;
    private static final BackGroundChangeListener _BACKGROUND_CHANGE_LISTENER;

    private OracleEWTDateEditorUI() {
    }

    public void installUI(JComponent component) {
        super.installUI(component);
        component.addPropertyChangeListener(_BACKGROUND_CHANGE_LISTENER);
    }

    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        component.removePropertyChangeListener(_BACKGROUND_CHANGE_LISTENER);
    }

    public static ComponentUI createUI(JComponent component) {
        if (_sInstance == null) {
            _sInstance = new OracleEWTDateEditorUI();
        }
        return _sInstance;
    }

    public Painter getTextPainter(JComponent component) {
        if (_sTextPainter == null) {
            _sTextPainter = new DisablingPainter(_sBasicTextPainter, true);
        }
        return _sTextPainter;
    }

    public Painter getSelectionTextPainter(JComponent component) {
        if (_sSelectionPainter == null) {
            _sSelectionPainter = new DateEditorPainter(_sBasicTextPainter);
        }
        return _sSelectionPainter;
    }

    public Dimension getPreferredSize(JComponent component) {
        DateEditor editor = (DateEditor)component;
        Component c = OracleEWTDateEditorUI.getSpinButton(editor);
        Dimension spinPref = c.getPreferredSize();
        Dimension painterSize = DateEditorUtils.getPreferredSize(editor, this);
        ImmInsets i = editor.getBorderInsets();
        ImmInsets spinInsets = this.getSpinButtonInsets(component);
        int verticalInsets = i.top + i.bottom;
        return new Dimension(spinPref.width + painterSize.width + 1 + i.left + i.right + spinInsets.left + spinInsets.right, Math.max(painterSize.height + verticalInsets, spinPref.height + verticalInsets + spinInsets.top + spinInsets.bottom));
    }

    public Dimension getMinimumSize(JComponent component) {
        DateEditor editor = (DateEditor)component;
        Painter painter = this.getTextPainter(editor);
        Dimension painterSize = painter.getMinimumSize(editor.getPaintContext());
        Component c = OracleEWTDateEditorUI.getSpinButton(editor);
        Dimension spinSize = c.getMinimumSize();
        if (painterSize.height < spinSize.height) {
            painterSize.height = spinSize.height;
        }
        painterSize.width += spinSize.width;
        return painterSize;
    }

    public Dimension getMaximumSize(JComponent component) {
        Dimension d = this.getPreferredSize(component);
        return d;
    }

    public void update(Graphics g, JComponent c) {
        DateEditor de = (DateEditor)c;
        OracleUIUtils.fillBackground(g, de);
        ImmInsets insets = OracleUIUtils.getInsets(de);
        g.translate(insets.left, insets.top);
        de.paintInterior(g);
        g.translate(-insets.left, -insets.top);
    }

    static {
        _sBasicTextPainter = new FixedBorderPainter(new TextPainter(), 0, 2, 0, 2);
        _BACKGROUND_CHANGE_LISTENER = new BackGroundChangeListener();
    }

    private static class BackGroundChangeListener
    implements PropertyChangeListener {
        private BackGroundChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent pe) {
            if ("enabled".equals(pe.getPropertyName())) {
                JComponent c = (JComponent)pe.getSource();
                boolean enabled = Boolean.TRUE.equals(pe.getNewValue());
                if (c.getBackground() instanceof UIResource) {
                    UIDefaults defaults = OracleUIUtils.getUIDefaults(c);
                    c.setBackground(defaults.getColor(enabled ? "EWTSpinner.background" : "control"));
                }
            }
        }
    }
}

