/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.EWTGridUI;
import oracle.bali.ewt.elaf.basic.GridImageSetPainter;
import oracle.bali.ewt.elaf.basic.GridSeparator;
import oracle.bali.ewt.elaf.basic.UIResourceAppearance;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TruncatingTextPainter;
import oracle.bali.ewt.pivot.PivotGrid;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotScrollPaneView;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.ewt.plaf.GridFocusPainter;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;

public abstract class BasicEWTGridUI
extends EWTGridUI {
    private static Painter _sDefaultPainter;
    private static final ImmInsets _sDefaultInsets;

    protected BasicEWTGridUI() {
    }

    public void installUI(JComponent component) {
        Container pane;
        javax.swing.LookAndFeel.installColors(component, "EWTGrid.background", "EWTGrid.foreground");
        Container parent = component.getParent();
        if (!(parent != null && (parent instanceof SpreadTable || parent instanceof JViewport || parent instanceof PivotGrid || parent instanceof PivotTable || parent instanceof PivotHeader || parent instanceof PivotScrollPaneView))) {
            javax.swing.LookAndFeel.installBorder(component, "EWTGrid.border");
        } else if (parent instanceof JViewport && (pane = parent.getParent()) instanceof JScrollPane) {
            javax.swing.LookAndFeel.installBorder((JScrollPane)pane, "EWTGrid.scrollPaneBorder");
        }
        Grid grid = (Grid)component;
        grid.setAlignmentX(0.0f);
        grid.setAlignmentY(0.5f);
        grid.setOpaque(true);
        if (grid.getVerticalSeparatorPainter() == NullPainter.getPainter() || grid.getVerticalSeparatorPainter() instanceof UIResource) {
            grid.setVerticalSeparatorPainter(GridSeparator.getVerticalSeparator());
        }
        if (grid.getHorizontalSeparatorPainter() == NullPainter.getPainter() || grid.getHorizontalSeparatorPainter() instanceof UIResource) {
            grid.setHorizontalSeparatorPainter(GridSeparator.getHorizontalSeparator());
        }
    }

    public void uninstallUI(JComponent component) {
        Container pane;
        Grid g = (Grid)component;
        javax.swing.LookAndFeel.uninstallBorder(component);
        Container parent = component.getParent();
        if (parent != null && parent instanceof JViewport && (pane = parent.getParent()) instanceof JScrollPane) {
            javax.swing.LookAndFeel.uninstallBorder((JScrollPane)pane);
        }
        if (g.getDefaultPainter() instanceof UIResource) {
            g.setDefaultPainter(null);
        }
    }

    public int getDefaultRowHeight(JComponent component) {
        Font font = component.getFont();
        int size = 0;
        if (font != null) {
            FontMetrics metrics = component.getFontMetrics(font);
            size = metrics.getHeight() + 3 + 3;
        }
        return size;
    }

    public int getDefaultColumnWidth(JComponent component) {
        Font font = component.getFont();
        int size = 0;
        if (font != null) {
            FontMetrics metrics = component.getFontMetrics(font);
            size = metrics.stringWidth("12345678");
        }
        return size;
    }

    public BorderPainter getOverlayBorderPainter(JComponent component) {
        return null;
    }

    public static Object instantiate(UIDefaults defaults, Object key, String discriminant) {
        if ("Grid.DefaultCellPainter".equals(key)) {
            return BasicEWTGridUI._getDefaultPainter();
        }
        if ("Grid.DefaultAppearance".equals(key)) {
            return BasicEWTGridUI._getDefaultAppearance();
        }
        if ("Grid.focusPainter".equals(key)) {
            return GridFocusPainter.getBorderPainter();
        }
        if ("Grid.checkPainter".equals(key)) {
            return new GridImageSetPainter("checkboxSet");
        }
        if ("Grid.radioPainter".equals(key)) {
            return new GridImageSetPainter("radioButtonSet");
        }
        return null;
    }

    private static Painter _getDefaultPainter() {
        if (_sDefaultPainter == null) {
            _sDefaultPainter = new TruncatingTextPainter(PaintContext.LABEL_KEY, false);
        }
        return _sDefaultPainter;
    }

    private static Appearance _getDefaultAppearance() {
        UIDefaults defaults = UIManager.getDefaults();
        UIResourceAppearance appear = new UIResourceAppearance();
        appear.setSelectForeground(defaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
        appear.setSelectBackground(defaults.getColor(LookAndFeel.TEXT_HIGHLIGHT));
        appear.setInsets(_sDefaultInsets);
        appear.setVerticalJustify(0);
        appear.setHorizontalJustify(0);
        return appear;
    }

    static {
        _sDefaultInsets = new ImmInsets(3, 3, 3, 1);
    }
}

