/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public abstract class EWTLookAndFeel {
    private static final String _KEY_INSTALLED = "oracle.bali.ewt.elaf.EWTLookAndFeel.INSTALLED";
    private static boolean _tracking = false;

    public static void installEWTLookAndFeel() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        if (Boolean.TRUE.equals(defaults.get(_KEY_INSTALLED))) {
            return;
        }
        defaults.put(_KEY_INSTALLED, Boolean.TRUE);
        EWTLookAndFeel feel = EWTLookAndFeel.getEWTLookAndFeelByName(UIManager.getLookAndFeel().getName());
        feel.installDefaults(defaults);
        if (!_tracking) {
            _tracking = true;
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    try {
                        if ("lookAndFeel".equals(event.getPropertyName())) {
                            UIManager.getLookAndFeelDefaults().put(EWTLookAndFeel._KEY_INSTALLED, Boolean.FALSE);
                            EWTLookAndFeel.installEWTLookAndFeel();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private static EWTLookAndFeel getEWTLookAndFeelByName(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String className = "oracle.bali.ewt.elaf.oracle.OracleLookAndFeel";
        if ("Oracle Look and Feel version 2".equals(name)) {
            className = "oracle.bali.ewt.elaf.oracle2.OracleLookAndFeel";
        } else if ("Oracle Browser Look and Feel".equals(name)) {
            className = "oracle.bali.ewt.elaf.oracle.BrowserLookAndFeel";
        } else if (name.equals("Windows")) {
            className = "oracle.bali.ewt.elaf.windows.WindowsLookAndFeel";
        } else if (name.equals("Metal")) {
            className = "oracle.bali.ewt.elaf.metal.MetalLookAndFeel";
        } else if (name.equals("CDE/Motif")) {
            className = "oracle.bali.ewt.elaf.motif.MotifLookAndFeel";
        } else if ("MacOS".equals(name) || "Mac OS X".equals(name) || "Mac OS X Aqua".equals(name)) {
            className = "oracle.bali.ewt.elaf.aqua.AquaLookAndFeel";
        } else if ("JGoodies Plastic XP".equals(name) || "JGoodies Plastic 3D".equals(name) || "JGoodies Plastic".equals(name) || "JGoodies Windows".equals(name)) {
            className = "oracle.bali.ewt.elaf.oracle2.OracleLookAndFeel";
        } else if ("WinLAF".equals(name)) {
            className = "oracle.bali.ewt.elaf.windows.WindowsLookAndFeel";
        }
        return EWTLookAndFeel.getEWTLookAndFeel(className);
    }

    private static EWTLookAndFeel getEWTLookAndFeel(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> extended = Class.forName(className);
        return (EWTLookAndFeel)extended.newInstance();
    }

    protected abstract void installDefaults(UIDefaults var1);
}

