/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dnd;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.util.TooManyListenersException;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DragTracker;
import oracle.bali.ewt.dnd.InvalidDnDOperationException;

@Deprecated
public class DragSourceContext
implements DragSourceListener {
    private static final int _DEFAULT = 0;
    private static final int _ENTER = 1;
    private static final int _OVER = 2;
    private static final int _CHANGED = 3;
    private DragSource _dragSource;
    private Cursor _cursor;
    private DragGestureEvent _trigger;
    private Component _component;
    private int _actions;
    private Transferable _transferable;
    private DragSourceListener _listener;
    private boolean _cursorDirty;
    private int _currentDropAction;
    private DragTracker _tracker;
    private boolean _dragSucceeded;
    private int _dragOperation;
    private Cursor _savedCursor;
    private Component _savedParent;
    private Cursor _savedParentCursor;

    DragSourceContext(DragGestureEvent trigger, Cursor dragCursor, Image dragImage, Point offset, Transferable t, DragSourceListener dsl) {
        if (trigger == null) {
            throw new NullPointerException("Trigger");
        }
        this._dragSource = trigger.getDragSource();
        if (this._dragSource == null) {
            throw new NullPointerException("DragSource");
        }
        this._component = trigger.getComponent();
        if (this._component == null) {
            throw new NullPointerException("Component");
        }
        this._actions = trigger.getSourceAsDragGestureRecognizer().getSourceActions();
        if (this._actions == 0) {
            throw new IllegalArgumentException("source actions");
        }
        this._currentDropAction = trigger.getDragAction();
        if (this._currentDropAction == 0) {
            throw new IllegalArgumentException("no drag action");
        }
        if (t == null) {
            throw new NullPointerException("Transferable");
        }
        this._transferable = t;
        this._listener = dsl;
        this._trigger = trigger;
        this._cursor = dragCursor;
        this._cursorDirty = true;
        this._savedCursor = this._component.getCursor();
        if (this._savedCursor == null) {
            this._savedCursor = Cursor.getDefaultCursor();
        }
        for (Container parent = this._component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            this._savedParent = parent;
            this._savedParentCursor = parent.getCursor();
            if (this._savedParentCursor != null) break;
            this._savedParentCursor = Cursor.getDefaultCursor();
            break;
        }
        this._updateCurrentCursor(0);
        this._forceCursorUpdate();
        DragSource.setCurrentDragSourceContext(this);
        this._tracker = new DragTracker(this, dragImage, offset);
        this._tracker.init(trigger.getTriggerEvent());
    }

    public DragSource getDragSource() {
        return this._dragSource;
    }

    public Component getComponent() {
        return this._component;
    }

    public DragGestureEvent getTrigger() {
        return this._trigger;
    }

    public int getSourceActions() {
        return this._actions;
    }

    public void setCursor(Cursor c) {
        if (this._cursor == null || !this._cursor.equals(c)) {
            if (c == null) {
                c = Cursor.getDefaultCursor();
            }
            this._cursorDirty = true;
            this._cursor = c;
            this._forceCursorUpdate();
        }
    }

    public Cursor getCursor() {
        return this._cursor;
    }

    public void setDragImage(Image dragImage) {
        this._tracker.setDragImage(dragImage);
    }

    public Image getDragImage() {
        return this._tracker.getDragImage();
    }

    public synchronized void addDragSourceListener(DragSourceListener dsl) throws TooManyListenersException {
        if (dsl == null) {
            return;
        }
        if (this.equals(dsl)) {
            throw new IllegalArgumentException("DragSourceContext may not be its own listener");
        }
        if (this._listener != null) {
            throw new TooManyListenersException();
        }
        this._listener = dsl;
    }

    public synchronized void removeDragSourceListener(DragSourceListener dsl) {
        if (this._listener == null || this._listener != dsl) {
            throw new IllegalArgumentException();
        }
        this._listener = null;
    }

    void transferablesFlavorsChanged() {
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        DragSourceListener listener = this._listener;
        if (listener != null) {
            listener.dragEnter(dsde);
        }
        this._updateCurrentCursor(dsde.getDropAction() & dsde.getTargetActions());
    }

    public void dragOver(DragSourceDragEvent dsde) {
        DragSourceListener listener = this._listener;
        if (listener != null) {
            listener.dragOver(dsde);
        }
        this._updateCurrentCursor(dsde.getDropAction() & dsde.getTargetActions());
    }

    public void dragExit(DragSourceEvent dse) {
        DragSourceListener listener = this._listener;
        if (listener != null) {
            listener.dragExit(dse);
        }
        this._updateCurrentCursor(0);
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
        DragSourceListener listener = this._listener;
        if (listener != null) {
            listener.dropActionChanged(dsde);
        }
        this._currentDropAction = dsde.getDropAction();
        this._updateCurrentCursor(dsde.getDropAction() & dsde.getTargetActions());
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        DragSourceListener listener = this._listener;
        if (listener != null) {
            listener.dragDropEnd(dsde);
        }
        this._component.setCursor(this._savedCursor);
        this._savedParent.setCursor(this._savedParentCursor);
    }

    public Transferable getTransferable() {
        return this._transferable;
    }

    private void _updateCurrentCursor(int ra) {
        int actions;
        if (this._cursorDirty && this._cursor != null) {
            this._cursorDirty = false;
            return;
        }
        Cursor c = null;
        c = ra == 0 ? (((actions = this.getSourceActions()) & 0x40000000) != 0 ? DragSource.DefaultLinkNoDrop : ((actions & 2) != 0 ? DragSource.DefaultMoveNoDrop : DragSource.DefaultCopyNoDrop)) : ((ra & 0x40000000) != 0 ? DragSource.DefaultLinkDrop : ((ra & 2) != 0 ? DragSource.DefaultMoveDrop : DragSource.DefaultCopyDrop));
        this.setCursor(c);
        this._cursorDirty = false;
    }

    void startDrag() {
        this._component.addMouseListener(this._tracker);
        this._component.addMouseMotionListener(this._tracker);
        this._forceCursorUpdate();
    }

    boolean getDragSucceded() {
        return this._dragSucceeded;
    }

    void setDragOperation(int operation) {
        this._dragOperation = operation;
    }

    void setDragSuccess(boolean success) {
        this._dragSucceeded = success;
    }

    int getDragOperation() {
        return this._dragOperation;
    }

    void cancelDrag() throws InvalidDnDOperationException {
        this._dragSucceeded = false;
        this._tracker.terminateDrag(true);
    }

    private void _forceCursorUpdate() {
        Cursor cursor = this.getCursor();
        this._component.setCursor(cursor);
        this._savedParent.setCursor(cursor);
    }
}

