/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeChildManager;
import oracle.bali.ewt.dTree.DTreeDeferringParent;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeItemFactory;
import oracle.bali.ewt.dTree.OneDSparseArray;

public class DTreeSparseChildManager
implements DTreeChildManager {
    private OneDSparseArray _children;
    private DTreeItem[] _expandedchildren;
    private int _nexpanded;
    private int _subht;
    private int _parentht;

    public void childExpansionChanged(DTreeDeferringParent parent, DTreeItem child) {
        if (child.isExpanded()) {
            this._addExpandedChild(parent, child);
        } else {
            this._removeExpandedChild(parent, child);
        }
    }

    public int getChildX(DTreeDeferringParent parent, int index) {
        DTree tree = parent.getTree();
        int parentx = parent.getX();
        if (parent == tree.getRoot()) {
            return parentx;
        }
        return parentx + this.getChildrenXOffset(parent, tree.getIndentWidth());
    }

    public int getChildY(DTreeDeferringParent parent, int index) {
        int parenty = parent.getY();
        int parentht = this._getParentHeight();
        int childht = parent.getChildHeight();
        int topindex = 0;
        int topy = parenty + this.getChildrenYOffset(parent, parentht);
        if (parent.isExpanded() && this._nexpanded != 0) {
            DTreeItem child;
            int childindex;
            for (int i = 0; i < this._nexpanded && index > (childindex = (child = this._expandedchildren[i]).getIndex()); ++i) {
                topy += (childindex - topindex) * childht + child.getSubTreeHeight();
                topindex = childindex + 1;
            }
        }
        return topy + (index - topindex) * childht;
    }

    public DTreeItem getItem(DTreeDeferringParent parent, int index) {
        DTreeItemFactory factory;
        DTreeItem child;
        if (this._children == null) {
            this._children = new OneDSparseArray();
        }
        if ((child = (DTreeItem)this._children.getElement(index)) == null && (child = (factory = parent.getItemFactory()).createItem(parent, index)) != null) {
            this._children.setElement(child, index);
            child.itemAdded(parent, index);
        }
        return child;
    }

    public DTreeItem getItemAt(DTreeDeferringParent parent, int x, int y) {
        int subht = parent.getSubTreeHeight();
        if (y >= subht) {
            return null;
        }
        int parentht = this._getParentHeight();
        if (y < parentht) {
            return parent;
        }
        int childheight = parent.getChildHeight();
        int topindex = 0;
        int topy = this.getChildrenYOffset(parent, parentht);
        if (parent.isExpanded() && this._nexpanded != 0) {
            int parenty = parent.getY();
            for (int i = 0; i < this._nexpanded; ++i) {
                DTreeItem child = this._expandedchildren[i];
                int childindex = child.getIndex();
                int childy = topy + (childindex - topindex) * childheight;
                subht = child.getSubTreeHeight();
                if (y < childy) break;
                if (y < childy + subht) {
                    return child.getItemAt(x, y - childy);
                }
                topy = childy + subht;
                topindex = childindex + 1;
            }
        }
        return parent.getItem(topindex + (y - topy) / childheight);
    }

    public DTreeItem getNextExpandedChild(DTreeDeferringParent parent, DTreeItem child) {
        DTreeItem next = null;
        if (child == null) {
            if (this._nexpanded > 0) {
                next = this._expandedchildren[0];
            }
        } else {
            int i;
            for (i = 0; i < this._nexpanded && this._expandedchildren[i] != child; ++i) {
            }
            if (i < this._nexpanded - 1) {
                next = this._expandedchildren[i + 1];
            }
        }
        return next;
    }

    public DTreeItem getNextInstantiatedChild(DTreeDeferringParent parent, DTreeItem child) {
        if (this._children == null) {
            return null;
        }
        int index = 0;
        index = child == null ? this._children.getFirstIndex() : this._children.getNextIndex(child.getIndex());
        if (index == -1) {
            return null;
        }
        return (DTreeItem)this._children.getElement(index);
    }

    public int getSubTreeHeight(DTreeDeferringParent parent) {
        return this._subht;
    }

    public void itemsAdded(DTreeDeferringParent parent, int startIndex, int count) {
        int start = startIndex;
        int addedcount = count;
        if (this._children != null) {
            this._children.insertElements(start, addedcount);
            int index = this._children.getNextIndex(start);
            while (index != -1) {
                DTreeItem child = (DTreeItem)this._children.getElement(index);
                if (child != null) {
                    child.setIndex(index);
                }
                index = this._children.getNextIndex(index);
            }
        }
    }

    public void itemsRemoved(DTreeDeferringParent parent, int startIndex, int count) {
        int start = startIndex;
        int removedcount = count;
        if (this._children != null) {
            DTreeItem item;
            int index = start;
            while (index != -1 && index < start + removedcount) {
                item = (DTreeItem)this._children.getElement(index);
                if (item != null) {
                    if (item.isExpanded()) {
                        this._removeExpandedChild(parent, item);
                    }
                    item.itemRemoved();
                }
                index = this._children.getNextIndex(index);
            }
            this._children.removeElements(start, removedcount);
            index = start;
            while (index != -1) {
                item = (DTreeItem)this._children.getElement(index);
                if (item != null) {
                    item.setIndex(index);
                }
                index = this._children.getNextIndex(index);
            }
        }
    }

    public void layout(DTreeDeferringParent parent, int x, int y) {
        int parentHeight = this._parentht = parent.getSize().height;
        if (parent.isExpanded() && parent.getItemCount() != 0) {
            DTree tree = parent.getTree();
            int childYOffset = this.getChildrenYOffset(parent, parentHeight);
            int childXOffset = 0;
            if (parent != tree.getRoot()) {
                childXOffset = this.getChildrenXOffset(parent, tree.getIndentWidth());
            }
            int subtreeHeight = this._layoutChildren(parent, x + childXOffset, y + childYOffset);
            this._subht = Math.max(parentHeight, childYOffset + subtreeHeight);
        } else {
            this._subht = parentHeight;
        }
    }

    protected int getChildrenXOffset(DTreeDeferringParent parent, int indentWidth) {
        return indentWidth;
    }

    protected int getChildrenYOffset(DTreeDeferringParent parent, int parentHeight) {
        return parentHeight;
    }

    private void _addExpandedChild(DTreeDeferringParent parent, DTreeItem child) {
        if (this._expandedchildren == null) {
            this._expandedchildren = new DTreeItem[1];
        }
        if (this._nexpanded == this._expandedchildren.length) {
            DTreeItem[] tmpchildren = new DTreeItem[this._expandedchildren.length * 2];
            System.arraycopy(this._expandedchildren, 0, tmpchildren, 0, this._nexpanded);
            this._expandedchildren = tmpchildren;
        }
        int childindex = child.getIndex();
        for (int i = 0; i < this._nexpanded; ++i) {
            if (childindex >= this._expandedchildren[i].getIndex()) continue;
            System.arraycopy(this._expandedchildren, i, this._expandedchildren, i + 1, this._nexpanded - i);
            break;
        }
        this._expandedchildren[i] = child;
        ++this._nexpanded;
    }

    private int _layoutChildren(DTreeDeferringParent parent, int x, int y) {
        int expandedheight = 0;
        int childheight = parent.getChildHeight();
        if (parent.isExpanded() && this._nexpanded != 0) {
            int childy = 0;
            for (int i = 0; i < this._nexpanded; ++i) {
                DTreeItem child = this._expandedchildren[i];
                childy = (child.getIndex() - i) * childheight + expandedheight;
                child.layout(x, y + childy);
                expandedheight += child.getSubTreeHeight();
            }
        }
        return expandedheight + (parent.getItemCount() - this._nexpanded) * childheight;
    }

    private void _removeExpandedChild(DTreeDeferringParent parent, DTreeItem child) {
        for (int i = 0; i < this._nexpanded; ++i) {
            if (this._expandedchildren[i] != child) continue;
            if (i != this._nexpanded - 1) {
                System.arraycopy(this._expandedchildren, i + 1, this._expandedchildren, i, this._nexpanded - i - 1);
            }
            --this._nexpanded;
            this._expandedchildren[this._nexpanded] = null;
            return;
        }
    }

    private int _getParentHeight() {
        return this._parentht;
    }
}

