/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.patch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.ide.util.MetaClass;
import oracle.ide.javaxide.Util;
import oracle.javatools.patch.PatchAssistance;
import oracle.jdeveloper.patch.DefaultPatchAssistance;

public class PatchAssistanceManager {
    private static Collection<AssistanceAdapter> _assist = new ArrayList<AssistanceAdapter>();

    static void registerAssistance(MetaClass mc) {
        AssistanceAdapter adapter = new AssistanceAdapter(mc);
        _assist.add(adapter);
    }

    public static PatchAssistance getAssistance(byte[] str) {
        Iterator<AssistanceAdapter> it = _assist.iterator();
        while (it.hasNext()) {
            PatchAssistance assist = it.next().getPatchAssistance();
            if (!assist.isRecognised(str)) continue;
            return assist;
        }
        return new DefaultPatchAssistance();
    }

    private static class AssistanceAdapter {
        private MetaClass _mc;
        private PatchAssistance _assist;

        private AssistanceAdapter(MetaClass mc) {
            this._mc = mc;
        }

        private PatchAssistance getPatchAssistance() {
            if (this._assist == null) {
                this._assist = (PatchAssistance)Util.createInstance((MetaClass)this._mc, PatchAssistance.class);
            }
            return this._assist;
        }
    }
}

