/*
 * Decompiled with CFR 0.152.
 */
package ice.util.awt.jdk11;

import ice.debug.Debug;
import ice.util.awt.AwtQueueKit;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;

public final class AwtQueueKit_jdk11
extends AwtQueueKit {
    private ProxyComponent proxy = new ProxyComponent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAndWait(Runnable code) throws InterruptedException, InvocationTargetException {
        if (this.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        final AWTInvocationLock _lock = new AWTInvocationLock();
        this.proxy.invokeLater(code, true);
        AWTInvocationLock aWTInvocationLock = _lock;
        synchronized (aWTInvocationLock) {
            this.proxy.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = _lock;
                    synchronized (object) {
                        _lock.notifyAll();
                    }
                }
            });
            _lock.wait();
        }
    }

    public void invokeLater(Runnable code) {
        this.proxy.invokeLater(code);
    }

    public boolean isDispatchThread() {
        Thread current = Thread.currentThread();
        String name = current.getClass().getName();
        if (name.equals("java.awt.EventDispatchThread")) {
            return true;
        }
        return current == this.proxy.awtThread;
    }

    private static final class ProxyComponent
    extends Component
    implements Runnable {
        Thread awtThread;
        private EventQueue awtQueue;
        private ProxyEvent first;
        private ProxyEvent last;

        ProxyComponent() {
            block2: {
                this.enableEvents(-1L);
                try {
                    this.awtQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                }
                catch (RuntimeException ex) {
                    if (!Debug.ex) break block2;
                    Debug.ex(ex);
                }
            }
            this.invokeLater(this);
        }

        public void run() {
            this.awtThread = Thread.currentThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void processEvent(AWTEvent event) {
            if (this.awtQueue != null) {
                if (event instanceof ProxyEvent) {
                    ProxyComponent.invoke_run((ProxyEvent)event);
                }
            } else {
                ProxyEvent cursor;
                ProxyComponent proxyComponent = this;
                synchronized (proxyComponent) {
                    cursor = this.first;
                    this.last = null;
                    this.first = null;
                }
                while (cursor != null) {
                    ProxyComponent.invoke_run(cursor);
                    cursor = cursor.next;
                }
            }
        }

        private static void invoke_run(ProxyEvent event) {
            if (AwtQueueKit.trace_awt_queue) {
                AwtQueueKit.trace_print_java_stack(event.code);
            }
            try {
                event.code.run();
            }
            catch (Exception exception) {
                if (event.catchExceptions) {
                    event.exception = exception;
                }
                Debug.ex(exception);
            }
        }

        void invokeLater(Runnable code) {
            if (AwtQueueKit.trace_awt_queue) {
                AwtQueueKit.trace_add_to_stack_trace(code, 0L);
            }
            this.invoke_later(new ProxyEvent(this, code));
        }

        void invokeLater(Runnable code, boolean catchExceptions) throws InvocationTargetException {
            if (AwtQueueKit.trace_awt_queue) {
                AwtQueueKit.trace_add_to_stack_trace(code, 0L);
            }
            ProxyEvent _event = new ProxyEvent(this, code, catchExceptions);
            this.invoke_later(_event);
            if (_event.exception != null) {
                throw new InvocationTargetException(_event.exception);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invoke_later(ProxyEvent event) {
            if (this.awtQueue != null) {
                this.awtQueue.postEvent(event);
            } else {
                ProxyComponent proxyComponent = this;
                synchronized (proxyComponent) {
                    if (this.last == null) {
                        this.first = this.last = event;
                    } else {
                        this.last.next = event;
                        this.last = event;
                    }
                }
                this.setVisible(true);
                this.setVisible(false);
            }
        }
    }

    private static final class ProxyEvent
    extends AWTEvent {
        Runnable code;
        ProxyEvent next;
        boolean catchExceptions;
        Exception exception;

        ProxyEvent(ProxyComponent proxyComponent, Runnable code) {
            this(proxyComponent, code, false);
        }

        ProxyEvent(ProxyComponent proxyComponent, Runnable code, boolean catchExceptions) {
            super(proxyComponent, 2000);
            this.code = code;
            this.catchExceptions = catchExceptions;
        }
    }
}

