/*
 * Decompiled with CFR 0.152.
 */
package ice.ri.common.dialog.awt;

import java.awt.TextField;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;

public class FormattedTextField
extends TextField {
    static final char ANYCHAR = '\u0000';
    static final char DIGIT = '\u0001';
    static final char LOWERCASE = '\u0002';
    static final char UPPERCASE = '\u0003';
    private String mask;
    private int index;
    private int len;
    private int lastIndex;
    private int startIndex;
    private boolean validate;

    public FormattedTextField(String mask, int nColumns, boolean _validate) {
        super(nColumns);
        this.validate = _validate;
        this.len = mask.length();
        StringBuffer mask2 = new StringBuffer(mask);
        for (int i = 0; i < this.len; ++i) {
            if (mask2.charAt(i) == 'c') {
                mask2.setCharAt(i, '\u0000');
                continue;
            }
            if (mask2.charAt(i) == '9') {
                mask2.setCharAt(i, '\u0001');
                continue;
            }
            if (mask2.charAt(i) == 'a') {
                mask2.setCharAt(i, '\u0002');
                continue;
            }
            if (mask2.charAt(i) != 'A') continue;
            mask2.setCharAt(i, '\u0003');
        }
        mask = mask2.toString();
        boolean found = false;
        for (int i = 0; i < this.len; ++i) {
            if (mask.charAt(i) != '\u0000' && mask.charAt(i) != '\u0001' && mask.charAt(i) != '\u0002' && mask.charAt(i) != '\u0003' && mask.charAt(i) != '_') continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("No mask characters found");
        }
        this.mask = mask;
        this.enableEvents(8L);
        this.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!FormattedTextField.this.validate || FormattedTextField.this.index == FormattedTextField.this.startIndex) {
                    return;
                }
                if (FormattedTextField.this.index <= FormattedTextField.this.lastIndex) {
                    FormattedTextField.this.requestFocus();
                }
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        StringBuffer mask2 = new StringBuffer(this.mask);
        for (int i = 0; i < this.len; ++i) {
            if (mask2.charAt(i) != '\u0000' && mask2.charAt(i) != '\u0001' && mask2.charAt(i) != '\u0002' && mask2.charAt(i) != '\u0003') continue;
            mask2.setCharAt(i, '_');
        }
        String s = mask2.toString();
        this.setText(s);
        this.startIndex = this.index = s.indexOf(95);
        this.setCaretPosition(this.startIndex);
        this.lastIndex = s.lastIndexOf(95);
    }

    String getData() {
        String text = this.getText();
        if (text == null || text.length() != this.len) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.index; ++i) {
            if (this.mask.charAt(i) != '\u0000' && this.mask.charAt(i) != '\u0001' && this.mask.charAt(i) != '\u0002' && this.mask.charAt(i) != '\u0003' && this.mask.charAt(i) != '_') continue;
            sb.append(text.charAt(i));
        }
        return sb.toString();
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401 && e.getKeyCode() == 8) {
            if (this.index == 0) {
                e.consume();
                return;
            }
            --this.index;
            StringBuffer sb = new StringBuffer(this.getText());
            do {
                if (sb.charAt(this.index) == this.mask.charAt(this.index)) {
                    --this.index;
                    continue;
                }
                sb.setCharAt(this.index, '_');
                this.setText(sb.toString());
                break;
            } while (this.index >= 0);
            if (this.index < 0) {
                this.index = this.startIndex;
            }
            this.setCaretPosition(this.index);
        }
        if (e.getID() == 401 || e.getID() == 402) {
            int keyCode = e.getKeyCode();
            if (keyCode == 8 || keyCode == 127 || keyCode == 40 || keyCode == 35 || keyCode == 36 || keyCode == 37 || keyCode == 39 || keyCode == 38) {
                e.consume();
                return;
            }
            super.processKeyEvent(e);
            return;
        }
        if (e.getID() == 400) {
            if (e.getKeyChar() == '\b' || this.index == this.len) {
                e.consume();
                return;
            }
            switch (this.mask.charAt(this.index)) {
                case '\u0001': {
                    if (Character.isDigit(e.getKeyChar())) break;
                    e.consume();
                    return;
                }
                case '\u0002': {
                    if (Character.isLowerCase(e.getKeyChar())) break;
                    e.consume();
                    return;
                }
                case '\u0003': {
                    if (Character.isUpperCase(e.getKeyChar())) break;
                    e.consume();
                    return;
                }
            }
            StringBuffer text = new StringBuffer(this.getText());
            text.setCharAt(this.index++, e.getKeyChar());
            this.setText(text.toString());
            this.setCaretPosition(this.index);
            while (this.index < this.len) {
                if (text.charAt(this.index) == '_') {
                    this.setCaretPosition(this.index);
                    break;
                }
                ++this.index;
            }
            e.consume();
        }
    }
}

