/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.properties;

import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageModule;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.editor.language.properties.PropertiesBlockRenderer;
import oracle.javatools.editor.language.properties.PropertiesLanguageSupport;
import oracle.javatools.editor.language.properties.PropertiesStyles;
import oracle.javatools.resource.BundleHelper;

public final class PropertiesLanguageModule
extends LanguageModule {
    private static final String[] supportedFileTypes = new String[]{"properties", "rts"};

    @Override
    public String getPresentationName() {
        BundleHelper resources = EditorProperties.getEditorBundle();
        return resources.getString("PROPERTIES_MODULE_NAME");
    }

    @Override
    public String[] getStyleNames() {
        return PropertiesStyles.STYLE_NAMES;
    }

    @Override
    public String getContentSample() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# String resources for Java application\n");
        buffer.append("\n");
        buffer.append("# Title displayed in main application frame\n");
        buffer.append("FRAME_TITLE = SmartCalendar\n");
        buffer.append("\n");
        buffer.append("# About box: company name\n");
        buffer.append("ABOUT_BOX_COMPANY = SmartCalendar Corporation\n");
        buffer.append("\n");
        buffer.append("# About box: version number\n");
        buffer.append("ABOUT_BOX_VERSION = 1.05\n");
        buffer.append("\n");
        buffer.append("# About box: copyright info\n");
        buffer.append("ABOUT_BOX_COPYRIGHT = Copyright (c) 2001, ");
        buffer.append("SmartCalendar Corporation.  \\\n");
        buffer.append("All rights reserved.\n");
        return buffer.toString();
    }

    @Override
    public String[] getSupportedFileTypes() {
        return supportedFileTypes;
    }

    @Override
    public void registerStyles(StyleRegistry registry) {
        new PropertiesStyles(registry);
    }

    @Override
    public LanguageSupport createLanguageSupport() {
        return new PropertiesLanguageSupport();
    }

    @Override
    public BlockRenderer createBlockRenderer(TextBuffer buffer) {
        return new PropertiesBlockRenderer(buffer);
    }
}

