/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language.idl;

import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

public final class IDLStyles {
    public static final String IDL_COMMENT_STYLE = "idl-comment-style";
    public static final String IDL_KEYWORD_STYLE = "idl-keyword-style";
    public static final String IDL_IDENTIFIER_STYLE = "idl-identifier-style";
    public static final String IDL_STRING_STYLE = "idl-string-style";
    public static final String IDL_NUMBER_STYLE = "idl-number-style";
    public static final String IDL_BRACE_STYLE = "idl-brace-style";
    public static final String IDL_OPERATOR_STYLE = "idl-operator-style";
    public static final String[] STYLE_NAMES = new String[]{"idl-comment-style", "idl-keyword-style", "idl-identifier-style", "idl-string-style", "idl-number-style", "idl-brace-style", "idl-operator-style"};
    public static BaseStyle idlPlainStyle;
    public static BaseStyle idlCommentStyle;
    public static BaseStyle idlKeywordStyle;
    public static BaseStyle idlIdentifierStyle;
    public static BaseStyle idlStringStyle;
    public static BaseStyle idlNumberStyle;
    public static BaseStyle idlBraceStyle;
    public static BaseStyle idlOperatorStyle;

    public IDLStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        String name;
        BundleHelper resources = EditorProperties.getEditorBundle();
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        idlPlainStyle = builtInStyles.plainStyle;
        idlCommentStyle = styleRegistry.lookupStyle(IDL_COMMENT_STYLE);
        if (idlCommentStyle == null) {
            name = resources.getString("IDL_COMMENT_STYLE");
            idlCommentStyle = styleRegistry.createStyle(IDL_COMMENT_STYLE, name, "base-comment-style");
        }
        if ((idlStringStyle = styleRegistry.lookupStyle(IDL_STRING_STYLE)) == null) {
            name = resources.getString("IDL_STRING_STYLE");
            idlStringStyle = styleRegistry.createStyle(IDL_STRING_STYLE, name, "base-string-style");
        }
        if ((idlKeywordStyle = styleRegistry.lookupStyle(IDL_KEYWORD_STYLE)) == null) {
            name = resources.getString("IDL_KEYWORD_STYLE");
            idlKeywordStyle = styleRegistry.createStyle(IDL_KEYWORD_STYLE, name, "base-keyword-style");
        }
        if ((idlIdentifierStyle = styleRegistry.lookupStyle(IDL_IDENTIFIER_STYLE)) == null) {
            name = resources.getString("IDL_IDENTIFIER_STYLE");
            idlIdentifierStyle = styleRegistry.createStyle(IDL_IDENTIFIER_STYLE, name, "base-identifier-style");
        }
        if ((idlNumberStyle = styleRegistry.lookupStyle(IDL_NUMBER_STYLE)) == null) {
            name = resources.getString("IDL_NUMBER_STYLE");
            idlNumberStyle = styleRegistry.createStyle(IDL_NUMBER_STYLE, name, "base-number-style");
        }
        if ((idlBraceStyle = styleRegistry.lookupStyle(IDL_BRACE_STYLE)) == null) {
            name = resources.getString("IDL_BRACE_STYLE");
            idlBraceStyle = styleRegistry.createStyle(IDL_BRACE_STYLE, name, "base-brace-style");
        }
        if ((idlOperatorStyle = styleRegistry.lookupStyle(IDL_OPERATOR_STYLE)) == null) {
            name = resources.getString("IDL_OPERATOR_STYLE");
            idlOperatorStyle = styleRegistry.createStyle(IDL_OPERATOR_STYLE, name, "base-operator-style");
        }
    }
}

