/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor.language;

import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.language.BraceProvider;
import oracle.javatools.editor.language.DefaultWordLocator;
import oracle.javatools.editor.language.DocumentRenderer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.OffsetDescriptionProvider;
import oracle.javatools.editor.language.SmartIndentProvider;
import oracle.javatools.editor.language.WordLocator;

public abstract class AbstractLanguageSupport
implements LanguageSupport {
    private BasicDocument document;
    private DocumentRenderer documentRenderer;
    private BraceProvider braceProvider;
    private WordLocator wordLocator;
    private SmartIndentProvider smartIndentProvider;
    private OffsetDescriptionProvider offsetDescriptionProvider;

    @Override
    public void install(BasicDocument document) {
        this.document = document;
        this.documentRenderer = null;
    }

    @Override
    public void deinstall() {
        this.document = null;
    }

    @Override
    public final BasicDocument getDocument() {
        return this.document;
    }

    @Override
    public final Object getProperty(String key) {
        if (key != null) {
            return this.getPropertyImpl(key);
        }
        return null;
    }

    protected Object getPropertyImpl(String key) {
        return null;
    }

    @Override
    public final DocumentRenderer getDocumentRenderer() {
        if (this.documentRenderer == null) {
            this.documentRenderer = this.createDocumentRenderer();
            if (this.documentRenderer == null) {
                throw new IllegalStateException("Document renderer missing");
            }
        }
        return this.documentRenderer;
    }

    @Override
    public final BraceProvider getBraceProvider() {
        if (this.braceProvider == null) {
            this.braceProvider = this.createBraceProvider();
        }
        return this.braceProvider;
    }

    @Override
    public WordLocator getWordLocator() {
        if (this.wordLocator == null) {
            this.wordLocator = this.createWordLocator();
        }
        return this.wordLocator;
    }

    @Override
    public SmartIndentProvider getSmartIndentProvider() {
        if (this.smartIndentProvider == null) {
            this.smartIndentProvider = this.createSmartIndentProvider();
        }
        return this.smartIndentProvider;
    }

    public OffsetDescriptionProvider getOffsetDescriptionProvider() {
        if (this.offsetDescriptionProvider == null) {
            this.offsetDescriptionProvider = this.createOffsetDescriptionProvider();
        }
        return this.offsetDescriptionProvider;
    }

    protected abstract DocumentRenderer createDocumentRenderer();

    protected BraceProvider createBraceProvider() {
        return null;
    }

    protected WordLocator createWordLocator() {
        return new DefaultWordLocator(this);
    }

    protected SmartIndentProvider createSmartIndentProvider() {
        return null;
    }

    protected OffsetDescriptionProvider createOffsetDescriptionProvider() {
        return null;
    }
}

