/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.editor;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import oracle.javatools.editor.BasicEditorPainter;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EditorSelectionColumns;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;

final class ColumnSelectionPainter
implements BasicEditorPainter {
    private static Color selectionStyleColor = null;
    private final EditorSelectionColumns editorSelectionColumns;

    ColumnSelectionPainter(EditorSelectionColumns editorSelectionColumns) {
        this.editorSelectionColumns = editorSelectionColumns;
    }

    @Override
    public void paint(Graphics g, BasicEditorPane editor) {
        if (!editor.hasSelection()) {
            return;
        }
        try {
            g.setColor(selectionStyleColor != null ? selectionStyleColor : editor.getSelectionColor());
            int startCol = this.editorSelectionColumns.getStartColumn();
            int endCol = this.editorSelectionColumns.getEndColumn();
            int startLine = this.editorSelectionColumns.getStartLine();
            int endLine = this.editorSelectionColumns.getEndLine();
            int charWidth = this.editorSelectionColumns.getColumnWidth(editor);
            Rectangle startR = editor.modelToView(editor.getLineStartOffset(startLine));
            Rectangle endR = editor.modelToView(editor.getLineStartOffset(endLine));
            int x = startR.x + startCol * charWidth;
            int w = (endCol - startCol) * charWidth;
            int y = startR.y;
            int h = endR.y + endR.height - y;
            g.fillRect(x, y, w, h);
        }
        catch (BadLocationException e) {
            Logger.getLogger("global").log(Level.SEVERE, "Column Selection Error", e);
        }
    }

    @Override
    public int getPriority() {
        return -1;
    }

    static {
        EditorProperties properties = EditorProperties.getProperties();
        final HighlightRegistry registry = properties.getHighlightRegistry();
        HighlightStyle style = registry.lookupStyle("highlight-selection");
        if (style != null) {
            selectionStyleColor = style.getBackgroundColor();
        }
        registry.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                HighlightStyle style = registry.lookupStyle("highlight-selection");
                if (style != null) {
                    selectionStyleColor = style.getBackgroundColor();
                }
            }
        });
    }
}

