/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;

public class CharArrayFactory
extends ObjectFactory {
    public static final CharArrayFactory CHAR_ARRAY_FACTORY = new CharArrayFactory();
    private static final byte CHAR_ARRAY_CODE = -54;

    protected CharArrayFactory() {
    }

    @Override
    public byte getObjectCode() {
        return -54;
    }

    @Override
    public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
        int len = input.readInt();
        char[] array = new char[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readChar();
        }
        return array;
    }

    @Override
    public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
        char[] array = (char[])object;
        int len = array.length;
        output.writeInt(len);
        for (int i = 0; i < len; ++i) {
            output.writeChar(array[i]);
        }
    }
}

