/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.platform.mt.jrf;

import java.lang.reflect.Method;
import java.util.UUID;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.platform.mt.Tenant;
import oracle.adf.share.platform.mt.TenantContext;
import oracle.adfinternal.share.platform.mt.jrf.JRFTenant;
import oracle.adfinternal.share.platform.mt.jrf.JRFTenantContextFactory;

public final class JRFTenantContext
extends TenantContext {
    private static final ADFLogger logger = ADFLogger.createADFLogger(JRFTenantContext.class);
    private final Object wrappedContext;
    private final JRFTenantContextFactory f;

    public JRFTenantContext(Object wrappedContext, JRFTenantContextFactory factory) {
        this.wrappedContext = wrappedContext;
        this.f = factory;
    }

    private Object invoke(Object obj, Method meth) {
        try {
            return meth.invoke(obj, new Object[0]);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public Tenant getCurrentTenant() {
        Object wrappedTenant = this.invoke(this.wrappedContext, this.f.tcMethods[0]);
        if (wrappedTenant != null) {
            String tenantName = (String)this.invoke(wrappedTenant, this.f.tMethods[0]);
            UUID tenantUUID = (UUID)this.invoke(wrappedTenant, this.f.tMethods[1]);
            if (tenantUUID != null) {
                if (logger.isFine()) {
                    logger.fine("Name=" + tenantName + ", UUID=" + tenantUUID);
                }
                return new JRFTenant(tenantName, tenantUUID, this.isGlobal());
            }
            if (this.f.tMethods[2] != null) {
                String tenantId = (String)this.invoke(wrappedTenant, this.f.tMethods[2]);
                if (logger.isFine()) {
                    logger.fine("Name=" + tenantName + ", UUID=" + tenantUUID + ", Id=" + tenantId);
                }
                return new JRFTenant(tenantName, tenantId, this.isGlobal());
            }
        }
        return null;
    }

    @Override
    public String getTopLevelDir() {
        return (String)this.invoke(this.wrappedContext, this.f.tcMethods[1]);
    }

    @Override
    public String getCurrentPartitionName() {
        try {
            Object manager = this.invoke(null, this.f.cicMethods[0]);
            if (manager != null) {
                Object context = this.invoke(manager, this.f.cicMethods[1]);
                if (context != null) {
                    String partitionName = (String)this.invoke(context, this.f.cicMethods[2]);
                    if (logger.isFine()) {
                        logger.fine("CurrentPatitionName: " + partitionName);
                    }
                    return partitionName;
                }
                if (logger.isFine()) {
                    logger.fine("Context null");
                }
            } else if (logger.isFine()) {
                logger.fine("Manager null");
            }
        }
        catch (Throwable t) {
            if (t instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t;
            }
            throw new IllegalArgumentException(t);
        }
        return null;
    }

    @Override
    public UUID getServiceUUID() {
        return (UUID)this.invoke(this.wrappedContext, this.f.tcMethods[2]);
    }

    @Override
    public boolean isGlobal() {
        return (Boolean)this.invoke(this.wrappedContext, this.f.tcMethods[3]);
    }
}

