/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.platform.mt;

import java.beans.Beans;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.platform.AdfServerPlatformUtil;
import oracle.adf.share.platform.resources.ADFPlatformMessageBundle;
import oracle.core.ojdl.logging.ODLLevel;

public abstract class MTHelper {
    public static boolean getMultitenancyEnabled() {
        return SingletonHolder.mtEnabled;
    }

    public static void throwTenantInvalidException() {
        String msg = ADFPlatformMessageBundle.get("MT_ENABLED_BUT_INCOMPLETE_TENANT_CONTEXT");
        Logger.getLogger(MTHelper.class.getName()).log(ODLLevel.INCIDENT_ERROR, msg);
        throw new IllegalStateException(msg);
    }

    public static void throwTenantInvalidException(Throwable t) {
        String msg = ADFPlatformMessageBundle.get("MT_ENABLED_BUT_INCOMPLETE_TENANT_CONTEXT");
        Logger.getLogger(MTHelper.class.getName()).log(ODLLevel.INCIDENT_ERROR, msg, t);
        throw new IllegalStateException(msg);
    }

    private static class SingletonHolder {
        private static final boolean mtEnabled = SingletonHolder.initMTEnabled();

        private SingletonHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean initMTEnabled() {
            Throwable tt;
            String MSG_KEY;
            String msg;
            boolean ret;
            block17: {
                block16: {
                    ret = false;
                    msg = null;
                    MSG_KEY = "MT_IS_DESIGN_TIME";
                    tt = null;
                    if (!Beans.isDesignTime()) break block16;
                    boolean bl = false;
                    Logger logger = Logger.getLogger(MTHelper.class.getName());
                    if (logger.isLoggable(Level.FINE) && tt != null) {
                        logger.log(Level.FINE, MSG_KEY + ", ret=" + ret, tt);
                        return bl;
                    } else {
                        if (!logger.isLoggable(Level.CONFIG)) return bl;
                        msg = msg != null ? msg : ADFPlatformMessageBundle.get(MSG_KEY);
                        logger.config(String.format(ADFPlatformMessageBundle.get("MT_HELPER_CONFIG_FORMAT"), msg, ret));
                    }
                    return bl;
                }
                MSG_KEY = "MT_EE_PLATFORM_NOT_WLS";
                if (!AdfServerPlatformUtil.isGlassFish() && !AdfServerPlatformUtil.isWebSphere() && !AdfServerPlatformUtil.isTomcat() && !AdfServerPlatformUtil.isJBoss()) break block17;
                boolean bl = false;
                Logger logger = Logger.getLogger(MTHelper.class.getName());
                if (logger.isLoggable(Level.FINE) && tt != null) {
                    logger.log(Level.FINE, MSG_KEY + ", ret=" + ret, tt);
                    return bl;
                } else {
                    if (!logger.isLoggable(Level.CONFIG)) return bl;
                    msg = msg != null ? msg : ADFPlatformMessageBundle.get(MSG_KEY);
                    logger.config(String.format(ADFPlatformMessageBundle.get("MT_HELPER_CONFIG_FORMAT"), msg, ret));
                }
                return bl;
            }
            try {
                ClassUtils.forName("org.glassfish.hk2.utilities.ServiceLocatorUtilities", MTHelper.class).getMethod("createAndPopulateServiceLocator", new Class[0]);
                ClassUtils.forName("org.glassfish.hk2.api.ServiceLocator", MTHelper.class).getMethod("getService", Class.class, new Annotation[0].getClass());
                MSG_KEY = "MT_JRF_HELPER_ENABLED";
                ret = (Boolean)ClassUtils.forName("com.oracle.jrf.mt.tenant.MTHelper", MTHelper.class).getMethod("isMultitenancyEnabled", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                try {
                    msg = String.valueOf(t);
                    tt = t;
                }
                catch (Throwable throwable) {
                    Logger logger = Logger.getLogger(MTHelper.class.getName());
                    if (logger.isLoggable(Level.FINE) && tt != null) {
                        logger.log(Level.FINE, MSG_KEY + ", ret=" + ret, tt);
                        throw throwable;
                    } else {
                        if (!logger.isLoggable(Level.CONFIG)) throw throwable;
                        msg = msg != null ? msg : ADFPlatformMessageBundle.get(MSG_KEY);
                        logger.config(String.format(ADFPlatformMessageBundle.get("MT_HELPER_CONFIG_FORMAT"), msg, ret));
                    }
                    throw throwable;
                }
                Logger logger = Logger.getLogger(MTHelper.class.getName());
                if (logger.isLoggable(Level.FINE) && tt != null) {
                    logger.log(Level.FINE, MSG_KEY + ", ret=" + ret, tt);
                    return ret;
                } else {
                    if (!logger.isLoggable(Level.CONFIG)) return ret;
                    msg = msg != null ? msg : ADFPlatformMessageBundle.get(MSG_KEY);
                    logger.config(String.format(ADFPlatformMessageBundle.get("MT_HELPER_CONFIG_FORMAT"), msg, ret));
                }
                return ret;
            }
            Logger logger = Logger.getLogger(MTHelper.class.getName());
            if (logger.isLoggable(Level.FINE) && tt != null) {
                logger.log(Level.FINE, MSG_KEY + ", ret=" + ret, tt);
                return ret;
            } else {
                if (!logger.isLoggable(Level.CONFIG)) return ret;
                msg = msg != null ? msg : ADFPlatformMessageBundle.get(MSG_KEY);
                logger.config(String.format(ADFPlatformMessageBundle.get("MT_HELPER_CONFIG_FORMAT"), msg, ret));
            }
            return ret;
        }
    }
}

