/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.common.rc.util.impl;

import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.rc.util.impl.LRUReferenceMap;
import oracle.adf.share.common.util.ADFJarUtil;
import org.w3c.dom.Document;

public class JarDocumentCache {
    private static final Logger logger = Logger.getLogger(JarDocumentCache.class.getName());
    private static final String CACHE_LASTMOD_PARAM = "adflibrc.dom.cache.lastmod";
    private static final String CACHE_SIZE_PARAM = "adflibrc.dom.cache.size";
    private static final int CACHE_SIZE_DEFAULT = 50;
    private final Stats stats = new Stats();
    private final boolean CACHE_LASTMOD;
    private final int CACHE_SIZE;
    private final Map<String, Reference<Pair>> jarDocumentCache;

    public Stats getStats() {
        return this.stats;
    }

    public JarDocumentCache() {
        this(JarDocumentCache.initCacheSize());
    }

    public JarDocumentCache(int capacity) {
        this.jarDocumentCache = Collections.synchronizedMap(new LRUReferenceMap(capacity));
        this.CACHE_SIZE = capacity;
        this.CACHE_LASTMOD = JarDocumentCache.initCacheLastMod();
    }

    public Document getDocument(URL url) {
        if (this.CACHE_SIZE == 0) {
            return null;
        }
        if (!ADFJarUtil.isJarProtocol(url)) {
            this.stats.incNonJars(url);
            return null;
        }
        String cacheKey = url.toString();
        Reference<Pair> refPair = this.jarDocumentCache.get(cacheKey);
        if (refPair != null) {
            Pair pair = refPair.get();
            if (pair != null) {
                if (!this.isLastModCheck(url)) {
                    this.stats.incHits(url);
                    return pair.document;
                }
                if (pair.lastMod == this.getJarLastMod(url)) {
                    this.stats.incLastModHits(url);
                    return pair.document;
                }
            }
            this.jarDocumentCache.remove(cacheKey);
        }
        this.stats.incMisses(url);
        return null;
    }

    public void putDocument(URL url, Document document) {
        if (this.CACHE_SIZE == 0) {
            return;
        }
        if (!ADFJarUtil.isJarProtocol(url)) {
            return;
        }
        if (document == null && logger.isLoggable(Level.FINE)) {
            logger.info("Null document at: " + url);
        }
        Pair pair = new Pair(document);
        if (this.isLastModCheck(url)) {
            pair.lastMod = this.getJarLastMod(url);
        }
        this.stats.incPuts(url);
        this.jarDocumentCache.put(url.toString(), new SoftReference<Pair>(pair));
    }

    private final long getJarLastMod(URL url) {
        int fileColon;
        String path = url.getPath();
        int jarBang = path.lastIndexOf(33);
        if (jarBang != -1) {
            path = path.substring(0, jarBang);
        }
        if ((fileColon = path.indexOf(58)) != -1 && path.substring(0, fileColon).equalsIgnoreCase("file")) {
            path = path.substring(fileColon + 1);
        }
        return new File(path).lastModified();
    }

    private final boolean isLastModCheck(URL url) {
        if (!this.CACHE_LASTMOD) {
            return false;
        }
        boolean lastModCheck = true;
        String path = url.getPath();
        int jdeveloper = path.indexOf("/jdeveloper/");
        if (jdeveloper != -1) {
            String subPath = path.substring(jdeveloper + "/jdeveloper".length());
            int jdev = subPath.indexOf("/jdev/");
            if (jdev != -1) {
                lastModCheck = false;
            } else {
                int modules = subPath.indexOf("/modules/");
                if (modules != -1) {
                    lastModCheck = false;
                }
            }
        }
        return lastModCheck;
    }

    private static final boolean initCacheLastMod() {
        boolean ret = true;
        try {
            String propVal = JarDocumentCache.getSystemProperty(CACHE_LASTMOD_PARAM, "true");
            if (propVal != null) {
                ret = Boolean.valueOf(propVal);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Reading system property: adflibrc.dom.cache.lastmod", e);
        }
        logger.fine("Jar document cache lastMod: " + ret);
        return ret;
    }

    private static final int initCacheSize() {
        int retSize = 50;
        try {
            String propVal = JarDocumentCache.getSystemProperty(CACHE_SIZE_PARAM, String.valueOf(50));
            if (propVal != null) {
                retSize = Integer.valueOf(propVal);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Reading system property: adflibrc.dom.cache.size", e);
        }
        retSize = 0;
        logger.fine("Jar document cache size: " + retSize);
        return retSize;
    }

    private static final String getSystemProperty(final String propertyName, final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName, defaultValue);
            }
        });
    }

    private static class Pair {
        long lastMod = -1L;
        final Document document;

        public Pair(Document document) {
            this.document = document;
        }
    }

    public static class Stats {
        int misses = 0;
        int nonJars = 0;
        int puts = 0;
        int hits = 0;
        int lastModHits = 0;

        public final void incMisses(URL url) {
            ++this.misses;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(String.valueOf(url));
            }
        }

        public final void incNonJars(URL url) {
            ++this.nonJars;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(String.valueOf(url));
            }
        }

        public final void incPuts(URL url) {
            ++this.puts;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(String.valueOf(url));
            }
            if (logger.isLoggable(Level.FINE) && this.puts % 25 == 0) {
                logger.fine(">>>>>>>>>>>> " + this.toString());
            }
        }

        public final void incHits(URL url) {
            ++this.hits;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(String.valueOf(url));
            }
            if (logger.isLoggable(Level.FINE) && this.hits % 25 == 0) {
                logger.fine(">>>>>>>>>>>> " + this.toString());
            }
        }

        public final void incLastModHits(URL url) {
            ++this.lastModHits;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(String.valueOf(url));
            }
            if (logger.isLoggable(Level.FINE) && this.lastModHits % 25 == 0) {
                logger.fine(">>>>>>>>>>>> " + this.toString());
            }
        }

        public String toString() {
            return "hits=" + this.hits + ", misses=" + this.misses + ", lastModHits=" + this.lastModHits + ", puts=" + this.puts + ", nonJars=" + this.nonJars;
        }
    }
}

