/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.Color;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;
import sun.swing.DefaultLookup;

public class OracleTextAreaUI
extends BasicTextAreaUI {
    private static Border _sBorder;

    public static ComponentUI createUI(JComponent ta) {
        return new OracleTextAreaUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateBackground((JTextComponent)c);
    }

    @Override
    protected void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propName = e.getPropertyName();
        if ("ancestor".equals(propName)) {
            if (this.getComponent().getBorder() instanceof UIResource) {
                if (this.getComponent().getParent() instanceof JViewport) {
                    if (_sBorder == null) {
                        Border b = UIManager.getBorder("TextArea.border");
                        Insets i = b.getBorderInsets(this.getComponent());
                        _sBorder = new EmptyBorderUIResource(i.top, i.left, i.bottom, i.right);
                    }
                    this.getComponent().setBorder(_sBorder);
                } else {
                    this.getComponent().setBorder(UIManager.getBorder("TextArea.border"));
                }
            }
        } else if ("enabled".equals(e.getPropertyName())) {
            JTextComponent comp = this.getComponent();
            Color background = comp.getBackground();
            if (background instanceof UIResource) {
                LookAndFeel.installProperty(comp, "opaque", e.getNewValue());
            }
        } else if ("editable".equals(propName)) {
            this.updateBackground(this.getComponent());
        }
    }

    private void updateBackground(JTextComponent c) {
        Color background = c.getBackground();
        if (background == null || background instanceof UIResource) {
            String prefix = this.getPropertyPrefix();
            Color disabledBG = DefaultLookup.getColor(c, this, prefix + ".disabledBackground", null);
            Color inactiveBG = DefaultLookup.getColor(c, this, prefix + ".inactiveBackground", null);
            Color bg = DefaultLookup.getColor(c, this, prefix + ".background", null);
            if (background != disabledBG && background != inactiveBG && background != bg) {
                return;
            }
            Color newColor = null;
            if (!c.isEnabled()) {
                newColor = disabledBG;
            }
            if (newColor == null && !c.isEditable()) {
                newColor = inactiveBG;
            }
            if (newColor == null) {
                newColor = bg;
            }
            if (newColor != null && newColor != background) {
                c.setBackground(newColor);
            }
        }
    }

    private static class EmptyBorderUIResource
    extends EmptyBorder
    implements UIResource {
        public EmptyBorderUIResource(int top, int left, int bottom, int right) {
            super(top, left, bottom, right);
        }
    }
}

