/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.segmented;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import oracle.javatools.ui.PropertyChangeAdapter;
import oracle.javatools.ui.segmented.ActionSegment;
import oracle.javatools.ui.segmented.Segment;
import oracle.javatools.ui.segmented.SegmentedControl;

public final class SegmentButton<T>
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    private final SegmentedControl<T> segmentedControl;
    private final Segment<T> segment;

    public SegmentButton(Segment<T> segment, SegmentedControl<T> segmentedControl) {
        this.segment = segment;
        this.segmentedControl = segmentedControl;
        this.setText(segment.getText());
        this.setToolTipText(segment.getTooltip());
        this.setIcon(segment.getIcon());
        this.setSelectedIcon(segment.getSelectedIcon());
        this.setOpaque(false);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 4));
        if (segment instanceof ActionSegment) {
            this.setAction((Action)segment.getUserObject());
        }
    }

    public Segment<T> getSegment() {
        return this.segment;
    }

    public boolean isDefaultCapable() {
        return false;
    }

    @Override
    public Color getForeground() {
        if (this.segmentedControl == null) {
            return UIManager.getColor("Button.foreground");
        }
        if (!this.isEnabled()) {
            return UIManager.getColor("Button.disabledText");
        }
        return this.isSelected() ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("List.foreground");
    }

    @Override
    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new DefaultActionPropertyChangeListener(this, a);
    }

    private static class DefaultActionPropertyChangeListener
    extends PropertyChangeAdapter {
        public DefaultActionPropertyChangeListener(AbstractButton adaptee, Action action) {
            super(adaptee, action);
        }

        protected static boolean isLabelVisible(AbstractButton button) {
            Boolean hide = (Boolean)button.getClientProperty("hideActionText");
            return hide == null || hide == false;
        }

        @Override
        protected void nameChanged(PropertyChangeEvent e) {
            AbstractButton button = this.getAdaptee();
            if (DefaultActionPropertyChangeListener.isLabelVisible(button)) {
                button.setText((String)e.getNewValue());
            }
            this.tooltipChanged(e);
        }

        @Override
        protected void tooltipChanged(PropertyChangeEvent e) {
            AbstractButton button = this.getAdaptee();
            button.setToolTipText((String)button.getAction().getValue("ShortDescription"));
        }

        @Override
        protected void stateChanged(PropertyChangeEvent e) {
            AbstractButton button = this.getAdaptee();
            Boolean toggledState = (Boolean)e.getNewValue();
            if (button.isSelected() != toggledState.booleanValue()) {
                button.setSelected(toggledState);
            }
        }

        @Override
        protected void enabledChanged(PropertyChangeEvent e) {
            boolean isSelected;
            boolean state;
            AbstractButton button = this.getAdaptee();
            Action action = button.getAction();
            if (action.getValue("SwingSelectedKey") != null && (state = ((Boolean)action.getValue("SwingSelectedKey")).booleanValue()) != (isSelected = button.isSelected())) {
                button.setSelected(state);
            }
            super.enabledChanged(e);
        }

        @Override
        protected void smallIconChanged(PropertyChangeEvent e) {
            AbstractButton button = this.getAdaptee();
            if (DefaultActionPropertyChangeListener.isLabelVisible(button)) {
                button.setIcon((Icon)e.getNewValue());
            }
            super.smallIconChanged(e);
        }
    }
}

