/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import oracle.ide.hover.Hover;
import oracle.ide.hover.HoverFlavor;
import oracle.ide.hover.Hoverable;
import oracle.ide.hover.HoverableRegistry;
import oracle.javatools.ui.infotip.InfoTipHover;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;
import oracle.javatools.ui.infotip.templates.Template;

public final class InfoTipHoverFactory {
    private InfoTipHoverFactory() {
    }

    public static InfoTipHover fromComponent(JComponent parent, JComponent content) {
        HoverableImpl hoverableImpl = new HoverableImpl(parent, content);
        return hoverableImpl.getInfoTipHover();
    }

    public static InfoTipHover fromTemplate(JComponent parent, Template template) {
        TemplateHoverableImpl hoverableImpl = new TemplateHoverableImpl(parent, template);
        return hoverableImpl.getInfoTipHover();
    }

    public static InfoTipHover forTable(JTable table, TableInfoTipProvider tableInfoTipProvider) {
        TableHoverableImpl hoverableImpl = new TableHoverableImpl(table, tableInfoTipProvider);
        return hoverableImpl.getInfoTipHover();
    }

    public static interface TableInfoTipProvider {
        public Template getTipContentForCell(JTable var1, int var2, int var3, Point var4, List<HoverFlavor> var5);
    }

    private static class TableHoverableImpl
    extends HoverableImpl {
        private final TableInfoTipProvider provider;
        private final JTable table;

        TableHoverableImpl(JTable table, TableInfoTipProvider provider) {
            super(table, new JLabel("Placeholder"));
            this.provider = provider;
            this.table = table;
        }

        @Override
        public Hover hover(Point point, List<HoverFlavor> flavors) {
            Point p = new Point(point);
            SwingUtilities.convertPointFromScreen(p, this.table);
            int row = this.table.rowAtPoint(p);
            int col = this.table.columnAtPoint(p);
            if (row == -1 || col == -1) {
                return null;
            }
            Template template = this.provider.getTipContentForCell(this.table, row, col, p, flavors);
            if (template == null) {
                return null;
            }
            this.infoTipHover.setContent(template);
            this.infoTipHover.showHover();
            this.infoTipHover.setLocation(this.table.getCellRect(row, col, false));
            return this.infoTipHover;
        }
    }

    private static class TemplateHoverableImpl
    extends HoverableImpl {
        private Template template;

        TemplateHoverableImpl(JComponent parent, Template template) {
            super(parent, new JLabel("Placeholder"));
            this.template = template;
        }

        @Override
        public Hover hover(Point p, List<HoverFlavor> flavors) {
            if (this.template != null) {
                JComponent content = this.template.getContent();
                this.template = null;
                this.infoTipHover.setContent(new BasicTemplate(content));
            }
            return super.hover(p, flavors);
        }
    }

    private static class HoverableImpl
    implements Hoverable {
        protected final JComponent parent;
        protected InfoTipHover infoTipHover;

        HoverableImpl(JComponent parent, JComponent content) {
            this.parent = parent;
            this.initialize(new BasicTemplate(content));
        }

        private void initialize(Template template) {
            this.infoTipHover = new InfoTipHover(template, InfoTipStyles.DEFAULT, this.parent, new Rectangle(0, 0, this.parent.getWidth(), this.parent.getHeight()), HoverFlavor.getFlavor((String)"info"));
            AncestorListener listener = new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    HoverableRegistry.registerComponent((Component)parent, (Hoverable)this);
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    HoverableRegistry.unregisterComponent((Component)parent, (Hoverable)this);
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            };
            this.parent.addAncestorListener(listener);
            if (this.parent.isShowing()) {
                HoverableRegistry.registerComponent((Component)this.parent, (Hoverable)this);
            }
        }

        public Hover hover(Point p, List<HoverFlavor> flavors) {
            if (this.infoTipHover.isEnabled()) {
                this.infoTipHover.showHover();
                this.infoTipHover.setLocation(new Rectangle(0, 0, this.parent.getWidth(), this.parent.getHeight()));
                return this.infoTipHover;
            }
            return null;
        }

        InfoTipHover getInfoTipHover() {
            return this.infoTipHover;
        }
    }

    public static interface LazyContent {
        public JComponent createContent();
    }
}

