/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.combo;

import javax.swing.ComboBoxModel;
import javax.swing.JTree;
import javax.swing.event.ListDataListener;
import javax.swing.tree.TreePath;

public class TreeComboModel
implements ComboBoxModel {
    private Object _selectedObject;
    private JTree _tree;

    public TreeComboModel(JTree tree) {
        this._tree = tree;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        Object treeSelObj;
        this._selectedObject = anItem;
        TreePath selPath = this._tree.getSelectionPath();
        if (selPath != null && (treeSelObj = selPath.getLastPathComponent()) != null && treeSelObj == anItem) {
            return;
        }
        TreePath newSelPath = this.getTreePath(anItem);
        this._tree.setSelectionPath(newSelPath);
        this._tree.scrollPathToVisible(newSelPath);
    }

    public TreePath getTreePath(Object obj) {
        return this._findObject(obj, this._tree.getModel().getRoot(), new TreePath(this._tree.getModel().getRoot()));
    }

    private TreePath _findObject(Object findObj, Object node, TreePath pathToNode) {
        if (findObj == node) {
            return pathToNode;
        }
        for (int i = 0; i < this._tree.getModel().getChildCount(node); ++i) {
            TreePath childPath;
            Object childNode = this._tree.getModel().getChild(node, i);
            TreePath tp = this._findObject(findObj, childNode, childPath = pathToNode.pathByAddingChild(childNode));
            if (tp == null) continue;
            return tp;
        }
        return null;
    }

    @Override
    public Object getSelectedItem() {
        return this._selectedObject;
    }

    @Override
    public int getSize() {
        return this._tree.getRowCount();
    }

    @Override
    public Object getElementAt(int index) {
        TreePath path = this._tree.getPathForRow(index);
        return path == null ? null : path.getLastPathComponent();
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }
}

