/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Font;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontManager;
import sun.font.PhysicalFont;

public final class Fonts {
    private static Method _sfindFont2DMethod;
    private static FontManager _sFontManager;
    private static boolean _foundFM;

    private Fonts() {
    }

    public static Font deriveFont(Font originalFont, int style, float size) {
        try {
            Font.class.getDeclaredConstructor(Font.class);
            return originalFont.deriveFont(style, size);
        }
        catch (NoSuchMethodException e) {
            return Fonts.deriveFontIn15(originalFont, style, size);
        }
    }

    private static Font deriveFontIn15(Font originalFont, int style, float size) {
        Font newFont = Fonts.newFont(originalFont.getName(), style, size);
        boolean created = Fonts.isCreated(originalFont);
        Fonts.setCreated(newFont, created);
        Font2DHandle handle = Fonts.getFont2DHandle(originalFont);
        if (handle == null) {
            return originalFont.deriveFont(style, size);
        }
        if (handle.font2D instanceof CompositeFont) {
            created = true;
        }
        if (created) {
            if (handle.font2D instanceof CompositeFont && handle.font2D.getStyle() != style) {
                Fonts.setFont2DHandle(newFont, Fonts.getNewComposite(null, style, handle));
            } else {
                Fonts.setFont2DHandle(newFont, handle);
            }
        }
        return newFont;
    }

    private static void setFont2DHandle(Font font, Font2DHandle handle) {
        try {
            Field f = Font.class.getDeclaredField("font2DHandle");
            f.setAccessible(true);
            f.set(font, handle);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Font2DHandle getFont2DHandle(Font font) {
        try {
            Field f = Font.class.getDeclaredField("font2DHandle");
            f.setAccessible(true);
            return (Font2DHandle)f.get(font);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static void setCreated(Font font, boolean created) {
        try {
            Field f = Font.class.getDeclaredField("createdFont");
            f.setAccessible(true);
            f.set(font, created);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean isCreated(Font font) {
        try {
            Field f = Font.class.getDeclaredField("createdFont");
            f.setAccessible(true);
            return (Boolean)f.get(font);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Font newFont(String name, int style, float size) {
        try {
            Constructor ctor = Font.class.getDeclaredConstructor(String.class, Integer.TYPE, Float.TYPE);
            ctor.setAccessible(true);
            return (Font)ctor.newInstance(name, style, Float.valueOf(size));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Font2DHandle getNewComposite(String family, int style, Font2DHandle handle) {
        Font2D newFont;
        if (!(handle.font2D instanceof CompositeFont)) {
            return handle;
        }
        CompositeFont oldComp = (CompositeFont)handle.font2D;
        PhysicalFont oldFont = oldComp.getSlotFont(0);
        if (family == null) {
            family = oldFont.getFamilyName(null);
        }
        if (style == -1) {
            style = oldComp.getStyle();
        }
        if (!((newFont = Fonts.findFont2D(family, style, 0)) instanceof PhysicalFont)) {
            newFont = oldFont;
        }
        PhysicalFont physicalFont = (PhysicalFont)newFont;
        CompositeFont dialog2D = (CompositeFont)Fonts.findFont2D("dialog", style, 0);
        if (dialog2D == null) {
            return handle;
        }
        CompositeFont compFont = Fonts.newCompositeFont(physicalFont, dialog2D);
        Font2DHandle newHandle = new Font2DHandle(compFont);
        return newHandle;
    }

    private static CompositeFont newCompositeFont(PhysicalFont physical, CompositeFont font) {
        try {
            Constructor ctor = CompositeFont.class.getDeclaredConstructor(PhysicalFont.class, CompositeFont.class);
            ctor.setAccessible(true);
            return (CompositeFont)ctor.newInstance(physical, font);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final Font2D findFont2D(String name, int style, int fallBack) {
        if (_sfindFont2DMethod == null) {
            try {
                _sfindFont2DMethod = FontManager.class.getMethod("findFont2D", String.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!_foundFM) {
            try {
                Class<?> fontManagerFactoryClass = Class.forName("sun.font.FontManagerFactory");
                Method m = fontManagerFactoryClass.getMethod("getInstance", null);
                _sFontManager = (FontManager)m.invoke(null, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            _foundFM = true;
        }
        if (_sfindFont2DMethod != null) {
            try {
                return (Font2D)_sfindFont2DMethod.invoke((Object)_sFontManager, name, style, fallBack);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        _foundFM = false;
    }
}

