/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Color;
import oracle.bali.ewt.graphics.ColorUtils;

public class ColorUtils2
extends ColorUtils {
    public static final Color TRANSPARENT = new Color(0, 0, 0, 0);

    public static Color getCompliment(Color c) {
        double[] hsb = ColorUtils2.colorToHSB((Color)c);
        hsb[0] = hsb[0] + 180.0;
        if (hsb[0] >= 360.0) {
            hsb[0] = hsb[0] - 360.0;
        }
        return ColorUtils2.hsbToColor((double)hsb[0], (double)hsb[1], (double)hsb[2]);
    }

    public static Color getTriad(Color c, int index) {
        if (index < 0 || index > 2) {
            throw new IllegalArgumentException("index out of range. Must be between 0 and 2 inclusive : " + index);
        }
        double[] hsb = ColorUtils2.colorToHSB((Color)c);
        hsb[0] = hsb[0] + (double)(120 * index);
        if (hsb[0] >= 360.0) {
            hsb[0] = hsb[0] - 360.0;
        }
        return ColorUtils2.hsbToColor((double)hsb[0], (double)hsb[1], (double)hsb[2]);
    }

    public static Color getAnalogous(Color c, int index) {
        if (index < -1 || index > 1) {
            throw new IllegalArgumentException("index out of range. Must be between -1 and 1 inclusive : " + index);
        }
        double[] hsb = ColorUtils2.colorToHSB((Color)c);
        hsb[0] = hsb[0] + (double)(30 * index);
        if (hsb[0] >= 360.0) {
            hsb[0] = hsb[0] - 360.0;
        }
        if (hsb[0] < 0.0) {
            hsb[0] = hsb[0] + 360.0;
        }
        return ColorUtils2.hsbToColor((double)hsb[0], (double)hsb[1], (double)hsb[2]);
    }

    public static Color getTetrad(Color c, int index) {
        if (index < 0 || index > 3) {
            throw new IllegalArgumentException("index out of range. Must be between 0 and 3 inclusive : " + index);
        }
        double[] hsb = ColorUtils2.colorToHSB((Color)c);
        hsb[0] = hsb[0] + (double)(90 * index);
        if (hsb[0] >= 360.0) {
            hsb[0] = hsb[0] - 360.0;
        }
        if (hsb[0] < 0.0) {
            hsb[0] = hsb[0] + 360.0;
        }
        return ColorUtils2.hsbToColor((double)hsb[0], (double)hsb[1], (double)hsb[2]);
    }

    public static Color shadeColorPercent(Color c, double percent) {
        return ColorUtils2.shadeColor((Color)c, (int)((int)(percent / 100.0 * 255.0)));
    }

    public static Color saturateColor(Color c, double percent) {
        double[] hsl = ColorUtils2.colorToHSL((Color)c);
        double s = hsl[1] / 100.0 * percent;
        s = Math.max(0.0, s);
        s = Math.min(100.0, s);
        Color newC = ColorUtils2.hslToColor((double)hsl[0], (double)s, (double)hsl[2]);
        return newC;
    }

    public static Color adjustHue(Color c, int degress) {
        double[] hsb = ColorUtils2.colorToHSB((Color)c);
        hsb[0] = hsb[0] + (double)degress;
        if (hsb[0] >= 360.0) {
            hsb[0] = hsb[0] - 360.0;
        }
        if (hsb[0] < 0.0) {
            hsb[0] = hsb[0] + 360.0;
        }
        return ColorUtils2.hsbToColor((double)hsb[0], (double)hsb[1], (double)hsb[2]);
    }

    public static Color alphaColor(Color c, int alpha) {
        Color newC = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        return newC;
    }

    public static Color alphaColor(Color c, float alpha) {
        float[] rgb = c.getRGBColorComponents(null);
        Color newC = new Color(rgb[0], rgb[1], rgb[2], alpha);
        return newC;
    }

    public static Color getTweenColor(Color c1, Color c2, float weight) {
        float[] hsb1 = new float[3];
        float[] hsb2 = new float[3];
        Color.RGBtoHSB(c1.getRed(), c1.getGreen(), c1.getBlue(), hsb1);
        Color.RGBtoHSB(c2.getRed(), c2.getGreen(), c2.getBlue(), hsb2);
        float h = Math.max(0.0f, Math.min(1.0f, hsb2[0]));
        float weight2 = 1.0f - weight;
        float s = Math.max(0.0f, Math.min(1.0f, weight * hsb1[1] + hsb2[1] * weight2));
        float b = Math.max(0.0f, Math.min(1.0f, weight * hsb1[2] + hsb2[2] * weight2));
        Color c3 = Color.getHSBColor(h, s, b);
        return c3;
    }

    public static Color getStringColor(String text) {
        int nameHash = Math.abs(text.hashCode());
        StringBuffer stringHash = new StringBuffer(Integer.toString(nameHash));
        stringHash.reverse();
        stringHash.append("123546");
        String redString = stringHash.substring(0, 2);
        String greenString = stringHash.substring(2, 4);
        String blueString = stringHash.substring(4, 6);
        int rInt = Integer.parseInt(redString) / 3;
        int gInt = Integer.parseInt(greenString) / 3;
        int bInt = Integer.parseInt(blueString) / 3;
        int r = 255 - rInt;
        int g = 255 - gInt;
        int b = 255 - bInt;
        Color c = new Color(r, g, b);
        return c;
    }
}

