/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipOutputHandler {
    ZipOutputStream _out;
    ZipEntry _entry;
    FileOutputStream _fout;
    ZipOutputStream _zout;
    OutputStreamWriter _stringWriter;
    String _encoding;
    String _fileName;
    boolean _entryOpened = false;
    private ArrayList<String> _createdEntries;

    public void openZip(String string) throws FileNotFoundException {
        this._out = new ZipOutputStream(new FileOutputStream(string));
        this._createdEntries = new ArrayList();
    }

    public void closeZip() throws IOException {
        this._out.close();
    }

    public void setEncoding(String string) {
        this._encoding = string;
    }

    public void openEntry(String string) throws IOException {
        this._fileName = string;
        this._entryOpened = false;
    }

    public void openEntry() throws IOException {
        ZipEntry zipEntry = new ZipEntry(this._fileName);
        this._createdEntries.add(this._fileName.toString());
        this._out.putNextEntry(zipEntry);
        this._entryOpened = true;
    }

    public void writeEntryText(String string) throws IOException {
        int n;
        if (!this._entryOpened) {
            this.openEntry();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(Charset.forName("UTF-8")));
        byte[] byArray = new byte[4096];
        while ((n = byteArrayInputStream.read(byArray)) != -1) {
            this._out.write(byArray, 0, n);
        }
    }

    public void writeEntryBinaryStream(InputStream inputStream) throws IOException {
        int n;
        if (!this._entryOpened) {
            this.openEntry();
        }
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            this._out.write(byArray, 0, n);
        }
    }

    public void writeEntryCharStream(Reader reader) throws IOException {
        int n;
        if (!this._entryOpened) {
            this.openEntry();
        }
        char[] cArray = new char[4096];
        String string = null;
        byte[] byArray = new byte[4096];
        while ((n = reader.read(cArray)) != -1) {
            string = new String(cArray);
            byArray = string.getBytes(Charset.forName("UTF-8"));
            this._out.write(byArray, 0, n);
        }
    }

    public void writeFileEntry(String string) throws IOException {
        this.writeFileEntry(string, true);
    }

    public void writeFileEntry(String string, boolean bl) throws IOException {
        File file = new File(string);
        this.writeFileEntry(file.toURI().toURL(), bl);
    }

    public void writeFileEntry(URL uRL) throws IOException {
        this.writeFileEntry(uRL, true);
    }

    public void writeFileEntry(URL uRL, boolean bl) throws IOException {
        int n;
        File file = null;
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (file.length() == 0L) {
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(file.getName());
        this._out.putNextEntry(zipEntry);
        this._createdEntries.add(file.getName());
        byte[] byArray = new byte[4096];
        while ((n = fileInputStream.read(byArray)) != -1) {
            this._out.write(byArray, 0, n);
        }
        fileInputStream.close();
    }

    public void writeFileEntry(String string, String string2, boolean bl) throws IOException {
        int n;
        File file = null;
        file = new File(string);
        if (file.length() == 0L) {
            return;
        }
        if (file.isDirectory()) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(string2);
        this._out.putNextEntry(zipEntry);
        this._createdEntries.add(string2);
        byte[] byArray = new byte[4096];
        while ((n = fileInputStream.read(byArray)) != -1) {
            this._out.write(byArray, 0, n);
        }
        fileInputStream.close();
    }

    public void flush() throws IOException {
    }

    public void closeEntry() throws IOException {
        this._out.closeEntry();
    }

    public void addSQLControllingFile(String string, String string2, boolean bl) throws IOException {
        this.openEntry(string);
        if (string2 != null) {
            this.writeEntryText(string2);
        }
        this._createdEntries.remove(this._createdEntries.size() - 1);
        if (bl) {
            for (String string3 : this._createdEntries) {
                if (string3.endsWith(".sql")) {
                    this.writeEntryText("@" + string3 + "\n");
                    continue;
                }
                this.writeEntryText("--@" + string3 + "\n");
            }
        } else {
            for (String string4 : this._createdEntries) {
                if (string4.endsWith(".sql")) {
                    this.writeEntryText("SQL " + string4 + "\n");
                    continue;
                }
                if (!string4.endsWith(".ctl")) continue;
                this.writeEntryText("LDR " + string4 + "\n");
            }
        }
        this.closeEntry();
    }

    public String getUniqueEntryName(String string, String string2) {
        String string3 = string + string2;
        int n = 0;
        while (this._createdEntries.contains(string3)) {
            string3 = string + "_" + ++n + string2;
        }
        return string3;
    }
}

