/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils.oerr;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.raptor.utils.oerr.GetFile;
import oracle.dbtools.raptor.utils.oerr.Messages;
import oracle.dbtools.raptor.utils.oerr.SAXHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class WriteXML {
    private DocumentBuilderFactory factory = null;
    private DocumentBuilder builder = null;
    private Document document = null;
    private Document indexDocument = null;
    private Document sequenceDocument = null;
    private Element root = null;
    private Element indexRoot = null;
    private Element sequenceRoot = null;
    private SAXParserFactory _factory;
    private URL indexDirectory;
    private String localBaseName = null;
    private String localFileSequence = null;
    private String localLanguage = null;

    public static void main(String[] stringArray) throws Exception {
        WriteXML writeXML = new WriteXML();
        writeXML.doit();
        writeXML.getora("002");
    }

    public void setupIndexFile(String string) {
        try {
            this.indexDirectory = new URL(string);
            if (this.factory == null) {
                this.factory = DocumentBuilderFactory.newInstance();
                this.factory.setCoalescing(true);
                this.builder = this.factory.newDocumentBuilder();
            }
            this.indexDocument = this.builder.newDocument();
            this.indexRoot = this.indexDocument.createElement("index");
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void startSequenceFile(String string, String string2, String string3) {
        try {
            this.localBaseName = string;
            this.localFileSequence = string2;
            this.localLanguage = string3;
            if (this.factory == null) {
                this.factory = DocumentBuilderFactory.newInstance();
                this.factory.setCoalescing(true);
                this.builder = this.factory.newDocumentBuilder();
            }
            this.sequenceDocument = this.builder.newDocument();
            this.sequenceRoot = this.sequenceDocument.createElement(string);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void addIndexLine(String string, String string2, String string3, String string4, String string5) {
        Element element = this.indexDocument.createElement("fileIndex");
        element.setAttribute("basename", string);
        element.setAttribute("sequence", string2);
        element.setAttribute("language", string3);
        element.setAttribute("min", string4);
        element.setAttribute("max", string5);
        this.indexRoot.appendChild(element);
    }

    void getora(String string) {
        this.setupSax(string);
    }

    void getByIndex(String string, String string2, String string3) {
        try {
            this.indexDirectory = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        long l = System.currentTimeMillis();
        String string4 = this.getIndexFile(false, string2, string3);
        System.out.println(Messages.getString("WriteXML.9") + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        this.outputMatch(false, string4, string3);
        System.out.println(Messages.getString("WriteXML.8") + (System.currentTimeMillis() - l));
    }

    public String oerr(String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n = string.indexOf(45);
        if (n != -1) {
            string3 = string.substring(0, n);
            String string5 = string.substring(n);
            if (string5.matches("^[0-9]+")) {
                int n2 = 0;
                for (n2 = 0; n2 < string5.length(); ++n2) {
                    if (Character.isDigit(string5.charAt(n2))) continue;
                    string4 = string5.substring(0, n2);
                    break;
                }
                if (n2 == string5.length()) {
                    string4 = string5;
                }
                string2 = this.oerr(string3, string4);
            }
        }
        return string2;
    }

    public String oerr(String string, String string2) {
        String string3 = "";
        if (!(string = string.toLowerCase()).equals("tns") && !string.equals("ora")) {
            return Messages.getString("WriteXML.17");
        }
        try {
            long l = System.currentTimeMillis();
            String string4 = this.getIndexFile(true, string, string2);
            System.out.println(Messages.getString("WriteXML.18") + (System.currentTimeMillis() - l));
            if (string4 != null && string4 != "") {
                l = System.currentTimeMillis();
                string3 = this.outputMatch(true, string4, string2);
                System.out.println(Messages.getString("WriteXML.20") + (System.currentTimeMillis() - l));
            }
        }
        catch (Exception exception) {
            string3 = "";
        }
        return string3;
    }

    private String getIndexFile(boolean bl, String string, String string2) {
        try {
            Object object;
            BufferedInputStream bufferedInputStream = null;
            if (!bl) {
                object = new URL(this.indexDirectory + File.separator + "index.xml");
                bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(((URL)object).toURI())));
            } else {
                object = this.getClass().getResourceAsStream("index.xml");
                bufferedInputStream = new BufferedInputStream((InputStream)object);
            }
            if (this._factory == null) {
                this._factory = SAXParserFactory.newInstance();
                this._factory.setValidating(false);
            }
            Object object2 = object = new GetFile(string, string2);
            long l = System.currentTimeMillis();
            this._factory.newSAXParser().parse((InputStream)bufferedInputStream, (DefaultHandler)object2);
            System.out.println("do parse:" + (System.currentTimeMillis() - l));
            return ((GetFile)object).lookfor;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            return "";
        }
    }

    private String outputMatch(boolean bl, String string, String string2) {
        String string3 = "";
        try {
            Object object;
            BufferedInputStream bufferedInputStream = null;
            if (bl) {
                System.out.println(string);
                object = this.getClass().getResourceAsStream(string);
                bufferedInputStream = new BufferedInputStream((InputStream)object);
            }
            if (this._factory == null) {
                this._factory = SAXParserFactory.newInstance();
                this._factory.setValidating(false);
            }
            Object object2 = object = new SAXHandler(string2);
            InputSource inputSource = new InputSource(bufferedInputStream);
            inputSource.setEncoding("UTF-8");
            this._factory.newSAXParser().parse(inputSource, (DefaultHandler)object2);
            System.out.println(((SAXHandler)object).lookfor.toString());
            if (((SAXHandler)object).lookfor.toString() != null && !((SAXHandler)object).lookfor.toString().equals("")) {
                string3 = ((SAXHandler)object).lookfor.toString();
            }
        }
        catch (Exception exception) {
            string3 = "";
        }
        return string3;
    }

    void setupSax(String string) {
        try {
            SAXHandler sAXHandler;
            URL uRL = new URL("/tmp/reallyworks_");
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(uRL.toURI())));
            if (this._factory == null) {
                this._factory = SAXParserFactory.newInstance();
            }
            this._factory.setValidating(false);
            SAXHandler sAXHandler2 = sAXHandler = new SAXHandler(string);
            this._factory.newSAXParser().parse((InputStream)bufferedInputStream, (DefaultHandler)sAXHandler2);
            System.out.println(sAXHandler.lookfor.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setup() throws Exception {
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setCoalescing(true);
        this.builder = this.factory.newDocumentBuilder();
        this.document = this.builder.newDocument();
        this.root = this.document.createElement("errors");
    }

    void writeOneSequence(String string, String string2) {
        Element element = this.sequenceDocument.createElement("payload");
        element.setAttribute("number", string);
        element.appendChild(this.sequenceDocument.createTextNode(string2));
        this.sequenceRoot.appendChild(element);
    }

    void writeOne(String string, String string2) {
        Element element = this.document.createElement("payload");
        element.setAttribute("number", string);
        element.appendChild(this.document.createTextNode(string2));
        this.root.appendChild(element);
    }

    void writeOnemanyelements(String string, String string2) {
        Element element = this.document.createElement("cover");
        Element element2 = this.document.createElement("number");
        element2.appendChild(this.document.createTextNode(string));
        element.appendChild(element2);
        Element element3 = this.document.createElement("payload");
        element3.appendChild(this.document.createTextNode(string2));
        element.appendChild(element3);
        this.root.appendChild(element);
    }

    void doit() {
        try {
            this.setup();
            this.writeOne("001", "Payload1");
            this.writeOne("002", "& <! Payload2 & <! ");
            this.document.appendChild(this.root);
            WriteXML.writeXmlFile(this.document, "/tmp/reallyworks_");
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            System.exit(1);
        }
    }

    void finishSequenceFile() {
        try {
            this.sequenceDocument.appendChild(this.sequenceRoot);
            WriteXML.writeXmlFile(this.sequenceDocument, this.indexDirectory + File.separator + this.localBaseName + this.localFileSequence + this.localLanguage + ".xml");
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            System.exit(1);
        }
    }

    void finishIndexFile() {
        try {
            this.indexDocument.appendChild(this.indexRoot);
            WriteXML.writeXmlFile(this.indexDocument, this.indexDirectory + File.separator + "index.xml");
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            System.exit(1);
        }
    }

    void finish() {
        try {
            this.document.appendChild(this.root);
            WriteXML.writeXmlFile(this.sequenceDocument, "/tmp/reallyworks_");
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            System.exit(1);
        }
    }

    public static void writeXmlFile(Document document, String string) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            URL uRL = new URL(string);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            stringWriter.close();
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(new File(uRL.toURI()));
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            outputStreamWriter.write(stringWriter.toString());
            outputStreamWriter.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            Logger.getLogger(WriteXML.class.getClass().getName()).log(Level.WARNING, transformerConfigurationException.getStackTrace()[0].toString(), transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            Logger.getLogger(WriteXML.class.getClass().getName()).log(Level.WARNING, transformerException.getStackTrace()[0].toString(), transformerException);
        }
        catch (IOException iOException) {
            Logger.getLogger(WriteXML.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }
}

